<?php // phpcs:ignore WordPress.Files.FileName
/**
 * Plugin Name: Booster Plus for WooCommerce
 * Requires Plugins: woocommerce
 * Plugin URI: https://booster.io
 * Description: Supercharge your WooCommerce site with these awesome powerful features. More than 100 modules. All in one WooCommerce plugin.
 * Version: 7.5.0
 * Author: Pluggabl LLC
 * Author URI: https://booster.io
 * Text Domain: woocommerce-jetpack
 * Domain Path: /langs
 * Copyright: © 2020 Pluggabl LLC.
 * WC tested up to: 10.3.3
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package Booster_Plus_For_WooCommerce
 **/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
update_option( 'wcj_site_key', 'Activated On Zhaket.com' );
update_option( 'wcj_site_key_status', false );
// Core functions.
require_once 'includes/functions/wcj-functions-core.php';
require_once __DIR__.'/includes/activatezhk/validate-locked.php';
// Check if WooCommerce is active.
if ( ! wcj_is_plugin_activated( 'woocommerce', 'woocommerce.php' ) ) {
	return;
}

// Declare WooCommerce HPOS compatibility.
add_action(
	'before_woocommerce_init',
	function () {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
);

// Check if Plus is active.
if ( 'woocommerce-jetpack.php' === basename( __FILE__ ) && wcj_is_plugin_activated( 'booster-plus-for-woocommerce', 'booster-plus-for-woocommerce.php' ) ) {
	return;
}

if ( ! defined( 'WCJ_PLUGIN_FILE' ) ) {
	/**
	 * WCJ_PLUGIN_FILE.
	 *
	 * @since 3.2.4
	 */
	define( 'WCJ_PLUGIN_FILE', __FILE__ );
}

if ( ! class_exists( 'WC_Jetpack' ) ) :

	/**
	 * Main WC_Jetpack Class
	 *
	 * @class   WC_Jetpack
	 * @version 6.0.0
	 * @since   1.0.0
	 */
	final class WC_Jetpack {


		/**
		 * Booster for WooCommerce version.
		 *
		 * @var   string
		 * @since 2.4.7
		 */
		public $version = '7.5.0';

		/**
		 * The single instance of the class
		 *
		 * @var WC_Jetpack The single instance of the class
		 */
		protected static $instances = null;


		/**
		 * Booster_Plus
		 *
		 * @version 6.0.0
		 * @since   5.3.3
		 *
		 * @var array
		 */
		public $options = array();

		/**
		 * Booster_Plus
		 *
		 * @version 7.1.6
		 *
		 * @var array
		 */
		public $shortcodes = array();

		/**
		 * Booster_Plus
		 *
		 * @version 7.1.6
		 *
		 * @var array
		 */
		public $modules = array();

		/**
		 * Booster_Plus
		 *
		 * @version 7.1.6
		 *
		 * @var array
		 */
		public $all_modules = array();

		/**
		 * Booster_Plus
		 *
		 * @version 7.1.6
		 *
		 * @var array
		 */
		public $module_statuses = array();

		/**
		 * Main WC_Jetpack Instance.
		 *
		 * Ensures only one instance of WC_Jetpack is loaded or can be loaded.
		 *
		 * @version 6.0.0
		 * @since   1.0.0
		 * @static
		 * @see    WCJ()
		 * @return WC_Jetpack - Main instance
		 */
		public static function instance() {
			if ( is_null( self::$instances ) ) {
				self::$instances = new self();
			}
			return self::$instances;
		}

		/**
		 * WC_Jetpack Constructor.
		 *
		 * @version 6.0.0
		 * @since   1.0.0
		 * @access  public
		 */
		public function __construct() {
			require_once 'includes/core/wcj-loader.php';
		}
	}

endif;

if ( ! function_exists( 'WCJ' ) ) {
	/**
	 * Returns the main instance of WC_Jetpack to prevent the need to use globals.
	 *
	 * @version 6.0.0
	 * @since   1.0.0
	 * @return  WC_Jetpack
	 */
	function WCJ() {  //phpcs:ignore
		return WC_Jetpack::instance();
	}
}
\d03cc48caea61771f8e6f27a77f49d::d6118163c8b192ac3e83d3d640f();


add_action(
	'before_woocommerce_init',
	function() {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
);

add_action( 'plugins_loaded', 'WCJ' );
