<?php
/**
 * Plugin Name: Hide Categories 
 * Description: مخفی سازی دسته بندی های خاص
 * Version: 1.0
 * Author: Reza Moeini
 */

if ( ! defined( 'ABSPATH' ) ) exit;

class Hide_Categories_And_Products {

    private $hidden_categories = array(4512, 12076, 16190, 6532, 16194, 16192, 10507, 4389);
    private $hidden_products = array();

    public function __construct() {
        add_action('init', array($this, 'set_hidden_products'));
        add_action('pre_get_posts', array($this, 'exclude_hidden_products'));
        add_filter('woocommerce_product_query_tax_query', array($this, 'exclude_hidden_categories_wc'));
        add_filter('posts_results', array($this, 'filter_hidden_products_everywhere'), 10, 2);
    }

    // گرفتن تمام محصولات دسته‌های مخفی
    public function set_hidden_products() {
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => -1,
            'fields' => 'ids',
            'tax_query' => array(
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'term_id',
                    'terms' => $this->hidden_categories,
                    'operator' => 'IN',
                ),
            ),
            'post_status' => 'publish',
        );
        $this->hidden_products = get_posts($args);
    }

    // مخفی کردن از جستجو، آرشیو، فروشگاه و صفحه اصلی
    public function exclude_hidden_products($query) {
        if ( !is_admin() && $query->is_main_query() ) {
            if ($query->is_search() || $query->is_archive() || $query->is_home() || is_post_type_archive('product')) {
                $post__not_in = (array) $query->get('post__not_in');
                $post__not_in = array_merge($post__not_in, $this->hidden_products);
                $query->set('post__not_in', $post__not_in);
            }
        }
    }

    // مخفی کردن دسته‌ها در کوئری ووکامرس
    public function exclude_hidden_categories_wc($tax_query) {
        $tax_query[] = array(
            'taxonomy' => 'product_cat',
            'field' => 'term_id',
            'terms' => $this->hidden_categories,
            'operator' => 'NOT IN',
        );
        return $tax_query;
    }

    // مخفی کردن محصولات در تمام جاها (ویجت‌ها، شورتکدها، محصولات مرتبط، upsell و cross-sell)
    public function filter_hidden_products_everywhere($posts, $query) {
        if (!empty($posts) && is_array($posts)) {
            $posts = array_filter($posts, function($post) {
                return !in_array($post->ID, $this->hidden_products);
            });
        }
        return $posts;
    }
}

new Hide_Categories_And_Products();
