<?php

add_action('woocommerce_before_add_to_cart_form', 'bps_add_button_html');
function bps_add_button_html() {
    ?>
    <div class="bps-button" style="margin-bottom:15px; display:inline-block; background:#f39c12; color:#fff; padding:10px 15px; border-radius:10px; cursor:pointer; text-align:center;">
        قیمت بهتری سراغ داری؟
    </div>
    <?php
}

add_action('wp_footer', 'bps_modal_and_scripts');
function bps_modal_and_scripts() {
    if (!is_product()) return;

    $user_logged_in = is_user_logged_in() ? 'true' : 'false';
    ?>
    <style>
    #bps-modal {
        display: none;
        position: fixed;
        z-index: 9999;
        left: 0; top: 0;
        width: 100%; height: 100%;
        background-color: rgba(0,0,0,0.5);
    }
    #bps-modal-content {
        background: #fff;
        width: 90%;
        max-width: 400px;
        margin: 10% auto;
        padding: 20px;
        border-radius: 12px;
        text-align: right;
        direction: rtl;
        box-shadow: 0 0 20px rgba(0,0,0,0.3);
    }
    #bps-modal-content input[type="text"],
    #bps-modal-content input[type="url"] {
        width: 100%;
        padding: 10px;
        margin: 8px 0;
        border-radius: 8px;
        border: 1px solid #ccc;
    }
    #bps-modal-content button {
        background-color: #008CBA;
        color: white;
        border: none;
        padding: 10px 16px;
        border-radius: 8px;
        cursor: pointer;
        margin-top: 10px;
    }
    #bps-close {
        float: left;
        font-size: 20px;
        cursor: pointer;
    }
    </style>

    <div id="bps-modal">
        <div id="bps-modal-content">
            <span id="bps-close">&times;</span>
            <h3>قیمت بهتری سراغ داری؟</h3>
            <form id="bps-form">
                <input type="text" name="better_price" placeholder="قیمت پیشنهادی (تومان)" required />
                <input type="url" name="competitor_link" placeholder="لینک سایت رقیب مثال » https://google.com" required />
                <button type="submit">ارسال پیشنهاد</button>
            </form>
            <div id="bps-result" style="margin-top:10px; color:green;"></div>
        </div>
    </div>

    <script>
    document.addEventListener("DOMContentLoaded", function(){
        const modal = document.getElementById("bps-modal");
        const openBtn = document.querySelector(".bps-button");
        const userLoggedIn = <?php echo $user_logged_in; ?>;

        if (openBtn) {
            openBtn.addEventListener("click", () => {
                if (!userLoggedIn) {
                    window.location.href = "<?php echo esc_url(site_url('/my-account/')); ?>";
                } else {
                    modal.style.display = "block";
                }
            });
        }

        document.getElementById("bps-close").onclick = function() {
            modal.style.display = "none";
        };

        document.getElementById("bps-form").onsubmit = function(e) {
            e.preventDefault();
            const price = this.better_price.value;
            const link = this.competitor_link.value;

            fetch("<?php echo admin_url('admin-ajax.php'); ?>", {
                method: "POST",
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: new URLSearchParams({
                    action: "bps_submit",
                    price: price,
                    link: link,
                    product: "<?php echo get_the_title(); ?>"
                })
            })
            .then(res => res.text())
            .then(response => {
                document.getElementById("bps-result").innerText = "پیشنهاد شما ارسال شد. متشکریم!";
                this.reset();
            });
        };
    });
    </script>
    <?php
}

add_action('wp_ajax_bps_submit', 'bps_handle_ajax');
add_action('wp_ajax_nopriv_bps_submit', 'bps_handle_ajax');

function bps_handle_ajax() {
    $price = sanitize_text_field($_POST['price']);
    $link = esc_url_raw($_POST['link']);
    $product = sanitize_text_field($_POST['product']);
    $user_id = get_current_user_id();
    $user_info = get_userdata($user_id);
    $user_login = $user_info ? $user_info->user_login : 'مهمان';

    // گرفتن آرایه قبلی پیشنهادات
    $submissions = get_option('bps_submissions', []);
    
    // افزودن پیشنهاد جدید به آرایه
    $submissions[] = [
        'user' => $user_login,
        'product' => $product,
        'price' => $price,
        'link' => $link,
        'date' => current_time('Y-m-d H:i:s'),
    ];

    // ذخیره مجدد
    update_option('bps_submissions', $submissions);

    wp_mail(get_option('admin_email'), "پیشنهاد قیمت بهتر برای محصول: $product", "قیمت پیشنهادی: $price تومان\nلینک رقیب: $link");

    wp_die();
}

// ایجاد منو در پیشخوان برای نمایش پیشنهادات
add_action('admin_menu', 'bps_admin_menu');
function bps_admin_menu() {
    add_menu_page(
        'پیشنهادات قیمت بهتر',
        'پیشنهادات قیمت بهتر',
        'manage_options',
        'bps_submissions_page',
        'bps_submissions_page_callback',
        'dashicons-chart-line',
        56
    );
}

function bps_submissions_page_callback() {
    if (!current_user_can('manage_options')) {
        wp_die('دسترسی ندارید.');
    }

    $submissions = get_option('bps_submissions', []);

    echo '<div class="wrap"><h1>پیشنهادات قیمت بهتر</h1>';

    if (empty($submissions)) {
        echo '<p>هنوز پیشنهادی ثبت نشده است.</p>';
    } else {
        echo '<table class="wp-list-table widefat fixed striped">';
        echo '<thead><tr><th>کاربر</th><th>محصول</th><th>قیمت پیشنهادی (تومان)</th><th>لینک سایت رقیب</th><th>تاریخ ارسال</th></tr></thead><tbody>';
        foreach ($submissions as $item) {
            echo '<tr>';
            echo '<td>' . esc_html($item['user']) . '</td>';
            echo '<td>' . esc_html($item['product']) . '</td>';
            echo '<td>' . esc_html($item['price']) . '</td>';
            echo '<td><a href="' . esc_url($item['link']) . '" target="_blank">' . esc_html($item['link']) . '</a></td>';
            echo '<td>' . esc_html($item['date']) . '</td>';
            echo '</tr>';
        }
        echo '</tbody></table>';
    }

    echo '</div>';
}
