<?php

add_action('woocommerce_single_product_summary', function () {
    if (!current_user_can('manage_woocommerce')) return;

    global $product;
    $product_id = $product->get_id();
    $product_title = $product->get_name(); 
    $price = $product->get_price();
    $sale_price = $product->get_sale_price();
    $stock = $product->get_stock_quantity();
    $sale_start = $product->get_date_on_sale_from() ? $product->get_date_on_sale_from()->date('Y-m-d') : '';
    $sale_end = $product->get_date_on_sale_to() ? $product->get_date_on_sale_to()->date('Y-m-d') : '';
    $dina_meta = get_post_meta($product_id, 'dina_public_meta_value_one', true);
    ?>
    <div style="margin-top:40px; padding:20px; border:2px solid #ccc;">
        <h3>🔧 ویرایش سریع محصول (فقط ادمین)</h3>
        <label>عنوان محصول: <input type="text" id="admin_product_title" value="<?php echo esc_attr($product_title); ?>"></label><br><br> 
        <label>قیمت عادی: <input type="number" step="0.01" id="admin_price" value="<?php echo esc_attr($price); ?>"></label><br><br>
        <label>قیمت فروش ویژه: <input type="number" step="0.01" id="admin_sale_price" value="<?php echo esc_attr($sale_price); ?>"></label><br><br>
        <label>تاریخ شروع فروش ویژه: <input type="date" id="admin_sale_start" value="<?php echo esc_attr($sale_start); ?>"></label><br><br>
        <label>تاریخ پایان فروش ویژه: <input type="date" id="admin_sale_end" value="<?php echo esc_attr($sale_end); ?>"></label><br><br>
        <label>موجودی: <input type="number" id="admin_stock" value="<?php echo esc_attr($stock); ?>"></label><br><br>
        <label>گارانتی : <input type="text" id="admin_dina_meta" value="<?php echo esc_attr($dina_meta); ?>"></label><br><br>

        <button id="save_admin_edit" data-product="<?php echo $product_id; ?>">💾 ذخیره تغییرات</button>
        <p id="admin_update_result" style="margin-top:10px; color:green;"></p>
    </div>

    <script>
    document.getElementById('save_admin_edit').addEventListener('click', function () {
        const productTitle = document.getElementById('admin_product_title').value; 
        const price = document.getElementById('admin_price').value;
        const sale_price = document.getElementById('admin_sale_price').value;
        const sale_start = document.getElementById('admin_sale_start').value;
        const sale_end = document.getElementById('admin_sale_end').value;
        const stock = document.getElementById('admin_stock').value;
        const dina_meta = document.getElementById('admin_dina_meta').value;
        const productId = this.dataset.product;
        const resultBox = document.getElementById('admin_update_result');

        fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                action: 'admin_update_product_fields',
                product_id: productId,
                product_title: productTitle,
                price: price,
                sale_price: sale_price,
                sale_start: sale_start,
                sale_end: sale_end,
                stock: stock,
                dina_meta: dina_meta,
                _wpnonce: '<?php echo wp_create_nonce('admin_edit_fields'); ?>'
            })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                resultBox.style.color = 'green';
                resultBox.textContent = '✅ تغییرات ذخیره شد';
            } else {
                resultBox.style.color = 'red';
                resultBox.textContent = '❌ خطا در ذخیره‌سازی';
            }
        });
    });
    </script>
<?php
});

// پردازش ذخیره‌سازی با AJAX
add_action('wp_ajax_admin_update_product_fields', function () {
    if (!current_user_can('manage_woocommerce')) wp_send_json_error();
    if (!wp_verify_nonce($_POST['_wpnonce'], 'admin_edit_fields')) wp_send_json_error();

    $product_id = intval($_POST['product_id']);
    $product_title = sanitize_text_field($_POST['product_title']); 
    $price = floatval($_POST['price']);
    $sale_price = isset($_POST['sale_price']) && $_POST['sale_price'] !== '' ? floatval($_POST['sale_price']) : '';
    $sale_start = !empty($_POST['sale_start']) ? sanitize_text_field($_POST['sale_start']) : '';
    $sale_end = !empty($_POST['sale_end']) ? sanitize_text_field($_POST['sale_end']) : '';
    $stock = intval($_POST['stock']);
    $dina_meta = isset($_POST['dina_meta']) ? sanitize_text_field($_POST['dina_meta']) : '';

    $product = wc_get_product($product_id);
    if (!$product) wp_send_json_error();

    $product->set_name($product_title); 
    $product->set_regular_price($price);
    $product->set_sale_price($sale_price !== '' ? $sale_price : '');
    $product->set_date_on_sale_from($sale_start ? strtotime($sale_start) : '');
    $product->set_date_on_sale_to($sale_end ? strtotime($sale_end) : '');
    $product->set_stock_quantity($stock);
    $product->save();

  
    update_post_meta($product_id, 'dina_public_meta_value_one', $dina_meta);

    wp_send_json_success();
});

