<?php 


// نمایش کوپن‌های تاریخ‌دار در صفحه تسویه‌حساب زیر توضیحات سفارش
add_action('woocommerce_after_order_notes', function () {
    if (!is_checkout()) return;

    $args = [
        'post_type'   => 'shop_coupon',
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'meta_query'  => [
            [
                'key'     => 'date_expires',
                'value'   => 0,
                'compare' => '>',
                'type'    => 'NUMERIC',
            ]
        ]
    ];

    $coupons = get_posts($args);

    if (!$coupons) return;

    echo '<div class="custom-coupons-box" style="margin-top:30px; padding:15px; border:2px dashed #aaa; border-radius:10px;">';
    echo '<h3 style="margin-bottom:10px;">🎁 کدهای تخفیف زمان‌دار</h3>';
    echo '<ul style="list-style-type: disc; padding-left: 20px;">';

    foreach ($coupons as $coupon) {
        $code = $coupon->post_title;
        $description = get_the_excerpt($coupon);
        $expiry_timestamp = get_post_meta($coupon->ID, 'date_expires', true);
        $expiry = $expiry_timestamp ? date_i18n('Y/m/d', $expiry_timestamp) : 'نامشخص';

        echo '<li style="margin-bottom:10px;">';
        echo '<span class="coupon-code" style="font-weight:bold;">' . esc_html($code) . '</span> ';
        echo '<button type="button" class="copy-btn" data-code="' . esc_attr($code) . '" style="margin-right:10px; padding:4px 8px; background:#00a0d2; border:1px solid #ccc; cursor:pointer;">کپی</button>';
        echo '<br><small class="expiry">تاریخ انقضا: ' . esc_html($expiry) . '</small>';
        if ($description) {
            echo '<div class="description" style="font-size: 0.9em; color: #555;">' . esc_html($description) . '</div>';
        }
        echo '</li>';
    }

    echo '</ul>';
    echo '</div>';
});

// اسکریپت کپی کردن کد تخفیف بدون تداخل با فرم پرداخت
add_action('wp_footer', function () {
    if (!is_checkout()) return;
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.copy-btn').forEach(function (btn) {
            btn.addEventListener('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                var code = this.getAttribute('data-code');
                navigator.clipboard.writeText(code).then(() => {
                    alert('کد "' + code + '" با موفقیت کپی شد.');
                }).catch(() => {
                    alert('مشکلی در کپی کردن کد به‌وجود آمد.');
                });
            });
        });
    });
    </script>
    <?php
});
