 <?php


if (!defined('ABSPATH')) exit;

// ==================== بخش پیشخوان ====================

add_action('admin_menu', 'weekdays_admin_menu');
function weekdays_admin_menu() {
    add_menu_page(
        'تنظیمات روزهای هفته', 
        'روزهای هفته', 
        'manage_options', 
        'weekdays-settings', 
        'weekdays_settings_page', 
        'dashicons-calendar-alt', 
        80
    );
}

function weekdays_settings_page() {
    $week_days = array('شنبه','یکشنبه','دوشنبه','سه‌شنبه','چهارشنبه','پنج‌شنبه');
    
    if (isset($_POST['submit_weekdays'])) {
        foreach ($week_days as $day) {
            if (isset($_POST[$day])) {
                update_option('week_' . $day, array_filter($_POST[$day]));
            }
        }
        echo '<div class="notice notice-success"><p>تنظیمات ذخیره شد!</p></div>';
    }
    
    echo '<div class="wrap"><h1>تنظیمات روزهای هفته</h1><form method="POST">';
    
    foreach ($week_days as $day) {
        $values = get_option('week_' . $day, array());
        echo '<h2 style="margin-top:20px;">'.$day.'</h2>';
        for ($i=0; $i<5; $i++) {
            $val = isset($values[$i]) ? esc_attr($values[$i]) : '';
            echo '<input type="text" name="'.$day.'[]" value="'.$val.'" style="width:300px;margin-bottom:5px;" placeholder="فیلد '.($i+1).'"><br>';
        }
    }
    
    echo '<input type="submit" name="submit_weekdays" class="button button-primary" value="ذخیره">';
    echo '</form></div>';
}

// ==================== صفحه تسویه حساب + debug ====================

add_action('woocommerce_review_order_before_payment', 'show_custom_date_buttons');
function show_custom_date_buttons() {
    // گرفتن استان کاربر
    $user_state = '';
    if (is_user_logged_in()) {
        $user_id = get_current_user_id();
        $user_state = get_user_meta($user_id, 'billing_state', true);
    } else {
        $user_state = WC()->customer->get_billing_state();
    }

    // ==================== VAR_DUMP برای همه استان‌ها ====================
    $countries = new WC_Countries();
    $iran_states = $countries->get_states('IR');

    echo '<pre style="color:red;">';
    echo 'DEBUG: استان کاربر = '; var_dump($user_state);
    echo "\nتمام استان‌های ایران:\n";
    var_dump($iran_states);
    echo '</pre>';
    // ==================== پایان VAR_DUMP ====================

    // ==================== شرط نمایش جدول فقط تهران ====================
    // برای تست debug موقتاً شرط را کامنت کن
    // if (stripos($user_state, 'تهران') === false && stripos($user_state, 'IR-07') === false) return;

    // ==================== جدول تاریخ ====================
    $week_days = array('یکشنبه','دوشنبه','سه‌شنبه','چهارشنبه','پنج‌شنبه','جمعه','شنبه');
    $months = array(1=>'فروردین','اردیبهشت','خرداد','تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند');

    echo '<style>
    .custom-date-table { width:100%; border-collapse: collapse; margin:20px 0; font-family: IRANSans,sans-serif; }
    .custom-date-table td { padding:15px; vertical-align:top; border:1px solid #ddd; border-radius:8px; }
    .custom-date-btn { width:100%; padding:12px 0; background: linear-gradient(135deg,#0073AA,#00A2FF); color:white; border:none; border-radius:8px; cursor:pointer; font-weight:bold; margin-bottom:10px; transition: all 0.3s ease; }
    .custom-date-btn:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(0,0,0,0.3); }
    .day-items { margin-top:10px; text-align:right; }
    .day-item label { background:#f7f7f7; padding:8px 10px; border-radius:5px; display:block; cursor:pointer; transition:0.2s; margin-bottom:5px; border:1px solid #ddd; }
    .day-item input[type="radio"] { margin-right:8px; }
    .day-item label:hover { background:#e0f0ff; border-color:#0073AA; }
    </style>';

    echo '<table class="custom-date-table"><tr>';

    $count = 0;
    $days_ahead = 2;

    while ($count < 4) {
        $timestamp = strtotime('+' . $days_ahead . ' days');
        $gy = date('Y', $timestamp);
        $gm = date('m', $timestamp);
        $gd = date('d', $timestamp);
        $week_day = date('w', $timestamp);

        $jalali = gregorian_to_jalali($gy, $gm, $gd);

        $jalali_week_day = ($week_day + 2) % 7;
        $week_name = $week_days[$jalali_week_day];

        if ($week_name == 'جمعه') {
            $days_ahead++;
            continue;
        }

        $month_name = $months[$jalali['month']];

        echo '<td>';
        echo '<button class="custom-date-btn" type="button">';
        echo $week_name . ' ' . $jalali['day'] . ' ' . $month_name;
        echo '</button>';

        $day_items = get_option('week_' . $week_name, array());
        if (!empty($day_items)) {
            echo '<div class="day-items">';
            foreach ($day_items as $index => $item) {
                echo '<div class="day-item">';
                echo '<label>';
                echo '<input type="radio" name="selected_item" value="'.esc_attr($week_name.'|'.$item).'"> ';
                echo esc_html($item);
                echo '</label>';
                echo '</div>';
            }
            echo '</div>';
        }

        echo '</td>';

        $count++;
        $days_ahead++;
    }

    echo '</tr></table>';
}

// ==================== ذخیره انتخاب کاربر ====================

add_action('woocommerce_checkout_create_order', 'save_selected_item_order_meta', 20, 2);
function save_selected_item_order_meta($order, $data) {
    if (isset($_POST['selected_item'])) {
        $order->update_meta_data('_selected_item', sanitize_text_field($_POST['selected_item']));
    }
}

// ==================== نمایش انتخاب در پنل مدیریت و صفحه کاربر ====================

add_action('woocommerce_admin_order_data_after_billing_address', 'display_selected_item_in_order_admin', 10, 1);
function display_selected_item_in_order_admin($order){
    $item = $order->get_meta('_selected_item');
    if ($item) {
        echo '<p><strong>آیتم انتخابی:</strong> ' . esc_html($item) . '</p>';
    }
}

add_action('woocommerce_order_details_after_order_table', 'display_selected_item_in_order_customer', 10, 1);
function display_selected_item_in_order_customer($order){
    $item = $order->get_meta('_selected_item');
    if ($item) {
        echo '<p><strong>آیتم انتخابی شما:</strong> ' . esc_html($item) . '</p>';
    }
}

// ==================== تابع تبدیل میلادی به شمسی ====================

function gregorian_to_jalali($gy, $gm, $gd) {
    $g_days_in_month = array(31,28,31,30,31,30,31,31,30,31,30,31);
    $j_days_in_month = array(31,31,31,31,31,31,30,30,30,30,30,29);

    $gy2 = $gy - 1600;
    $gm2 = $gm - 1;
    $gd2 = $gd - 1;

    $g_day_no = 365*$gy2 + floor(($gy2+3)/4) - floor(($gy2+99)/100) + floor(($gy2+399)/400);
    for ($i=0; $i<$gm2; ++$i) $g_day_no += $g_days_in_month[$i];
    if ($gm2>1 && (($gy2%4==0 && $gy2%100!=0) || ($gy2%400==0))) $g_day_no++;
    $g_day_no += $gd2;

    $j_day_no = $g_day_no - 79;

    $j_np = floor($j_day_no / 12053);
    $j_day_no %= 12053;

    $jy = 979 + 33*$j_np + 4*floor($j_day_no/1461);
    $j_day_no %= 1461;

    if ($j_day_no >= 366) {
        $jy += floor(($j_day_no-1)/365);
        $j_day_no = ($j_day_no-1)%365;
    }

    for ($i = 0; $i < 11 && $j_day_no >= $j_days_in_month[$i]; ++$i)
        $j_day_no -= $j_days_in_month[$i];
    $jm = $i + 1;
    $jd = $j_day_no + 1;

    return array('year'=>$jy,'month'=>$jm,'day'=>$jd);
}
