<?php
// ثبت نوع پست سفارشی برای بازه‌های زمانی
function odt_register_custom_post_type() {
    register_post_type('delivery_slot', array(
        'labels' => array(
            'name' => 'بازه‌های زمانی تحویل',
            'singular_name' => 'بازه زمانی',
            'add_new' => 'افزودن بازه',
            'add_new_item' => 'افزودن بازه جدید',
            'edit_item' => 'ویرایش بازه',
            'new_item' => 'بازه جدید',
            'view_item' => 'مشاهده بازه',
            'menu_name' => 'زمان‌بندی تحویل'
        ),
        'public' => false,
        'show_ui' => true,
        'menu_icon' => 'dashicons-clock',
        'supports' => array('title'),
    ));
}
add_action('init', 'odt_register_custom_post_type');

// افزودن متاباکس بازه زمانی
function odt_add_custom_meta_boxes() {
    add_meta_box('delivery_slot_meta', 'جزئیات بازه زمانی', 'odt_render_meta_box', 'delivery_slot', 'normal', 'high');
}
add_action('add_meta_boxes', 'odt_add_custom_meta_boxes');

function odt_render_meta_box($post) {
    $days = array('شنبه','یکشنبه','دوشنبه','سه‌شنبه','چهارشنبه','پنج‌شنبه');
    $selected_day = get_post_meta($post->ID, '_delivery_day', true);
    $start_time = get_post_meta($post->ID, '_delivery_start', true);
    $end_time = get_post_meta($post->ID, '_delivery_end', true);
    $capacity = get_post_meta($post->ID, '_delivery_capacity', true);

    echo '<label for="delivery_day">روز هفته:</label><br>';
    echo '<select name="delivery_day" id="delivery_day">';
    foreach ($days as $day) {
        $sel = ($day == $selected_day) ? 'selected' : '';
        echo "<option value='{$day}' {$sel}>{$day}</option>";
    }
    echo '</select><br><br>';

    echo '<label for="delivery_start">ساعت شروع:</label><br>';
    echo '<input type="time" name="delivery_start" id="delivery_start" value="'.esc_attr($start_time).'" required><br><br>';

    echo '<label for="delivery_end">ساعت پایان:</label><br>';
    echo '<input type="time" name="delivery_end" id="delivery_end" value="'.esc_attr($end_time).'" required><br><br>';

    echo '<label for="delivery_capacity">ظرفیت ارسال (تعداد سفارشات قابل قبول):</label><br>';
    echo '<input type="number" min="1" step="1" name="delivery_capacity" id="delivery_capacity" value="'.esc_attr($capacity ? $capacity : 1).'" required><br><br>';
}

// ذخیره متاهای بازه زمانی
function odt_save_meta_fields($post_id) {
    if (isset($_POST['delivery_day'])) {
        update_post_meta($post_id, '_delivery_day', sanitize_text_field($_POST['delivery_day']));
        update_post_meta($post_id, '_delivery_start', sanitize_text_field($_POST['delivery_start']));
        update_post_meta($post_id, '_delivery_end', sanitize_text_field($_POST['delivery_end']));
        $capacity = intval($_POST['delivery_capacity']);
        if($capacity < 1) $capacity = 1;
        update_post_meta($post_id, '_delivery_capacity', $capacity);
    }
}
add_action('save_post', 'odt_save_meta_fields');

// اضافه کردن متاباکس نمایش بازه زمانی در صفحه محصول ووکامرس
function odt_add_delivery_slot_checkbox_meta_box() {
    add_meta_box(
        'odt_delivery_slot_checkbox',
        'تنظیمات تحویل کالا',
        'odt_render_delivery_slot_checkbox',
        'product',
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'odt_add_delivery_slot_checkbox_meta_box');

function odt_render_delivery_slot_checkbox($post) {
    $value = get_post_meta($post->ID, '_enable_delivery_slot', true);
    wp_nonce_field('odt_delivery_slot_nonce_action', 'odt_delivery_slot_nonce');
    ?>
    <label for="odt_enable_delivery_slot">
        <input type="checkbox" name="odt_enable_delivery_slot" id="odt_enable_delivery_slot" value="yes" <?php checked($value, 'yes'); ?> />
        نمایش بازه زمانی تحویل کالا برای این محصول
    </label>
    <?php
}

// ذخیره مقدار متاباکس در محصول
function odt_save_delivery_slot_checkbox($post_id) {
    if (!isset($_POST['odt_delivery_slot_nonce']) || !wp_verify_nonce($_POST['odt_delivery_slot_nonce'], 'odt_delivery_slot_nonce_action')) {
        return;
    }
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    if (isset($_POST['odt_enable_delivery_slot']) && $_POST['odt_enable_delivery_slot'] === 'yes') {
        update_post_meta($post_id, '_enable_delivery_slot', 'yes');
    } else {
        delete_post_meta($post_id, '_enable_delivery_slot');
    }
}
add_action('save_post', 'odt_save_delivery_slot_checkbox');

// محاسبه ظرفیت باقی‌مانده
function odt_get_remaining_capacity($slot_id) {
    $capacity = intval(get_post_meta($slot_id, '_delivery_capacity', true));
    if ($capacity < 1) $capacity = 1;

    $args = array(
        'post_type' => 'shop_order',
        'post_status' => array('wc-processing', 'wc-on-hold', 'wc-completed'),
        'meta_query' => array(
            array(
                'key' => '_delivery_slot_id',
                'value' => $slot_id,
                'compare' => '='
            ),
        ),
        'fields' => 'ids',
        'posts_per_page' => -1
    );
    $orders = get_posts($args);
    $used = count($orders);

    $remaining = $capacity - $used;
    return ($remaining > 0) ? $remaining : 0;
}

// بررسی وجود محصولی با بازه زمانی فعال در سبد خرید
function odt_cart_has_delivery_slot_enabled_product() {
    if ( ! WC()->cart ) return false;

    foreach ( WC()->cart->get_cart() as $cart_item ) {
        $product_id = $cart_item['product_id'];
        $enable_slot = get_post_meta($product_id, '_enable_delivery_slot', true);
        if ($enable_slot === 'yes') {
            return true;
        }
    }
    return false;
}

// نمایش تب‌باکس‌ها در تسویه حساب فقط اگر محصولی این ویژگی را داشته باشد
add_action('woocommerce_review_order_before_payment', 'odt_display_delivery_slots');
function odt_display_delivery_slots() {
    if ( ! odt_cart_has_delivery_slot_enabled_product() ) {
        return;
    }

    $days = array('شنبه','یکشنبه','دوشنبه','سه‌شنبه','چهارشنبه','پنج‌شنبه');
    $slots = get_posts(array(
        'post_type' => 'delivery_slot',
        'posts_per_page' => -1,
    ));
    $slots_by_day = array();
    foreach ($days as $day) {
        $slots_by_day[$day] = array();
    }
    foreach ($slots as $slot) {
        $day = get_post_meta($slot->ID, '_delivery_day', true);
        if (isset($slots_by_day[$day])) {
            $slots_by_day[$day][] = $slot;
        }
    }
    ?>
    <style>
        .odt-tabs { display: flex; border-bottom: 2px solid #2196F3; margin-bottom: 15px; cursor: pointer; }
        .odt-tab { padding: 10px 20px; background: #e3f2fd; border: 1px solid #90caf9; border-bottom: none; margin-right: 5px; border-radius: 5px 5px 0 0; color: #0d47a1; font-weight: bold; }
        .odt-tab.active { background: #2196F3; color: #fff; }
        .odt-tab-content { display: none; border: 1px solid #90caf9; padding: 15px; border-radius: 0 5px 5px 5px; background: #f5faff; }
        .odt-tab-content.active { display: block; }
        table.odt-table { width: 100%; border-collapse: collapse; }
        table.odt-table th, table.odt-table td { border: 1px solid #90caf9; padding: 10px; text-align: center; font-size: 14px; }
        table.odt-table th { background-color: #2196F3; color: white; }
        input[type=radio][disabled] + label { color: #999; cursor: not-allowed; }
        .capacity-badge { background-color: #ff7043; color: white; font-weight: bold; padding: 3px 8px; border-radius: 12px; font-size: 12px; }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const tabs = document.querySelectorAll('.odt-tab');
            tabs.forEach(tab => {
                tab.addEventListener('click', function () {
                    tabs.forEach(t => t.classList.remove('active'));
                    this.classList.add('active');

                    const contents = document.querySelectorAll('.odt-tab-content');
                    contents.forEach(c => c.classList.remove('active'));
                    const activeContent = document.getElementById(this.dataset.target);
                    if (activeContent) activeContent.classList.add('active');
                });
            });
            // فعال کردن تب اول
            if(tabs.length > 0) tabs[0].click();
        });
    </script>

    <div id="odt-delivery-slot-tabs">
        <div class="odt-tabs" role="tablist" aria-label="انتخاب روز تحویل">
            <?php foreach ($days as $index => $day): ?>
                <div class="odt-tab" role="tab" tabindex="0" data-target="odt-tab-<?php echo esc_attr($index); ?>">
                    <?php echo esc_html($day); ?>
                </div>
            <?php endforeach; ?>
        </div>

        <?php foreach ($days as $index => $day): ?>
            <div id="odt-tab-<?php echo esc_attr($index); ?>" class="odt-tab-content" role="tabpanel" aria-labelledby="tab-<?php echo esc_attr($index); ?>">
                <?php if (empty($slots_by_day[$day])): ?>
                    <p>برای روز <?php echo esc_html($day); ?> بازه زمانی ثبت نشده است.</p>
                <?php else: ?>
                    <table class="odt-table" aria-describedby="odt-delivery-slot-table-desc-<?php echo esc_attr($index); ?>">
                        <caption id="odt-delivery-slot-table-desc-<?php echo esc_attr($index); ?>">بازه‌های زمانی روز <?php echo esc_html($day); ?></caption>
                        <thead>
                            <tr>
                                <th>انتخاب</th>
                                <th>بازه زمانی</th>
                                <th>ظرفیت باقی‌مانده</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($slots_by_day[$day] as $slot): 
                            $start = get_post_meta($slot->ID, '_delivery_start', true);
                            $end = get_post_meta($slot->ID, '_delivery_end', true);
                            $remaining = odt_get_remaining_capacity($slot->ID);
                            $disabled = ($remaining <= 0) ? 'disabled' : '';
                            $slot_id = $slot->ID;
                            ?>
                            <tr>
                                <td>
                                    <input 
                                        type="radio" 
                                        id="delivery_slot_<?php echo esc_attr($slot_id); ?>" 
                                        name="delivery_slot_id" 
                                        value="<?php echo esc_attr($slot_id); ?>" 
                                        <?php echo $disabled; ?>
                                        aria-disabled="<?php echo ($disabled) ? 'true' : 'false'; ?>"
                                        >
                                </td>
                                <td>
                                    <label for="delivery_slot_<?php echo esc_attr($slot_id); ?>">
                                        <?php echo esc_html($start . ' تا ' . $end); ?>
                                    </label>
                                </td>
                                <td>
                                    <?php if ($remaining > 0): ?>
                                        <span class="capacity-badge" aria-label="ظرفیت باقی‌مانده"><?php echo esc_html($remaining); ?></span>
                                    <?php else: ?>
                                        <span aria-label="ظرفیت تکمیل شده">پر شده</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
    <?php
}

// اعتبارسنجی و ذخیره بازه زمانی انتخاب شده هنگام ثبت سفارش
add_action('woocommerce_checkout_update_order_meta', 'odt_save_delivery_slot_order_meta');
function odt_save_delivery_slot_order_meta($order_id) {
    if (isset($_POST['delivery_slot_id'])) {
        $slot_id = intval($_POST['delivery_slot_id']);
        if ($slot_id > 0 && get_post_type($slot_id) === 'delivery_slot') {
            update_post_meta($order_id, '_delivery_slot_id', $slot_id);
        }
    }
}

// نمایش بازه زمانی در صفحه سفارش (اداری و کاربری)
add_action('woocommerce_admin_order_data_after_billing_address', 'odt_display_order_delivery_slot_admin', 10, 1);
add_action('woocommerce_order_details_after_customer_details', 'odt_display_order_delivery_slot_admin', 10, 1);
function odt_display_order_delivery_slot_admin($order) {
    $slot_id = get_post_meta($order->get_id(), '_delivery_slot_id', true);
    if ($slot_id) {
        $day = get_post_meta($slot_id, '_delivery_day', true);
        $start = get_post_meta($slot_id, '_delivery_start', true);
        $end = get_post_meta($slot_id, '_delivery_end', true);
        echo '<p><strong>بازه زمانی تحویل سفارش:</strong><br>';
        echo esc_html($day . ' - ' . $start . ' تا ' . $end);
        echo '</p>';
    }
}

// افزودن اسکریپت و استایل در صفحه تسویه حساب
add_action('wp_enqueue_scripts', 'odt_enqueue_scripts');
function odt_enqueue_scripts() {
    if (is_checkout()) {
        wp_enqueue_script('jquery');
    }
}
