<?php
if ( ! defined( 'ABSPATH' ) ) exit;


add_action( 'add_meta_boxes', 'jb_add_invoice_meta_box' );
function jb_add_invoice_meta_box() {
    add_meta_box(
        'jb_invoice_meta_box',
        'فاکتور سفارش',
        'jb_invoice_meta_box_callback',
        'shop_order',
        'side',
        'default'
    );
}

function jb_invoice_meta_box_callback( $post ) {
    $order_id = $post->ID;
    $url = jb_get_invoice_url( $order_id );
    echo '<p><a class="button button-primary" href="'. esc_url($url) .'" target="_blank">مشاهده فاکتور</a></p>';
}


add_filter( 'woocommerce_my_account_my_orders_actions', 'jb_add_invoice_button_my_account', 10, 2 );
function jb_add_invoice_button_my_account( $actions, $order ) {
    $url = jb_get_invoice_url( $order->get_id() );
    $actions['invoice'] = array(
        'url'  => $url,
        'name' => 'دانلود فاکتور',
    );
    return $actions;
}


function jb_get_invoice_url( $order_id ) {
    return wp_nonce_url( add_query_arg( array(
        'jb_invoice' => $order_id,
    ), home_url() ), 'jb_invoice_nonce', '_wpnonce' );
}


add_action( 'template_redirect', 'jb_generate_invoice' );
function jb_generate_invoice() {
    if ( empty($_GET['jb_invoice']) ) return;

    if ( ! is_numeric($_GET['jb_invoice']) 
        || empty($_GET['_wpnonce']) 
        || ! wp_verify_nonce($_GET['_wpnonce'], 'jb_invoice_nonce') ) {
        return;
    }

    $order_id = intval($_GET['jb_invoice']);
    $order = wc_get_order($order_id);
    if ( ! $order ) return;

    // دسترسی فقط مدیر یا مشتری صاحب سفارش
    if ( ! current_user_can('manage_woocommerce') && get_current_user_id() !== $order->get_user_id() ) {
        wp_die('شما اجازه دسترسی به این فاکتور را ندارید.');
    }

    // اطلاعات مشتری
    $customer_name     = $order->get_formatted_billing_full_name();
    $customer_address  = $order->get_billing_state() . '، ' . $order->get_billing_city() . '، ' . $order->get_billing_address_1();
    $customer_postcode = $order->get_billing_postcode(); 
    $customer_phone    = $order->get_billing_phone();

    // اطلاعات سفارش
    $invoice_no    = $order->get_id();
    $total_amount  = wc_price($order->get_total(), array('currency' => 'IRT')); 

    // HTML فاکتور (گیرنده راست، فرستنده چپ)
    $html = '
        <div style="direction: rtl; text-align: right; font-family: Dana, Tahoma;">
            <table border="1" cellpadding="6" cellspacing="0" style="width:100%; font-size:12px; border-collapse:collapse;">
                <tr>
                <td style="width:50%; vertical-align:top;"></td>
                   <td style="width:50%; vertical-align:top;">
                        <b>فرستنده :</b><br>
                        تهران، میدان ولیعصر ، خ گیلان پلاک 5 واحد 2 جهان بازار<br>
                        تلفن: 09928276785
                    </td>
                </tr>
                <tr>
                     <td style="width:50%; vertical-align:top;">
                        <b>گیرنده:</b> <br> '.$customer_name.'<br>
                        <b>آدرس:</b> <br> '.$customer_address.'<br>
                        <b>کدپستی:</b><br> '.$customer_postcode.'<br>
                        <b>تلفن:</b> <br> '.$customer_phone.'
                    </td>
                     
                </tr>
                <tr>
                    <td style="width:50%;">
                        <b>شماره فاکتور:</b> <br> '.$invoice_no.'
                    </td>
                    <td style="width:50%;">
                        <b>مبلغ کل:</b><br> '.$total_amount.'
                    </td>
                </tr>
            </table>
            <br><br>
            <p style="text-align:right;">امضاء فروشنده: ....................................</p>
        </div>';


    // نمایش صفحه فاکتور + دکمه چاپ (سبک و امن)
    echo '<!DOCTYPE html>
    <html lang="fa">
    <head>
        <meta charset="UTF-8">
        <title>فاکتور سفارش #'.$invoice_no.'</title>
        <style>
            @media print { .print-btn { display:none; } }
            body { direction: rtl; text-align: right; margin:20px; }
        </style>
    </head>
    <body>
        '.$html.'
        <div class="print-btn" style="margin-top:20px; text-align:center;">
            <button onclick="window.print()" style="padding:10px 20px; font-size:14px; cursor:pointer;"> چاپ فاکتور</button>
        </div>
    </body>
    </html>';
    exit;
}
