<?php


add_action('woocommerce_cart_calculate_fees', 'jahan_bazar_custom_packaging_fee_total_by_category_in_check');

function jahan_bazar_custom_packaging_fee_total_by_category_in_check() {
    if (is_admin() && !defined('DOING_AJAX')) return;

    // دسته‌هایی که 100 هزار تومن هزینه دارند
    $high_fee_categories = array(92, 58);

    // دسته‌هایی که 50 هزار تومن هزینه دارند
    $low_fee_categories = array(57, 53, 43 , 1171);

    $total_packaging_fee = 0;

    foreach (WC()->cart->get_cart() as $cart_item) {
        $product_id = $cart_item['product_id'];
        $quantity = $cart_item['quantity'];
        $product_cat_ids = wc_get_product_term_ids($product_id, 'product_cat');

        // اگر در دسته‌های 100 تومنی باشه
        if (array_intersect($product_cat_ids, $high_fee_categories)) {
            $total_packaging_fee += 100000 * $quantity;
            continue;
        }

        // اگر در دسته‌های 50 تومنی باشه
        if (array_intersect($product_cat_ids, $low_fee_categories)) {
            $total_packaging_fee += 50000 * $quantity;
        }
    }

    // اعمال هزینه نهایی با یک عنوان واحد
    if ($total_packaging_fee > 0) {
        WC()->cart->add_fee('هزینه بسته‌بندی', $total_packaging_fee);
    }
}