<?php



// وقتی وضعیت سفارش تغییر کرد به 9-، یک کرون تایمر برای 3 روز بعد تنظیم می‌کنیم
add_action( 'woocommerce_order_status_changed', 'reza_schedule_auto_complete', 10, 3 );
function reza_schedule_auto_complete( $order_id, $old_status, $new_status ) {
    if ( $new_status === '9-' ) {
        // اگر کرون قبلاً تنظیم شده بود، حذفش کن (برای اطمینان)
        wp_clear_scheduled_hook( 'reza_auto_complete_order_event', array( $order_id ) );

        // زمان‌بندی اجرای تابع بعد از ۳ روز
        wp_schedule_single_event( time() + 3 * DAY_IN_SECONDS, 'reza_auto_complete_order_event', array( $order_id ) );

        error_log("✅ کرون برای سفارش {$order_id} تنظیم شد (wc-9-) - در ۳ روز آینده بررسی میشه.");
    }
}

// این تابع بعد از ۳ روز اجرا میشه
add_action( 'reza_auto_complete_order_event', 'reza_run_auto_complete' );
function reza_run_auto_complete( $order_id ) {
    $order = wc_get_order( $order_id );

    if ( $order && $order->get_status() === '9-' ) {
        $order->update_status( 'completed', 'وضعیت سفارش پس از ۳ روز به صورت خودکار تکمیل شد.' );
        error_log("✅ سفارش {$order_id} با موفقیت به completed تغییر یافت.");
    } else {
        error_log("❌ سفارش {$order_id} دیگر در وضعیت 9- نیست. وضعیت فعلی: " . ($order ? $order->get_status() : 'نامشخص'));
    }
}
