<?php


if ( ! defined( 'ABSPATH' ) ) exit;


add_action('admin_menu', function() {
    add_submenu_page(
        'edit.php?post_type=product',
        'مخفی‌سازی محصولات ناموجود',
        'مخفی‌سازی ناموجودها',
        'manage_woocommerce',
        'jb-wc-hide-outofstock-category',
        'jb_wc_hide_outofstock_category_page'
    );
});


add_action('admin_enqueue_scripts', function($hook) {
    if ($hook !== 'product_page_jb-wc-hide-outofstock-category') return;

    wp_enqueue_style('select2-css', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');
    wp_enqueue_script('select2-js', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', ['jquery'], null, true);

    wp_add_inline_script('select2-js', "
        jQuery(document).ready(function($) {
            $('#jb_wc_hidden_cats').select2({
                placeholder: 'انتخاب دسته‌ها...',
                allowClear: true,
                width: '100%'
            });
        });
    ");
});


if ( ! function_exists( 'jb_wc_hide_outofstock_category_page' ) ) {
    function jb_wc_hide_outofstock_category_page() {
        if ( isset($_POST['jb_wc_hidden_cats_nonce']) && wp_verify_nonce($_POST['jb_wc_hidden_cats_nonce'], 'jb_wc_save_hidden_cats') ) {
            $selected_cats = isset($_POST['jb_wc_hidden_cats']) ? array_map('intval', $_POST['jb_wc_hidden_cats']) : [];
            update_option('jb_wc_hidden_outofstock_cats', $selected_cats);
            echo '<div class="updated"><p>تنظیمات ذخیره شد.</p></div>';
        }

        $saved_cats = get_option('jb_wc_hidden_outofstock_cats', []);

        echo '<div class="wrap"><h1>مخفی‌سازی محصولات ناموجود بر اساس دسته</h1>';
        echo '<form method="post">';
        wp_nonce_field('jb_wc_save_hidden_cats', 'jb_wc_hidden_cats_nonce');

        $cats = get_terms([
            'taxonomy'   => 'product_cat',
            'hide_empty' => false,
            'parent'     => 0
        ]);

        echo '<p>دسته‌ها و زیردسته‌هایی که می‌خواید <b>فقط محصولات ناموجود</b> اون‌ها مخفی بشه انتخاب کنید:</p>';
        echo '<select id="jb_wc_hidden_cats" name="jb_wc_hidden_cats[]" multiple="multiple" style="width:400px;">';
        jb_wc_render_select_options($cats, $saved_cats);
        echo '</select>';

        if ( !empty($saved_cats) ) {
            echo '<h3>✅ دسته‌های انتخاب‌شده:</h3><div style="margin:10px 0; padding:10px; background:#fff; border:1px solid #ddd; border-radius:6px;">';
            foreach ($saved_cats as $cat_id) {
                $term = get_term($cat_id, 'product_cat');
                if ($term && !is_wp_error($term)) {
                    echo '<span style="display:inline-block; background:#f1f1f1; padding:5px 10px; margin:3px; border-radius:4px;">'.$term->name.'</span>';
                }
            }
            echo '</div>';
        }

        submit_button();
        echo '</form></div>';
    }
}


if ( ! function_exists( 'jb_wc_render_select_options' ) ) {
    function jb_wc_render_select_options($terms, $saved_cats, $level = 0) {
        foreach ( $terms as $term ) {
            $selected = in_array($term->term_id, $saved_cats) ? 'selected' : '';
            $indent   = str_repeat('— ', $level);
            echo '<option value="'.esc_attr($term->term_id).'" '.$selected.'>'.$indent.$term->name.'</option>';

            $child_terms = get_terms([
                'taxonomy'   => 'product_cat',
                'hide_empty' => false,
                'parent'     => $term->term_id
            ]);
            if ( $child_terms ) {
                jb_wc_render_select_options($child_terms, $saved_cats, $level+1);
            }
        }
    }
}


add_action('pre_get_posts', function($q) {
    if ( is_admin() || ! $q->is_main_query() ) return;

    $hidden_cats = get_option('jb_wc_hidden_outofstock_cats', []);
    if ( empty($hidden_cats) ) return;

    if ( $q->is_post_type_archive('product') || $q->is_tax('product_cat') || $q->is_search() ) {

        $meta_query = (array) $q->get('meta_query');

        $meta_query[] = [
            'relation' => 'OR',
            [
                'key'     => '_stock_status',
                'value'   => 'instock',
                'compare' => '='
            ],
            [
                'key'     => '_stock_status',
                'value'   => 'outofstock',
                'compare' => '=',
            ]
        ];

        $q->set('meta_query', $meta_query);

        $tax_query = (array) $q->get('tax_query');
        $tax_query[] = [
            'taxonomy'         => 'product_cat',
            'field'            => 'term_id',
            'terms'            => $hidden_cats,
            'operator'         => 'NOT IN',
            'include_children' => true,
        ];

        $q->set('tax_query', $tax_query);
    }
});
