<?php

// نقش کاربری همکار
register_activation_hook(__FILE__, function() {
    add_role('vendor_partner', 'همکار', [
        'read' => true,
        'level_0' => true,
    ]);
});
register_deactivation_hook(__FILE__, function() {
    remove_role('vendor_partner');
});

// افزودن منو به حساب کاربری ووکامرس
add_filter('woocommerce_account_menu_items', function($items) {
    $items['vendor-panel'] = 'فروش همکار';
    return $items;
});
add_action('init', function() {
    add_rewrite_endpoint('vendor-panel', EP_ROOT | EP_PAGES);
});
add_action('woocommerce_account_vendor-panel_endpoint', function() {
    echo do_shortcode('[vp_vendor_form]');
});

// فرم ثبت اطلاعات همکار
add_shortcode('vp_vendor_form', function() {
    if (isset($_POST['vp_submit_form']) && is_user_logged_in()) {
        $user_id = get_current_user_id();

        update_user_meta($user_id, 'vp_full_name', sanitize_text_field($_POST['vp_full_name']));
        update_user_meta($user_id, 'vp_national_id', sanitize_text_field($_POST['vp_national_id']));
        update_user_meta($user_id, 'vp_address', sanitize_textarea_field($_POST['vp_address']));

        $upload_dir = wp_upload_dir();
        $basedir = $upload_dir['basedir'] . '/vendor_partners/';
        $baseurl = $upload_dir['baseurl'] . '/vendor_partners/';

        if (!file_exists($basedir)) {
            wp_mkdir_p($basedir);
        }

        foreach (['vp_card_file', 'vp_license_file'] as $field) {
            if (!empty($_FILES[$field]['name'])) {
                $filename = $user_id . '_' . $field . '_' . time() . '_' . basename($_FILES[$field]['name']);
                $filepath = $basedir . $filename;

                if (move_uploaded_file($_FILES[$field]['tmp_name'], $filepath)) {
                    update_user_meta($user_id, $field, $baseurl . $filename);
                }
            }
        }

        echo '<div class="vp-success-message">✅ درخواست شما با موفقیت ثبت شد و در انتظار بررسی است.</div>';
    }

    ob_start();
    ?>

    <style>
        .vp-form-container {
            max-width: 600px;
            margin: 30px auto;
            background: #fff;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.1);
            font-family: 'IRANSans', sans-serif;
        }

        .vp-form-container h2 {
            text-align: center;
            margin-bottom: 25px;
            color: #222;
        }

        .vp-form-container label {
            font-weight: bold;
            display: block;
            margin-bottom: 6px;
            margin-top: 20px;
            color: #333;
        }

        .vp-form-container input[type="text"],
        .vp-form-container textarea,
        .vp-form-container input[type="file"] {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-sizing: border-box;
            font-size: 15px;
        }

        .vp-form-container textarea {
            resize: vertical;
            min-height: 100px;
        }

        .vp-form-container button {
            margin-top: 25px;
            background-color: #1e87f0;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
            transition: 0.3s;
        }

        .vp-form-container button:hover {
            background-color: #0f7ae5;
        }

        .vp-success-message {
            background-color: #dff0d8;
            color: #3c763d;
            border: 1px solid #d6e9c6;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            font-weight: bold;
        }
    </style>

    <div class="vp-form-container">
        <h2>درخواست همکاری</h2>
        <form method="post" enctype="multipart/form-data">
            <label>نام و نام خانوادگی</label>
            <input type="text" name="vp_full_name" required>

            <label>کد ملی</label>
            <input type="text" name="vp_national_id" required>

            <label>آدرس</label>
            <textarea name="vp_address" required></textarea>

            <label>کارت ویزیت</label>
            <input type="file" name="vp_card_file" accept="image/*,.pdf" required>

            <label>جواز کسب</label>
            <input type="file" name="vp_license_file" accept="image/*,.pdf" required>

            <button type="submit" name="vp_submit_form">ارسال درخواست</button>
        </form>
    </div>

    <?php
    return ob_get_clean();
});


// منوی مدیریت همکاران در پنل ادمین
add_action('admin_menu', function() {
    add_menu_page('همکار فروش', 'همکار فروش', 'manage_options', 'vp_vendor_requests', 'vp_render_admin_page', 'dashicons-businessman');
});

// محتوای صفحه مدیریت درخواست‌ها
function vp_render_admin_page() {
    $users = get_users([
        'meta_key' => 'vp_full_name',
        'meta_compare' => 'EXISTS'
    ]);

    echo '<div class="wrap"><h1>درخواست‌های همکاری</h1><table class="widefat"><thead><tr>
        <th>کاربر</th><th>نام کامل</th><th>کد ملی</th><th>آدرس</th><th>کارت ویزیت</th><th>جواز کسب</th><th>وضعیت</th></tr></thead><tbody>';

    foreach ($users as $user) {
        $uid = $user->ID;
        $full_name = get_user_meta($uid, 'vp_full_name', true);
        $national_id = get_user_meta($uid, 'vp_national_id', true);
        $address = get_user_meta($uid, 'vp_address', true);
        $card = get_user_meta($uid, 'vp_card_file', true);
        $license = get_user_meta($uid, 'vp_license_file', true);

        echo "<tr>
            <td>{$user->user_login}</td>
            <td>{$full_name}</td>
            <td>{$national_id}</td>
            <td>{$address}</td>
            <td><a href='{$card}' target='_blank'>نمایش</a></td>
            <td><a href='{$license}' target='_blank'>نمایش</a></td>
            <td>";

        // اگر قبلاً تأیید نشده
        if (!user_can($user, 'vendor_partner')) {
            echo "<form method='post' style='display:inline-block;'>
                    <input type='hidden' name='vp_user_id' value='{$uid}'>
                    <button name='vp_approve_user' class='button-primary'>تأیید</button>
                </form>
                <form method='post' style='display:inline-block; margin-right: 10px;'>
                    <input type='hidden' name='vp_user_id' value='{$uid}'>
                    <button name='vp_reject_user' class='button'>رد</button>
                </form>";
        } else {
            echo '<strong style="color:green;">تأیید شده</strong>';
        }

        echo "</td></tr>";
    }

    echo '</tbody></table></div>';
}

// تایید یا رد توسط ادمین
add_action('admin_init', function() {
    if (isset($_POST['vp_user_id']) && current_user_can('manage_options')) {
        $uid = intval($_POST['vp_user_id']);

        if (isset($_POST['vp_approve_user'])) {
            $user = new WP_User($uid);
            $user->set_role('vendor_partner');
        }

        if (isset($_POST['vp_reject_user'])) {
            delete_user_meta($uid, 'vp_full_name');
            delete_user_meta($uid, 'vp_national_id');
            delete_user_meta($uid, 'vp_address');
            delete_user_meta($uid, 'vp_card_file');
            delete_user_meta($uid, 'vp_license_file');
        }

        wp_redirect(admin_url('admin.php?page=vp_vendor_requests'));
        exit;
    }
});
