<?php

if (!defined('ABSPATH')) exit;

add_filter('woocommerce_checkout_fields', 'jb_add_shaba_checkout_field');
function jb_add_shaba_checkout_field($fields) {
    $fields['billing']['billing_shaba'] = array(
        'type'        => 'number',
        'label'       => __('شماره شبا (اختیاری)', 'woocommerce'),
        'placeholder' => __('IR123456789123456789', 'woocommerce'),
        'required'    => false,
        'clear'       => true,
        'priority'    => 120,
    );
    return $fields;
}

add_action('woocommerce_checkout_create_order', 'jb_save_shaba_checkout_field', 10, 2);
function jb_save_shaba_checkout_field($order, $data) {
    if (!empty($_POST['billing_shaba'])) {
        $order->update_meta_data('_billing_shaba', sanitize_text_field($_POST['billing_shaba']));
    }
}

add_action('woocommerce_order_details_after_customer_details', 'jb_display_shaba_in_order_details');
function jb_display_shaba_in_order_details($order) {
    $shaba = $order->get_meta('_billing_shaba');
    if ($shaba) {
        echo '<p><strong>شماره شبا:</strong> ' . esc_html($shaba) . '</p>';
    }
}

add_action('woocommerce_admin_order_data_after_billing_address', 'jb_display_shaba_in_admin_order', 10, 1);
function jb_display_shaba_in_admin_order($order){
    $shaba = $order->get_meta('_billing_shaba');
    if ($shaba) {
        echo '<p><strong>شماره شبا:</strong> ' . esc_html($shaba) . '</p>';
    }
}
