<?php

// افزودن فیلد نوع کاربری (رادیویی) به بالای فرم تسویه‌حساب
add_filter('woocommerce_checkout_fields', 'add_user_type_and_company_fields');

function add_user_type_and_company_fields($fields) {
    // نوع کاربری
    $fields['billing']['billing_user_type'] = array(
        'type'     => 'radio',
        'label'    => 'نوع کاربری',
        'required' => true,
        'options'  => array(
            'haghighi'  => 'حقیقی',
            'hoghoughi' => 'حقوقی'
        ),
        'default'  => 'haghighi',
        'priority' => 1,
        'class'    => array('form-row-wide', 'user-type-radio-wrap'),
    );

    // نام شرکت
    $fields['billing']['billing_company_name'] = array(
        'label'     => 'نام شرکت',
        'required'  => true,
        'class'     => array('form-row-wide', 'company-field'),
    );

    // کد اقتصادی
    $fields['billing']['billing_economic_code'] = array(
        'label'     => 'کد اقتصادی',
        'required'  => true,
        'class'     => array('form-row-wide', 'company-field'),
    );

    // شناسه ملی
    $fields['billing']['billing_national_id'] = array(
        'label'     => 'شناسه ملی / کد ثبت',
        'required'  => true,
        'class'     => array('form-row-wide', 'company-field'),
    );

    return $fields;
}
// بررسی اجباری بودن فیلدها فقط در حالت حقوقی
add_action('woocommerce_checkout_process', 'validate_company_fields_for_hoghoughi');
function validate_company_fields_for_hoghoughi() {
    if (isset($_POST['billing_user_type']) && $_POST['billing_user_type'] === 'hoghoughi') {
        if (empty($_POST['billing_company_name'])) {
            wc_add_notice('لطفاً نام شرکت را وارد کنید.', 'error');
        }
        if (empty($_POST['billing_economic_code'])) {
            wc_add_notice('لطفاً کد اقتصادی را وارد کنید.', 'error');
        }
        if (empty($_POST['billing_national_id'])) {
            wc_add_notice('لطفاً شناسه ملی / کد ثبت را وارد کنید.', 'error');
        }
    }
}

// ذخیره اطلاعات در سفارش
add_action('woocommerce_checkout_update_order_meta', 'save_user_type_and_company_fields');
function save_user_type_and_company_fields($order_id) {
    if (!empty($_POST['billing_user_type'])) {
        update_post_meta($order_id, '_billing_user_type', sanitize_text_field($_POST['billing_user_type']));
    }
    if (!empty($_POST['billing_company_name'])) {
        update_post_meta($order_id, '_billing_company_name', sanitize_text_field($_POST['billing_company_name']));
    }
    if (!empty($_POST['billing_economic_code'])) {
        update_post_meta($order_id, '_billing_economic_code', sanitize_text_field($_POST['billing_economic_code']));
    }
    if (!empty($_POST['billing_national_id'])) {
        update_post_meta($order_id, '_billing_national_id', sanitize_text_field($_POST['billing_national_id']));
    }
}

// نمایش اطلاعات در پنل مدیریت سفارش
add_action('woocommerce_admin_order_data_after_billing_address', 'show_user_type_and_company_fields_admin', 20, 1);
function show_user_type_and_company_fields_admin($order) {
    $user_type     = get_post_meta($order->get_id(), '_billing_user_type', true);
    $company_name  = get_post_meta($order->get_id(), '_billing_company_name', true);
    $economic_code = get_post_meta($order->get_id(), '_billing_economic_code', true);
    $national_id   = get_post_meta($order->get_id(), '_billing_national_id', true);

    if ($user_type) {
        echo '<p><strong>نوع کاربری:</strong> ' . esc_html($user_type === 'hoghoughi' ? 'حقوقی' : 'حقیقی') . '</p>';
    }

    if ($user_type === 'hoghoughi') {
        echo '<p><strong>نام شرکت:</strong> ' . esc_html($company_name) . '<br>';
        echo '<strong>کد اقتصادی:</strong> ' . esc_html($economic_code) . '<br>';
        echo '<strong>شناسه ملی / کد ثبت:</strong> ' . esc_html($national_id) . '</p>';
    }
}

// جاوااسکریپت برای نمایش/مخفی‌کردن فیلدهای حقوقی
add_action('wp_footer', 'toggle_company_fields_script');
function toggle_company_fields_script() {
    if (!is_checkout()) return;
    ?>
    <script>
        jQuery(function($) {
            function toggleCompanyFields() {
                var selected = $('input[name="billing_user_type"]:checked').val();
                if (selected === 'hoghoughi') {
                    $('.company-field').closest('.form-row').show();
                } else {
                    $('.company-field').closest('.form-row').hide();
                }
            }

            toggleCompanyFields();

            $('input[name="billing_user_type"]').change(function() {
                toggleCompanyFields();
            });
        });
    </script>
    <style>
        .company-field {
            display: none;
        }

        .user-type-radio-wrap .woocommerce-input-wrapper label {
            display: inline-flex;
            align-items: center;
            margin-right: 15px;
            gap: 3px;
            font-weight: normal;
            font-size: 14px;
        }

        input[type="radio"] {
            transform: scale(0.9);
            margin: 0;
        }
    </style>
    <?php
}
