<?php
add_filter('woocommerce_order_number', function($order_number, $order) {
    global $wpdb;

    $first_desired = 36053; 
    $last_desired  = 41120; 

    $total_orders = (int) $wpdb->get_var("
        SELECT COUNT(ID)
        FROM {$wpdb->posts}
        WHERE post_type = 'shop_order'
        AND post_status NOT IN ('auto-draft')
    ");

    $order_date_obj = $order->get_date_created();
    if ($order_date_obj) {
        $order_date = $order_date_obj->date('Y-m-d H:i:s');
    } else {
        $order_date = current_time('mysql');
    }

    $order_id = (int) $order->get_id();

    $rank = (int) $wpdb->get_var($wpdb->prepare("
        SELECT COUNT(ID)
        FROM {$wpdb->posts}
        WHERE post_type = 'shop_order'
        AND post_status NOT IN ('auto-draft')
        AND (post_date < %s OR (post_date = %s AND ID <= %d))
    ", $order_date, $order_date, $order_id));

    if ($rank == 1) {
        $custom_number = $first_desired;
    } else {
        $old_count = $total_orders;
        $custom_number = $first_desired + ($rank - 1) * ($last_desired - $first_desired) / max(1, $old_count - 1);
    }

    return str_pad(round($custom_number), 6, '0', STR_PAD_LEFT);
}, 10, 2);
