document.addEventListener('DOMContentLoaded', function () {
    const saveBtn = document.getElementById('save_admin_edit');
    if (!saveBtn) return;

    saveBtn.addEventListener('click', function () {
        const productId = this.dataset.product;
        const resultBox = document.getElementById('admin_update_result');

        const data = new URLSearchParams({
            action: 'admin_update_product_fields',
            product_id: productId,
            product_title: document.getElementById('admin_product_title').value,
            price: document.getElementById('admin_price').value,
            sale_price: document.getElementById('admin_sale_price').value,
            sale_start: document.getElementById('admin_sale_start').value,
            sale_end: document.getElementById('admin_sale_end').value,
            stock: document.getElementById('admin_stock').value,
            dina_meta: document.getElementById('admin_dina_meta').value,
            snappbox_allowed: document.getElementById('admin_snappbox_allowed').checked ? 'yes' : 'no',
            has_supplier: document.getElementById('admin_has_supplier').checked ? 'yes' : 'no',
            _wpnonce: adminQuickEditConfig.nonce
        });

        fetch(adminQuickEditConfig.ajaxUrl, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: data
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                resultBox.style.color = 'green';
                resultBox.textContent = '✅ تغییرات ذخیره شد';
            } else {
                resultBox.style.color = 'red';
                resultBox.textContent = '❌ خطا در ذخیره‌سازی';
            }
        });
    });
});
