jQuery(document).ready(function($){

    // فرمت کردن عدد با کاما
    $('#bpu_amount').on('input', function() {
        let val = $(this).val().replace(/,/g, '');
        if (!isNaN(val) && val !== '') {
            $(this).val(Number(val).toLocaleString('en-US'));
        }
    });

    // کلیک بروزرسانی قیمت و ناموجود کردن
    $('#bpu_submit').on('click', function(){
        $('#bpu_result').html('در حال انجام عملیات...');

        let categories = $('#bpu_category').val();
        let type = $('#bpu_type').val();
        let percent = $('#bpu_percent').val();
        let amount = $('#bpu_amount').val().replace(/,/g, '');
        let only_instock = $('#bpu_only_instock').is(':checked') ? 1 : 0;
        let set_out_of_stock = $('#bpu_set_out_of_stock').is(':checked') ? 1 : 0;

        if (!categories || categories.length === 0) {
            $('#bpu_result').html('لطفاً حداقل یک دسته‌بندی انتخاب کنید.');
            return;
        }

        $.post(ajaxurl, {
            action: 'bpu_update_prices',
            category: categories,
            type: type,
            percent: percent,
            amount: amount,
            only_instock: only_instock,
            set_out_of_stock: set_out_of_stock
        }, function(response){
            $('#bpu_result').html(response);
        });
    });

    // بارگذاری محصولات برای ویرایش گروهی
    function loadPage(cat_id, page, keyword = '') {
        if (!cat_id) {
            $('#bpu_product_list').html('لطفاً یک دسته‌بندی انتخاب کنید.');
            return;
        }
        $('#bpu_product_list').html('در حال بارگذاری...');
        $.post(ajaxurl, {
            action: 'bpu_get_products_by_category',
            category_id: cat_id,
            page: page,
            keyword: keyword
        }, function(response){
            $('#bpu_product_list').html(response);
        });
    }

    function doSearch() {
        let cat_id = $('#bpu_edit_category').val();
        let keyword = $('#bpu_search_input').val();
        loadPage(cat_id, 1, keyword);
    }

    $('#bpu_search_btn').on('click', doSearch);
    $('#bpu_search_input').on('keypress', function(e){
        if (e.which === 13) {
            e.preventDefault();
            doSearch();
        }
    });
    $('#bpu_edit_category').on('change', doSearch);

    $(document).on('click', '.bpu-page-link', function(e){
        e.preventDefault();
        let cat_id = $('#bpu_edit_category').val();
        let page = $(this).data('page');
        let keyword = $('#bpu_search_input').val();
        loadPage(cat_id, page, keyword);
    });

    // ذخیره تغییرات هر محصول
    $(document).on('click', '.bpu-save-product', function(){
        const row = $(this).closest('tr');
        const data = {
            action: 'bpu_save_product_edit',
            product_id: row.data('id'),
            regular_price: row.find('.bpu_regular_price').val(),
            sale_price: row.find('.bpu_sale_price').val(),
            stock_qty: row.find('.bpu_stock').val(),
            warranty: row.find('.bpu_warranty').val(),
            sale_start: row.find('.bpu_sale_start').val(),
            sale_end: row.find('.bpu_sale_end').val(),
        };
        row.find('.bpu-status').html('در حال ذخیره...');
        $.post(ajaxurl, data, function(response){
            row.find('.bpu-status').html(response);
        });
    });

});

jQuery(document).ready(function($){
    $('#bpu_product_list').on('click', '.bpu-save-product', function(){
        var row = $(this).closest('tr');
        var data = {
            action: 'bpu_save_product_edit',
            product_id: row.data('id'),
            regular_price: row.find('.bpu_regular_price').val(),
            sale_price: row.find('.bpu_sale_price').val(),
            stock_qty: row.find('.bpu_stock').val(),
            warranty: row.find('.bpu_warranty').val(),
            sale_start: row.find('.bpu_sale_start').val(),
            sale_end: row.find('.bpu_sale_end').val(),
            snappbox: row.find('.bpu_snappbox').prop('checked') ? 'on' : 'off',
            has_supplier: row.find('.bpu_has_supplier').prop('checked') ? 'on' : 'off'
        };

        $.post(ajaxurl, data, function(response){
            row.find('.bpu-status').text(response);
        });
    });
});

