<?php



add_action('admin_enqueue_scripts', 'bpu_enqueue_admin_assets');
function bpu_enqueue_admin_assets() {

    wp_enqueue_style(
        'bpu-admin-css',
        'https://jahanbazar.com/wp-content/plugins/some-customize-features/assets/css/admin.css',
        [],
        '1.0.0'
    );

    wp_enqueue_script(
        'bpu-admin-js',
        'https://jahanbazar.com/wp-content/plugins/some-customize-features/assets/js/admin.js',
        ['jquery'],
        '1.0.0',
        true
    );

    wp_enqueue_style(
        'select2-css',
        'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css',
        [],
        null
    );

    wp_enqueue_script(
        'select2-js',
        'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js',
        ['jquery'],
        null,
        true
    );
}





add_action('admin_menu', 'bpu_register_admin_menu');

function bpu_register_admin_menu() {
    add_menu_page(
        'بروزرسانی قیمت',
        'بروزرسانی قیمت',
        'manage_woocommerce',
        'bulk-price-updater',
        'bpu_render_admin_page',
        'dashicons-update',
        56
    );

    add_submenu_page(
        'bulk-price-updater',
        'ویرایش گروهی',
        'ویرایش گروهی',
        'manage_woocommerce',
        'bulk-edit-products',
        'bpu_render_bulk_edit_page'
    );


}

function bpu_render_admin_page() {
    ?>
    <div class="wrap">
        <h1>بروزرسانی گروهی قیمت‌ها</h1>
        <table class="form-table">
            <tr>
                <th scope="row"><label>دسته‌بندی محصول</label></th>
                <td>
                    <select id="bpu_category" name="category[]" multiple style="width: 300px; height: 150px;">
                        <?php
                        $terms = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
                        foreach ($terms as $term) {
                            echo "<option value='{$term->term_id}'>{$term->name}</option>";
                        }
                        ?>
                    </select>
                    <p class="description">برای انتخاب چند دسته، Ctrl (یا Cmd) را نگه دارید.</p>
                </td>
            </tr>
            <tr>
                <th><label>نوع تغییر</label></th>
                <td>
                    <select id="bpu_type">
                        <option value="increase">افزایشی</option>
                        <option value="decrease">کاهشی</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th><label>درصد تغییر (%)</label></th>
                <td><input type="number" id="bpu_percent" step="0.01" placeholder="مثال : 10"></td>
            </tr>
            <tr>
                <th><label>مقدار عددی (تومان)</label></th>
                <td>
                    <input type="text" id="bpu_amount" placeholder="مثلاً 20,000">
                </td>
            </tr>
            <tr>
                <th><label>اعمال فقط روی محصولات موجود</label></th>
                <td>
                    <label><input type="checkbox" id="bpu_only_instock" checked> فقط محصولات موجود (in stock)</label>
                </td>
            </tr>
            
<tr>
    <th><label>ناموجود کردن محصولات انتخاب شده</label></th>
    <td>
        <label>
            <input type="checkbox" id="bpu_set_out_of_stock"> پس از بروزرسانی، همه محصولات انتخاب شده ناموجود شوند
        </label>
    </td>
</tr>


        </table>
        <button class="button button-primary" id="bpu_submit">اعمال تغییرات</button>
        <div id="bpu_result" style="margin-top: 20px;"></div>
    </div>

    <?php
}

add_action('wp_ajax_bpu_update_prices', function() {

    if (!current_user_can('manage_woocommerce')) {
        wp_die();
    }

    $category_ids     = array_map('intval', (array) $_POST['category']);
    $type             = sanitize_text_field($_POST['type']);
    $percent          = floatval($_POST['percent']);
    $amount           = floatval(str_replace(',', '', $_POST['amount']));
    $set_out_of_stock = !empty($_POST['set_out_of_stock']);
    $only_instock     = !empty($_POST['only_instock']);

    if (empty($category_ids)) {
        echo 'هیچ دسته‌ای انتخاب نشده است.';
        wp_die();
    }

    $args = [
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'tax_query'      => [[
            'taxonomy' => 'product_cat',
            'field'    => 'term_id',
            'terms'    => $category_ids,
        ]]
    ];

    $products = get_posts($args);
    $updated_count = 0;

    $round_to = 1000; // 🔥 گرد شدن به هزار تومان

    foreach ($products as $product_post) {

        $product = wc_get_product($product_post->ID);
        if (!$product) continue;

        // =============================
        // فقط محصولات ساده → تغییر قیمت
        // =============================
        if ($product->is_type('simple')) {

            // شرط فقط موجودها
            if ($only_instock && $product->get_stock_status() !== 'instock') {
                continue;
            }

            $regular_price = floatval($product->get_regular_price());
            $sale_price    = floatval($product->get_sale_price());
            $change        = 0;

            // محاسبه مقدار تغییر
            if ($percent != 0) {
                $change = $regular_price * ($percent / 100);
            } elseif ($amount != 0) {
                $change = $amount;
            }

            if ($type === 'decrease') {
                $change *= -1;
            }

            // ---------
            // قیمت جدید + گرد کردن
            // ---------
            $new_regular = round(($regular_price + $change) / $round_to) * $round_to;
            $product->set_regular_price(max(0, $new_regular));

            if ($sale_price > 0) {
                $new_sale = round(($sale_price + $change) / $round_to) * $round_to;
                $product->set_sale_price(max(0, $new_sale));
            }
        }

        // =============================
        // ناموجود کردن محصولات
        // =============================
        if ($set_out_of_stock) {

            // محصول ساده
            if ($product->is_type('simple')) {

                if (!$only_instock || $product->get_stock_status() === 'instock') {
                    $product->set_manage_stock(true);
                    $product->set_stock_quantity(0);
                    wc_update_product_stock_status($product->get_id(), 'outofstock');
                }
            }

            // محصول متغیر
            if ($product->is_type('variable')) {

                $variations = $product->get_children();
                $all_out = true;

                foreach ($variations as $variation_id) {
                    $variation = wc_get_product($variation_id);
                    if (!$variation) continue;

                    if (!$only_instock || $variation->get_stock_status() === 'instock') {
                        $variation->set_manage_stock(true);
                        $variation->set_stock_quantity(0);
                        wc_update_product_stock_status($variation_id, 'outofstock');
                        $variation->save();
                    }

                    if ($variation->get_stock_status() === 'instock') {
                        $all_out = false;
                    }
                }

                if ($all_out) {
                    wc_update_product_stock_status($product->get_id(), 'outofstock');
                }
            }
        }

        $product->save();
        $updated_count++;
    }

    echo "{$updated_count} محصول با موفقیت بروزرسانی و قیمت‌ها گرد شدند.";
    wp_die();
});





// صفحه ویرایش گروهی
function bpu_render_bulk_edit_page() {
    ?>
    <div class="wrap">
        <h1 style="font-size: 26px; margin-bottom: 20px;">ویرایش گروهی محصولات</h1>

        <label for="bpu_edit_category" style="font-weight: bold; margin-bottom: 10px; display: inline-block;">انتخاب دسته‌بندی:</label>
        <select id="bpu_edit_category" style="min-width: 250px; padding: 5px; font-size: 15px;">
            <option value="">-- انتخاب کنید --</option>
            <?php
            $terms = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
            foreach ($terms as $term) {
                echo "<option value='{$term->term_id}'>{$term->name}</option>";
            }
            ?>
        </select>

        <input type="text" id="bpu_search_input" placeholder="جستجو در عنوان محصول..." style="margin-right: 15px; padding: 5px; font-size: 15px; width: 250px;" />
        <button id="bpu_search_btn" class="button" style="vertical-align: top;">جستجو</button>

        <div id="bpu_product_list" style="margin-top: 30px;"></div>
    </div>

    <style>
    .snappbox-badge {
        color: #fff !important;
        background-color: #e74c3c !important;
        padding: 2px 6px !important;
        font-size: 12px !important;
        border-radius: 3px !important;
        margin-left: 5px !important;
        display: inline-block !important;
        white-space: nowrap !important;
        line-height: 1.4 !important;
    }

    .supplier-badge {
        color: #fff !important;
        background: linear-gradient(135deg, #f5d76e, #f39c12) !important;
        padding: 2px 6px !important;
        font-size: 12px !important;
        border-radius: 3px !important;
        margin-left: 5px !important;
        display: inline-block !important;
        white-space: nowrap !important;
        line-height: 1.4 !important;
    }
    </style>
    <?php
}

// AJAX: گرفتن محصولات با صفحه‌بندی واقعی
add_action('wp_ajax_bpu_get_products_by_category', function() {
    $cat_id = intval($_POST['category_id']);
    $page = isset($_POST['page']) ? max(1, intval($_POST['page'])) : 1;
    $keyword = isset($_POST['keyword']) ? sanitize_text_field($_POST['keyword']) : '';
    $products_per_page = 20;

    $args = [
        'post_type' => 'product',
        'posts_per_page' => $products_per_page,
        'paged' => $page,
        's' => $keyword,
        'tax_query' => [[
            'taxonomy' => 'product_cat',
            'field'    => 'term_id',
            'terms'    => $cat_id,
        ]]
    ];

    $query = new WP_Query($args);
    $products = $query->posts;
    $total_pages = $query->max_num_pages;

    if (!$products) {
        echo '<p>محصولی پیدا نشد.</p>';
        wp_die();
    }

    echo '<table class="wp-list-table widefat striped">';
    echo '<thead><tr>
            <th>عنوان</th>
            <th>قیمت عادی</th>
            <th>قیمت فروش ویژه</th>
            <th>موجودی</th>
            <th>گارانتی</th>
            <th>اسنپ‌باکس</th>
            <th>تامین‌کننده</th>
            <th>شروع فروش ویژه</th>
            <th>پایان فروش ویژه</th>
            <th>مشاهده</th>
            <th>عملیات</th>
        </tr></thead><tbody>';

    foreach ($products as $product_post) {
        $product = wc_get_product($product_post->ID);
        if (!$product) continue;

        $reg_price = $product->get_regular_price();
        $sale_price = $product->get_sale_price();
        $stock = $product->get_stock_quantity();
        $warranty = get_post_meta($product->get_id(), 'dina_public_meta_value_one', true);
        $snappbox = get_post_meta($product->get_id(), '_snappbox_allowed', true);
        $has_supplier = get_post_meta($product->get_id(), '_has_supplier', true);
        $sale_start = $product->get_date_on_sale_from() ? $product->get_date_on_sale_from()->date('Y-m-d') : '';
        $sale_end = $product->get_date_on_sale_to() ? $product->get_date_on_sale_to()->date('Y-m-d') : '';
        $product_url = get_permalink($product->get_id());

        echo "<tr data-id='{$product->get_id()}'>
            <td>{$product->get_name()}</td>
            <td><input class='bpu_regular_price' type='number' step='0.01' value='{$reg_price}'></td>
            <td><input class='bpu_sale_price' type='number' step='0.01' value='{$sale_price}'></td>
            <td><input class='bpu_stock' type='number' value='{$stock}'></td>
            <td><input class='bpu_warranty' type='text' value='{$warranty}'></td>
            <td><input type='checkbox' class='bpu_snappbox' ".checked($snappbox,'yes',false)."></td>
            <td><input type='checkbox' class='bpu_has_supplier' ".checked($has_supplier,'yes',false)."></td>
            <td><input class='bpu_sale_start' type='date' value='{$sale_start}'></td>
            <td><input class='bpu_sale_end' type='date' value='{$sale_end}'></td>
            <td><a class='bpu-view-product' href='{$product_url}' target='_blank'>محصول</a></td>
            <td><button class='bpu-save-product'>ذخیره</button> <span class='bpu-status'></span></td>
        </tr>";
    }

    echo '</tbody></table>';

    // لینک‌های صفحه‌بندی
    if ($total_pages > 1) {
        echo '<div class="bpu-pagination" style="margin-top:15px;">';
        for ($i = 1; $i <= $total_pages; $i++) {
            $active = ($i == $page) ? 'font-weight:bold;' : '';
            echo "<a href='#' class='bpu-page-link' data-page='{$i}' style='margin:0 5px;{$active}'>{$i}</a>";
        }
        echo '</div>';
    }

    wp_die();
});


// AJAX: ذخیره محصولات
add_action('wp_ajax_bpu_save_product_edit', function() {
    $id = intval($_POST['product_id']);
    $product = wc_get_product($id);
    if (!$product) { echo 'نامعتبر'; wp_die(); }

    $product->set_regular_price($_POST['regular_price']);
    $product->set_sale_price($_POST['sale_price']);
    $product->set_stock_quantity($_POST['stock_qty']);
    $product->set_date_on_sale_from($_POST['sale_start'] ? strtotime($_POST['sale_start']) : null);
    $product->set_date_on_sale_to($_POST['sale_end'] ? strtotime($_POST['sale_end']) : null);
    $product->save();

    if (isset($_POST['warranty'])) update_post_meta($id, 'dina_public_meta_value_one', sanitize_text_field($_POST['warranty']));

    $snappbox_allowed = isset($_POST['snappbox']) && $_POST['snappbox'] === 'on' ? 'yes' : 'no';
    $has_supplier = isset($_POST['has_supplier']) && $_POST['has_supplier'] === 'on' ? 'yes' : 'no';
    update_post_meta($id, '_snappbox_allowed', $snappbox_allowed);
    update_post_meta($id, '_has_supplier', $has_supplier);

    echo 'ذخیره شد';
    wp_die();
});

// نمایش بج‌ها در سبد خرید، تسویه حساب و سفارشات
add_filter('woocommerce_cart_item_name', function($product_name, $cart_item, $cart_item_key) {
    $product_id = $cart_item['product_id'];
    if (get_post_meta($product_id, '_snappbox_allowed', true) === 'yes') {
        $product_name .= ' <span class="snappbox-badge"></span>';
    }
    if (get_post_meta($product_id, '_has_supplier', true) === 'yes') {
        $product_name .= ' <span class="supplier-badge"></span>';    }
    return $product_name;
}, 10, 3);

add_filter('woocommerce_order_item_name', function($item_name, $item, $is_visible) {
    $product_id = $item->get_product_id();
    if (get_post_meta($product_id, '_snappbox_allowed', true) === 'yes') {
        $item_name .= ' <span class="snappbox-badge"></span>';
    }
    if (get_post_meta($product_id, '_has_supplier', true) === 'yes') {
        $item_name .= ' <span class="supplier-badge"></span>';  
    }
    return $item_name;
}, 10, 3);
