<?php


if (!defined('ABSPATH')) exit;


add_action('admin_menu', 'jb_orders_add_submenu');
function jb_orders_add_submenu() {
    add_submenu_page(
        'woocommerce',            // parent slug -> زیر منوی ووکامرس
        'مدیریت سفارشات',         // page title
        'مدیریت سفارشات',         // menu title
        'manage_woocommerce',     // capability
        'jb-orders',              // menu slug
        'jb_orders_page_content'  // callback
    );
}


function jb_orders_page_content() {
    $paged    = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
    $per_page = 20;

    $args = array(
        'limit'   => $per_page,
        'paged'   => $paged,
        'orderby' => 'date',
        'order'   => 'DESC',
        'type'    => 'shop_order',
    );
    $orders = wc_get_orders($args);

    $total_query = new WC_Order_Query(array(
        'return' => 'ids',
        'limit'  => -1,
        'type'   => 'shop_order',
    ));
    $total_orders = count($total_query->get_orders());
    $total_pages  = $per_page ? ceil($total_orders / $per_page) : 1;

    $nonce = wp_create_nonce('jb_order_manager_nonce');

    echo '<div class="wrap">';
    echo '<h1>مدیریت سفارشات</h1>';

  echo '<table class="widefat fixed striped" style="table-layout:fixed;">';
echo '<thead><tr>
        <th style="width:90px;">شماره سفارش</th>
        <th style="width:180px;">نام مشتری</th>
        <th style="width:120px;">موبایل</th>
        <th style="width:200px;">آدرس</th>
        <th style="width:180px;">روش ارسال</th>
        <th style="width:180px;">روش پرداخت</th>
        <th style="width:220px;">عملیات</th>
        <th style="width:220px;">توضیحات تکمیلی</th>
        <th style="width:220px;">یادداشت‌ها</th>
        <th style="width:180px;">وضعیت</th>
      </tr></thead><tbody>';

if ($orders && is_array($orders)) {
    foreach ($orders as $order) {
        if (!$order || ! $order instanceof WC_Order) continue;

        $order_id     = (int) $order->get_id();
        $order_number = $order->get_order_number();
        $order_link   = esc_url( admin_url( 'post.php?post=' . $order_id . '&action=edit' ) );
        $customer     = esc_html( $order->get_formatted_billing_full_name() ?: ('کاربر #' . $order->get_customer_id()) );
        $phone        = esc_html( $order->get_billing_phone() ?: '—' );

        $raw_address = $order->get_formatted_billing_address();
        $address = $raw_address ? esc_html( trim( preg_replace('/\s+/', ' ', str_replace( array("<br/>","<br />","<br>"), " - ", $raw_address ) ) ) ) : '—';

        $shipping_methods = $order->get_shipping_methods();
        $shipping_text = [];
        foreach ($shipping_methods as $method) {
            $shipping_text[] = $method->get_name();
        }
        $shipping_text = !empty($shipping_text) ? implode(', ', $shipping_text) : '—';

        $payment_method = $order->get_payment_method_title();
        $transaction_id = $order->get_transaction_id();
        if ($payment_method) {
            $payment_output = esc_html($payment_method);
            if ($transaction_id) {
                $payment_output .= '<br><small style="color:#555;">شماره تراکنش: '. esc_html($transaction_id) .'</small>';
            }
        } else {
            $payment_output = '—';
        }

        // یادداشت‌ها
        $all_notes = wc_get_order_notes(array('order_id' => $order_id));
        ob_start();
        if ($order->get_customer_note()) {
            echo '<div><strong>یادداشت مشتری:</strong> ' . esc_html( wp_strip_all_tags( $order->get_customer_note() ) ) . '</div>';
        }
        if ($all_notes) {
            foreach ($all_notes as $note) {
                $raw = method_exists($note, 'get_content') ? $note->get_content() : ( isset($note->content) ? $note->content : '' );
                $clean = trim( preg_replace('/\s+/', ' ', wp_strip_all_tags( $raw ) ) );
                if ($clean === '') continue;
                echo '<div style="margin-top:6px;font-size:13px;">- ' . esc_html( $clean ) . '</div>';
            }
        }
        $notes_html = ob_get_clean();
        if (trim($notes_html) === '') $notes_html = '---';

        // وضعیت سفارش
        $statuses = wc_get_order_statuses(); 
        $current_status = $order->get_status();
        $status_select = '<select class="jb-order-status" data-id="'. $order_id .'">';
        foreach ($statuses as $key => $label) {
            $selected = selected( 'wc-' . $current_status, $key, false );
            $status_select .= '<option value="'. esc_attr($key) .'" '. $selected .'>'. esc_html($label) .'</option>';
        }
        $status_select .= '</select>';

        // شروع ردیف
echo '<tr id="jb-order-row-' . $order_id . '">';

// شماره سفارش
echo '<td style="vertical-align:top;"><a href="' . $order_link . '" target="_blank">#' . $order_number . '</a></td>';

// نام مشتری
echo '<td style="vertical-align:top; font-weight:900;">' . $customer . '</td>';

// موبایل
echo '<td style="vertical-align:top;">' . $phone . '</td>';

// آدرس
echo '<td style="vertical-align:top;">' . $address . '</td>';

// روش ارسال
echo '<td style="vertical-align:top;">' . esc_html($shipping_text) . '</td>';

// روش پرداخت
echo '<td style="vertical-align:top;">' . $payment_output . '</td>';

// ستون پیامک + دکمه فاکتور
// ستون ارسال پیامک + فاکتور + برچسب پستی
$pwoosms_box_id     = 'pwoosms_box_' . $order_id;
$pwoosms_result_id  = 'pwoosms_result_' . $order_id;
$pwoosms_area_id    = 'pwoosms_message_' . $order_id;

// لینک فاکتور
$order_key = $order->get_order_key();
$invoice_url = add_query_arg([
    'action'    => 'wip-print',
    'type'      => 'invoice',
    'order-id'  => $order_id,
    'order-key' => $order_key,
], home_url('/'));

// لینک برچسب پستی
$post_label_url = add_query_arg([
    'action'    => 'wip-print',
    'type'      => 'post-label',
    'order-id'  => $order_id,
    'order-key' => $order_key,
], home_url('/'));

echo '<td style="vertical-align:top;">';

// دکمه ارسال پیامک
echo '<button class="button jb-toggle-pwoosms" data-order="' . $order_id . '">ارسال پیامک</button>';
echo '<div id="' . $pwoosms_box_id . '" class="jb-pwoosms-box" style="display:none; margin-top:8px;">';
    echo '<div id="' . $pwoosms_result_id . '" class="jb-pwoosms-result" style="display:none; padding:6px; border-radius:3px;"></div>';
    echo '<p style="margin:6px 0;">ارسال به: <strong>' . $phone . '</strong></p>';
    echo '<textarea id="' . $pwoosms_area_id . '" class="widefat" rows="4" style="margin-bottom:6px;"></textarea>';
    echo '<div style="text-align:left;">';
        echo '<button class="button button-primary jb-pwoosms-submit" data-order="' . $order_id . '">ارسال</button>';
        echo ' <span class="jb-pwoosms-loading" style="display:none;"><img src="' 
                . esc_url( plugins_url( '/persian-woocommerce-sms/assets/images/ajax-loader.gif' ) ) 
                . '" alt=""></span>';
    echo '</div>';
echo '</div>';

// دکمه فاکتور
echo '<div style="margin-top:8px;">';
echo '<a href="' . esc_url($invoice_url) . '" class="button" target="_blank" style="background:#2271b1;color:#fff;">برگه فاکتور</a>';
echo '</div>';

// دکمه برچسب پستی
echo '<div style="margin-top:6px;">';
echo '<a href="' . esc_url($post_label_url) . '" class="button" target="_blank" style="background:#444;color:#fff;">برگه برچسب پستی</a>';
echo '</div>';

// دکمه برچسب محصول  ← درست اضافه شد و داخل <td>
$product_label_url = add_query_arg([
    'action'    => 'wip-print',
    'type'      => 'product-label',
    'order-id'  => $order_id,
    'order-key' => $order_key,
], home_url('/'));

echo '<div style="margin-top:6px;">';
echo '<a href="' . esc_url($product_label_url) . '" class="button" target="_blank" style="background:#880;color:#fff;">برگه برچسب محصول</a>';
echo '</div>';

// دکمه برچسب سفارش
$order_label_url = add_query_arg([
    'action'    => 'wip-print',
    'type'      => 'order-label',
    'order-id'  => $order_id,
    'order-key' => $order_key,
], home_url('/'));

echo '<div style="margin-top:6px;">';
echo '<a href="' . esc_url($order_label_url) . '" class="button" target="_blank" style="background:#cc5500;color:#fff;">برگه برچسب سفارش</a>';
echo '</div>';

echo '</td>';  // ← حالا درست بسته می‌شود



// توضیحات تکمیلی
echo '<td style="vertical-align:top;">' . ($order->get_customer_note() ? esc_html($order->get_customer_note()) : '—') . '</td>';

// یادداشت‌ها
$note_input_id = 'jb_note_input_' . $order_id;
echo '<td style="vertical-align:top;">';
echo '<div class="jb-order-notes" style="max-height:80px; overflow:auto; padding:6px; border:1px solid #eee; background:#fff;">'. $notes_html .'</div>';
echo '<textarea id="'. $note_input_id .'" rows="2" class="widefat" placeholder="یادداشت جدید..."></textarea>';
echo '<button class="button jb-add-note" data-order="'. $order_id .'" style="margin-top:6px;">افزودن یادداشت</button>';
echo '<div class="jb-note-msg" id="jb-note-msg-'. $order_id .'"></div>';
echo '</td>';

// وضعیت
echo '<td style="vertical-align:top;">';
echo $status_select;
echo '<div style="margin-top:6px;">';
echo '<button class="button jb-save-status" data-order="'. $order_id .'">ذخیره</button>';
echo '<div class="jb-status-msg" id="jb-status-msg-'. $order_id .'" style="margin-top:6px;"></div>';
echo '</div></td>';

echo '</tr>';


echo '</tr>';

    }

    } else {
        echo '<tr><td colspan="8">هیچ سفارشی یافت نشد.</td></tr>';
    }

    echo '</tbody></table>';

    if ($total_pages > 1) {
        $base = add_query_arg( 'paged', '%#%' );
        echo '<div class="tablenav"><div class="tablenav-pages" style="margin-top:12px;">';
        echo paginate_links( array(
            'base'      => $base,
            'format'    => '',
            'prev_text' => '« قبلی',
            'next_text' => 'بعدی »',
            'total'     => $total_pages,
            'current'   => $paged,
        ) );
        echo '</div></div>';
    }

    echo '</div>'; 
}

add_action('admin_footer', function () {
    $screen = function_exists('get_current_screen') ? get_current_screen() : null;
    if (!$screen) return;
    if ($screen->id !== 'woocommerce_page_jb-orders') return;

    $ajax_url = admin_url('admin-ajax.php');
    $nonce = wp_create_nonce('jb_order_manager_nonce');
    ?>
    <style>
        .jb-pwoosms-box { border:1px solid #e6e6e6; padding:8px; background:#fff; border-radius:4px; max-width:420px; }
        .jb-pwoosms-result.success { color:#155724; background:#d4edda; border:1px solid #c3e6cb; display:block; }
        .jb-pwoosms-result.fault { color:#721c24; background:#f8d7da; border:1px solid #f5c6cb; display:block; }
        .jb-order-notes div { padding:3px 0; border-bottom:1px dashed #eee; }
        .jb-order-status { width: 170px;}
    </style>

    <script type="text/javascript">
    jQuery(function($){
        var ajaxurl = '<?php echo esc_js($ajax_url); ?>';
        var nonce = '<?php echo esc_js($nonce); ?>';

        $(document).on('click', '.jb-toggle-pwoosms', function(e){
            e.preventDefault();
            var order = $(this).data('order');
            $('#pwoosms_box_' + order).slideToggle(180);
        });

        $(document).on('click', '.jb-pwoosms-submit', function(e){
            e.preventDefault();
            var btn = $(this);
            var order = btn.data('order');
            var msgBox = $('#pwoosms_result_' + order);
            var message = $('#pwoosms_message_' + order).val();
            var loading = btn.siblings('.jb-pwoosms-loading');

            if (!message || message.trim() === '') {
                msgBox.removeClass('success').addClass('fault').html('متن پیامک خالی است.').show();
                return;
            }

            btn.prop('disabled', true);
            loading.show();
            msgBox.hide();

            $.post(ajaxurl, {
                action: 'jb_send_sms',
                security: nonce,
                order_id: order,
                message: message
            }, function(res){
                if (res && res.success) {
                    msgBox.removeClass('fault').addClass('success').html(res.data.message || 'ارسال شد').show();
                } else {
                    var err = (res && res.data && res.data.message) ? res.data.message : 'خطا در ارسال';
                    msgBox.removeClass('success').addClass('fault').html(err).show();
                }
                btn.prop('disabled', false);
                loading.hide();
                if (res && res.success) $('#pwoosms_message_' + order).val('');
            }).fail(function(){
                msgBox.removeClass('success').addClass('fault').html('خطا در ارتباط با سرور').show();
                btn.prop('disabled', false);
                loading.hide();
            });
        });

        $(document).on('click', '.jb-add-note', function(e){
            e.preventDefault();
            var btn = $(this);
            var order = btn.data('order');
            var textarea = $('#jb_note_input_' + order);
            var note = textarea.val();
            var msgBox = $('#jb-note-msg-' + order);

            if (!note || note.trim() === '') {
                msgBox.html('<span style="color:#b71c1c">لطفاً متن یادداشت را وارد کنید.</span>');
                return;
            }

            btn.prop('disabled', true);
            msgBox.html('در حال ذخیره...');

            $.post(ajaxurl, {
                action: 'jb_add_order_note',
                security: nonce,
                order_id: order,
                note: note
            }, function(res){
                if (res && res.success) {
                    msgBox.html('<span style="color:green">' + (res.data.message || 'ذخیره شد') + '</span>');
                    var notesDiv = $('#jb-order-row-' + order).find('.jb-order-notes');
                    notesDiv.prepend('<div style="margin-top:6px;font-size:13px;">- ' + $('<div>').text(note).html() + '</div>');
                    textarea.val('');
                } else {
                    var err = (res && res.data && res.data.message) ? res.data.message : 'خطا';
                    msgBox.html('<span style="color:#b71c1c">' + err + '</span>');
                }
                btn.prop('disabled', false);
            }).fail(function(){
                msgBox.html('<span style="color:#b71c1c">خطا در ارتباط با سرور</span>');
                btn.prop('disabled', false);
            });
        });

        $(document).on('click', '.jb-save-status', function(e){
            e.preventDefault();
            var btn = $(this);
            var order = btn.data('order');
            var sel = $('#jb-order-row-' + order).find('.jb-order-status');
            var status = sel.val();
            var msgBox = $('#jb-status-msg-' + order);

            btn.prop('disabled', true);
            msgBox.html('در حال ذخیره...');

            $.post(ajaxurl, {
                action: 'jb_update_order_status',
                security: nonce,
                order_id: order,
                status: status
            }, function(res){
                if (res && res.success) {
                    msgBox.html('<span style="color:green">' + (res.data.message || 'ذخیره شد') + '</span>');
                } else {
                    var err = (res && res.data && res.data.message) ? res.data.message : 'خطا';
                    msgBox.html('<span style="color:#b71c1c">' + err + '</span>');
                }
                btn.prop('disabled', false);
            }).fail(function(){
                msgBox.html('<span style="color:#b71c1c">خطا در ارتباط با سرور</span>');
                btn.prop('disabled', false);
            });
        });

    });
    </script>
    <?php
});


add_action('wp_ajax_jb_send_sms', function () {
    check_ajax_referer('jb_order_manager_nonce', 'security');

    $order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : 0;
    $message  = isset($_POST['message']) ? sanitize_textarea_field($_POST['message']) : '';

    if (!$order_id || $message === '') {
        wp_send_json_error(array('message' => 'پارامترهای ورودی ناقص است.'));
    }

    $order = wc_get_order($order_id);
    if (!$order) {
        wp_send_json_error(array('message' => 'سفارش یافت نشد.'));
    }

    do_action('pwoosms_send_manual_sms', $order_id, $message);

    wp_send_json_success(array('message' => 'پیامک با موفقیت ارسال شد.'));
});


add_action('wp_ajax_jb_add_order_note', function () {
    check_ajax_referer('jb_order_manager_nonce', 'security');

    $order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : 0;
    $note     = isset($_POST['note']) ? sanitize_textarea_field($_POST['note']) : '';

    if (!$order_id || $note === '') {
        wp_send_json_error(array('message' => 'پارامترهای ورودی ناقص است.'));
    }

    $order = wc_get_order($order_id);
    if (!$order) {
        wp_send_json_error(array('message' => 'سفارش یافت نشد.'));
    }

    $order->add_order_note( $note, 0 );
    wp_send_json_success(array('message' => 'یادداشت اضافه شد.'));
});


add_action('wp_ajax_jb_update_order_status', function () {
    check_ajax_referer('jb_order_manager_nonce', 'security');

    $order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : 0;
    $status   = isset($_POST['status']) ? sanitize_text_field($_POST['status']) : '';

    if (!$order_id || $status === '') {
        wp_send_json_error(array('message' => 'پارامترهای ورودی ناقص است.'));
    }

    $order = wc_get_order($order_id);
    if (!$order) {
        wp_send_json_error(array('message' => 'سفارش یافت نشد.'));
    }

    $status_to_set = str_replace('wc-', '', $status);
    $order->update_status( $status_to_set );

    wp_send_json_success(array('message' => 'وضعیت سفارش تغییر کرد.'));
});

/**
 * افزودن دکمه‌های فاکتور و برچسب پستی به هر سفارش
 */

add_filter( 'woocommerce_admin_order_actions', 'add_invoice_buttons_to_orders', 100, 2 );
function add_invoice_buttons_to_orders( $actions, $order ) {

    $order_id = $order->get_id();

    // دکمه: برگه فاکتور
    $actions['print_invoice'] = array(
        'url'       => wp_nonce_url( admin_url( 'admin-ajax.php?action=print_invoice&order_id=' . $order_id ), 'print_invoice' ),
        'name'      => __( 'برگه فاکتور', 'woocommerce' ),
        'action'    => 'view invoice', // برای استایل آیکون
    );

    // دکمه: برگه برچسب پستی
    $actions['print_shipping_label'] = array(
        'url'       => wp_nonce_url( admin_url( 'admin-ajax.php?action=print_shipping_label&order_id=' . $order_id ), 'print_shipping_label' ),
        'name'      => __( 'برگه برچسب پستی', 'woocommerce' ),
        'action'    => 'view label', // برای استایل آیکون
    );

    return $actions;
}

add_action( 'wp_ajax_print_invoice', 'print_invoice_callback' );
function print_invoice_callback() {

    if ( ! isset($_GET['order_id']) ) {
        wp_die('Order ID not found');
    }

    $order_id = intval($_GET['order_id']);
    $order    = wc_get_order($order_id);

    if ( ! $order ) {
        wp_die('Invalid order');
    }

    // اینجا خروجی HTML فاکتور را بساز
    echo "<h2>فاکتور سفارش #" . $order_id . "</h2>";
    echo "<p>نام مشتری: " . $order->get_formatted_billing_full_name() . "</p>";
    echo "<p>مبلغ: " . wc_price($order->get_total()) . "</p>";

    wp_die();
}

add_action( 'wp_ajax_print_shipping_label', 'print_shipping_label_callback' );
function print_shipping_label_callback() {

    if ( ! isset($_GET['order_id']) ) {
        wp_die('Order ID not found');
    }

    $order_id = intval($_GET['order_id']);
    $order    = wc_get_order($order_id);

    if ( ! $order ) {
        wp_die('Invalid order');
    }

    // خروجی نمونه — می‌توانی قالب واقعی اضافه کنی
    echo "<h2>برچسب پستی سفارش #" . $order_id . "</h2>";
    echo "<p>گیرنده: " . $order->get_formatted_shipping_full_name() . "</p>";
    echo "<p>آدرس: " . $order->get_shipping_address_1() . "</p>";

    wp_die();
}

