<?php
if (!defined('ABSPATH')) exit;

/* ==================================================
   Shortcode: Ajax Product Search
================================================== */
add_shortcode('ajax_product_search','aps_search_form_shortcode');
function aps_search_form_shortcode() {
    ob_start(); ?>

<div class="aps-glass-overlay"></div>

<div class="aps-search-wrapper">
    <div class="aps-search-box">
        <input type="text" id="aps-search-input" placeholder="جستجوی محصول...">
        <i class="fal fa-magnifying-glass aps-search-icon"></i>
    </div>
    <div id="aps-search-results"></div>
</div>

<style>
.aps-search-wrapper{
    position:relative;
    max-width:900px;
    font-family:tahoma;
}
.aps-glass-overlay{
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.15);  
    backdrop-filter: blur(3px);    
    -webkit-backdrop-filter: blur(3px);
    z-index: 998;
    display: none;
    transition: .100s ease;
}

.aps-search-wrapper{
    position: relative;
    z-index: 999;
.aps-search-box{position:relative}

#aps-search-input{
    width:700px;
    padding:18px 22px 18px 52px;
    border-radius:10px;
    border:none;
    font-size:18px;
    outline:none;
}

.aps-search-icon{
    position:absolute;
    left:18px;
    top:50%;
    transform:translateY(-50%);
    font-size:20px;
    color:#888;
    cursor:pointer;
    transition:.25s ease;
}

.aps-search-icon:hover{color:#D8005A}

#aps-search-results{
    position:absolute;
    top:120%;
    width:100%;
    background:#fff;
    border-radius:20px;
    box-shadow:0 20px 50px rgba(0,0,0,.18);
    display:none;
    z-index:9999;
    max-height:520px;
    overflow-y:auto;
}

.aps-results-list{
    list-style:none;
    margin:0;
    padding:0;
    font-family:'Dana',sans-serif;
}

.aps-results-list li{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:14px;
    margin:8px;
    border-radius:14px;
    background:#f9f9f9;
}

.aps-results-list img{
    width:60px;
    height:60px;
    object-fit:cover;
    border-radius:12px;
    margin-left:12px;
}

.aps-title{font-weight:900;font-family:'Dana',sans-serif;font-size:.875rem;}
.aps-price{
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    gap: 4px;
    font-family: 'Dana', sans-serif;
    font-weight:700;
}

.aps-price del{
    display: block;
    font-size: 13px;
    color: #999;
}

.aps-price ins{
    display: block;
    font-size: 15px;
    font-weight: 800;
    color: #D32F2F;
    text-decoration: none;
}


.aps-view-all{
    display:block;
    margin:12px;
    padding:14px;
    text-align:center;
    border-radius:6px;
    background:#D8005A;
    color:#fff;
    font-weight:700;
    text-decoration:none;
    font-family:'Dana',sans-serif;
}

.aps-view-all:hover{color:#fff}

.aps-categories-slider{
    display:flex;
    overflow-x:auto;
    padding:10px;
}

.aps-category-slide{
    flex:0 0 auto;
    margin-left:12px;
    text-align:center;
}

.aps-category-slide img{
    width:90px;
    height:90px;
    border-radius:12px;
    object-fit:cover;
}

.aps-no-result{
    text-align:center;
    padding:20px;
    color:#999;
    font-family:'Dana',sans-serif;
}

/* ===== Tablet ===== */
@media(max-width:768px){
    #aps-search-input{width:300px;font-size:16px}
}

/* ===== Mobile ===== */
@media (max-width: 480px){

    .aps-search-wrapper{
        margin: 0px !important;
    }
    .aps-glass-overlay{
        position: fixed;
        inset: 0;
        background: rgba(0,0,0,0.15);  
        backdrop-filter: blur(3px);    
        -webkit-backdrop-filter: blur(3px);
        z-index: 998;
        display: none;
        transition: .100s ease;
    }
    .aps-search-icon {
        position: absolute;
        left: 30px;
    }
    
    #aps-search-input{
        width: 330px;
        padding: 14px 16px;
        border-radius: 12px;
        font-size: 16px;
        transform: scale(0.94);
        transform-origin: right center;
    }

    #aps-search-results{
        width: 350px;
        max-height: 50vh;
        border-radius: 16px;
    }

    .aps-results-list li{
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 6px;
        padding: 12px;
        margin: 6px;
        overflow: hidden;
        font-family: 'Dana', sans-serif;
    }

    .aps-title{
        width: 100%;
        font-size: 10px;
        font-weight: 600;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .aps-results-list img{
        width: 50px;
        height: 50px;
        margin-bottom: 6px;
    }

    .aps-price{
        width: 100%;
        font-size: 14px;
        font-weight: 700;
        color: #388E3C;
        text-align: left;
        align-self: flex-end;
        direction: ltr;
    }
        .aps-price{
        width: 100%;
        text-align: left;
        align-self: flex-end;
        direction: ltr;
    }
}

</style>

<script>
jQuery(document).ready(function($){

    const $input = $('#aps-search-input');
    const $icon  = $('.aps-search-icon');
    const $overlay = $('.aps-glass-overlay');
    const $results = $('#aps-search-results');

    // تغییر آیکون ذره‌بین ↔ ضربدر
    function toggleIcon(){
        if($input.val().trim().length){
            $icon.removeClass('fa-magnifying-glass')
                 .addClass('fa-circle-xmark');
        } else {
            $icon.removeClass('fa-circle-xmark')
                 .addClass('fa-magnifying-glass');
        }
    }

    // فراخوانی نتایج از AJAX
    function fetchResults(keyword){
        keyword = keyword.trim();
        toggleIcon();

        if(keyword.length < 2){
            $results.fadeOut().html('');
            return;
        }

        $.ajax({
            url:'<?php echo admin_url("admin-ajax.php"); ?>',
            data:{action:'aps_search_products',keyword:keyword},
            dataType:'json',
            success:function(data){
                let html='';

                // محصولات
                if(data.products.length){
                    html+='<h4 style="padding:10px 20px;color:#388E3C">محصولات</h4>';
                    html+='<ul class="aps-results-list">';
                    data.products.forEach(function(p,i){
                        if(i>=8) return;
                        html+='<li><a href="'+p.url+'" style="display:flex;align-items:center;text-decoration:none;color:#333">';
                        if(p.image) html+='<img src="'+p.image+'">';
                        html+='<span class="aps-title">'+p.title+'</span></a>';
                        html+='<span class="aps-price">'+p.price+'</span></li>';
                    });
                    html+='</ul>';
                    html+='<a class="aps-view-all" href="<?php echo esc_url(home_url('/')); ?>?s='+encodeURIComponent(keyword)+'&post_type=product">مشاهده همه نتایج</a>';
                }

                // دسته‌بندی‌ها
                if(data.categories.length){
                    html+='<h4 style="padding:10px 20px;color:#1976D2">دسته‌بندی‌ها</h4>';
                    html+='<div class="aps-categories-slider">';
                    data.categories.forEach(function(c){
                        html+='<div class="aps-category-slide"><a href="'+c.url+'">';
                        html+='<img src="'+c.image+'"><div class="aps-title">'+c.title+'</div></a></div>';
                    });
                    html+='</div>';
                }

                if(!data.products.length && !data.categories.length){
                    html='<p class="aps-no-result">نتیجه‌ای یافت نشد</p>';
                }

                $results.html(html).fadeIn();
            }
        });
    }

    // ---------- فوکوس روی input ----------
    $input.on('focus', function(){
        $overlay.fadeIn(200);
        if($input.val().trim().length){
            $results.fadeIn(); // وقتی دوباره روی input کلیک شد، نتایج نمایش داده شود
        }
    });

    // ---------- تایپ در input ----------
    $input.on('input', function(){
        fetchResults($(this).val());
    });

    // ---------- کلیک روی آیکون ----------
    $icon.on('click', function(){
        if($input.val().trim()){
            $input.val('').focus();
            $results.fadeOut().html('');
            $overlay.fadeOut();
            toggleIcon();
        }
    });

    // ---------- کلیک در خارج از باکس ----------
    $(document).on('click', function(e){
        if(!$(e.target).closest('.aps-search-wrapper').length){
            $results.fadeOut();
            $overlay.fadeOut();
            toggleIcon();
        }
    });

});
</script>


    <?php return ob_get_clean();
}

/* ==================================================
   AJAX Search Handler
================================================== */
add_action('wp_ajax_aps_search_products','aps_search_products');
add_action('wp_ajax_nopriv_aps_search_products','aps_search_products');

function aps_search_products(){
    if(!isset($_GET['keyword'])) wp_send_json([]);
    $keyword = sanitize_text_field($_GET['keyword']);
    $words = array_filter(explode(' ',$keyword));
    if(empty($words)) wp_send_json([]);

    $args = [
        'post_type'=>'product',
        'posts_per_page'=>50,
        'post_status'=>'publish',
        's'=>$keyword,
        'meta_query'=>[
            ['key'=>'_price','value'=>0,'compare'=>'>']
        ]
    ];

    $query = new WP_Query($args);
    $products=[];

    if($query->have_posts()){
        while($query->have_posts()){
            $query->the_post();
            $product = wc_get_product(get_the_ID());
            if(!$product || !$product->get_price()) continue;

            $combined = strtolower(
                get_the_title().' '.$product->get_sku().' '.wp_strip_all_tags($product->get_short_description())
            );

            $match=true;
            foreach($words as $w){
                if(strpos($combined,strtolower($w))===false){$match=false;break;}
            }

            if($match){
                $products[]=[
                    'title'=>get_the_title(),
                    'url'=>get_permalink(),
                    'image'=>get_the_post_thumbnail_url(get_the_ID(),'woocommerce_thumbnail'),
                    'price'=>$product->get_price_html()
                ];
            }
        }
        wp_reset_postdata();
    }

    $categories=[];
    $default_image='https://via.placeholder.com/150?text=Category';
    $cats=get_terms(['taxonomy'=>'product_cat','hide_empty'=>false,'name__like'=>$keyword]);

    if(!is_wp_error($cats)){
        foreach($cats as $cat){
            $thumb_id=get_term_meta($cat->term_id,'thumbnail_id',true);
            $image=$thumb_id?wp_get_attachment_url($thumb_id):$default_image;
            $categories[]=['title'=>$cat->name,'url'=>get_term_link($cat),'image'=>$image];
        }
    }

    wp_send_json(['products'=>$products,'categories'=>$categories]);
}
