<?php


// اضافه کردن ستون
add_filter('manage_woocommerce_page_wc-orders_columns', function($columns){

    $new_columns = [];

    foreach ($columns as $key => $label) {
        $new_columns[$key] = $label;

        if ($key === 'order_total') {
            $new_columns['payment_info'] = 'شماره تراکنش';
        }
    }

    return $new_columns;
});


// نمایش مقدار ستون
add_action('manage_woocommerce_page_wc-orders_custom_column', function($column, $order){

    if ($column !== 'payment_info') {
        return;
    }

    $payment_method = $order->get_payment_method_title();
    $transaction_id = $order->get_transaction_id();

    if ($payment_method) {

        echo '<strong>' . esc_html($payment_method) . '</strong>';

        if ($transaction_id) {
            echo '<br><small style="color:#555;font-size:13px">'
                 . 'شماره تراکنش: ' . esc_html($transaction_id)
                 . '</small>';
        }

    } else {
        echo '-';
    }

}, 10, 2);
