<?php


add_action('init', 'my_register_custom_order_statuses');
function my_register_custom_order_statuses() {

    $custom_statuses = array(
        'wc--1' => 'ارجاع به کارشناس 1',
        'wc--2' => 'ارجاع به کارشناس 2',
        'wc--3' => 'ارجاع به کارشناس 3',
        'wc-5' => 'ارجاع به کارشناس 5',
        'wc--7' => 'انبار (در حال آماده سازی)',
        'wc-8' => 'ارسال شده (کدرهگیری بزودی وارد میشود)',
        'wc-9-' => 'کدرهگیری در پنل کاربری وارد شد',
        'wc-10-' => 'بصورت حضوری تحویل داده شد',
        'wc--11' => 'ارسال شد توسط پیک',
        'wc-12-' => 'عدم پاسخگویی تماس/سفارش معلق',
        'wc-13' => 'موجودی کامل نمی باشد',
        'wc-bzg' => 'عدم موجودی کالا و بازگشت وجه',
        'wc--cashback' => 'برگشت وجه با هماهنگی مشتری',
        'wc-cancelled' => 'سفارش شما لغو شد',
        'wc-sm' => 'ثبت مجدد سفارش',
        'wc-k4' => 'ارجاع به کارشناس 4',
        'wc-verified' => '✅ تایید سفارش و ارجاع به مالی',
        'wc-reviewing' => 'در حال بررسی',

    );

    foreach($custom_statuses as $slug => $label) {
        register_post_status($slug, array(
            'label'                     => $label,
            'public'                    => true,
            'exclude_from_search'       => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop( $label . ' <span class="count">(%s)</span>', $label . ' <span class="count">(%s)</span>' ),
        ));
    }

    register_post_status( 'wc-on-hold', array(
        'label'                     => 'در انتظار صدور فاکتور رسمی',
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop( 'در انتظار صدور فاکتور رسمی <span class="count">(%s)</span>', 'در انتظار صدور فاکتور رسمی <span class="count">(%s)</span>' ),
    ) );
}

add_filter('wc_order_statuses', 'my_add_custom_order_statuses_to_list');
function my_add_custom_order_statuses_to_list($order_statuses) {

    if ( isset( $order_statuses['wc-on-hold'] ) ) {
        $order_statuses['wc-on-hold'] = 'در انتظار صدور فاکتور رسمی';
    }

    $custom_statuses = array(
        'wc--1' => 'ارجاع به کارشناس 1',
        'wc--2' => 'ارجاع به کارشناس 2',
        'wc--3' => 'ارجاع به کارشناس 3',
        'wc-5' => 'ارجاع به کارشناس 5',
        'wc-reviewing' => 'در حال بررسی', 
        'wc--7' => 'انبار (در حال آماده سازی)',
        'wc-8' => 'ارسال شده (کدرهگیری بزودی وارد میشود)',
        'wc-9-' => 'کدرهگیری در پنل کاربری وارد شد',
        'wc-10-' => 'بصورت حضوری تحویل داده شد',
        'wc--11' => 'ارسال شد توسط پیک',
        'wc-12-' => 'عدم پاسخگویی تماس/سفارش معلق',
        'wc-13' => 'موجودی کامل نمی باشد',
        'wc-bzg' => 'عدم موجودی کالا و بازگشت وجه',
        'wc--cashback' => 'برگشت وجه با هماهنگی مشتری',
        'wc-cancelled' => 'سفارش شما لغو شد',
        'wc-sm' => 'ثبت مجدد سفارش',
        'wc-k4' => 'ارجاع به کارشناس 4',
        'wc-verified' => '✅ تایید سفارش و ارجاع به مالی',
    );

    return array_merge($order_statuses, $custom_statuses);
}


