jQuery(document).ready(function($) 
{
    const Select = $('#pa_translate_select').val();
    
	$( document ).on( 'click', '.select_media',  function(e1) 
	{
		var i = this;
        e1.stopImmediatePropagation();
        e1.preventDefault();
        var image = wp.media({
            title: 'Select Image',
            multiple: false
        }).open()
        .on('select', function(e){
            var uploaded_image = image.state().get('selection').first();
            var image_url = uploaded_image.toJSON().url;
            $(i).parent().find('.select_media_box').val( image_url );
        });
    
    });

	$(".pa_section tbody").sortable({
		cursor: 'row-resize',
		placeholder: 'ui-state-highlight',
		opacity: '0.55',
		items: '.ui-sortable-handle',
		update: function()
		{
			$('.pc_assemble_loader').fadeIn(100);
			var rows = [];

			$('.ui-sortable-handle').each(function(){
				rows.push( $(this).attr('data-id') );
			});

			$.ajax({
				url: pa.home+"/wp-json/pa/changeSectionOrder",
				beforeSend: function(xhr) {
					xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
				},
				method: "post",
				data: {
					newOrder: rows
				},
				success: function(data)
				{
					var z = 0;
					$('.ui-sortable-handle').each( function() {
						$(this).attr('data-id', data[z]);
						$(this).find('.pa_section_status').attr('data-id', data[z]);
						$(this).find('.section_delete').attr('href', "admin.php?page=pa-settings&tab=sections&action=delete&id="+data[z]);
						$(this).find('.id').val(data[z]);
						z++;
					});
					$('.pc_assemble_loader').fadeOut(100);
				},
				error(){}
			});
		}
	}).disableSelection();

	$(document).on('click', '.pc_assemble .nav-tab', function(){
		$('.pc_assemble_loader').fadeIn(100);
	})

	$("#pa_sections tbody td").each(function () {
		$(this).css("width", $(this).width());
	});

	$(".pa_category tbody").sortable({
		cursor: 'row-resize',
		placeholder: 'ui-state-highlight',
		opacity: '0.55',
		items: '.ui-sortable-handle',
		update: function()
		{
			$('.pc_assemble_loader').fadeIn(100);

			var rows = [];

			$('.ui-sortable-handle').each(function(){
				rows.push( $(this).attr('data-id') );
			});

			var section = $('#pa_current_section').val();

			$.ajax({
				url: pa.home+"/wp-json/pa/changeCategoryOrder",
				beforeSend: function(xhr) {
					xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
				},
				method: "post",
				data: {
					newOrder: rows
				},
				success: function(data)
				{
					var z = 0;
					$('.ui-sortable-handle').each( function() {
						$(this).attr('data-id', data[z]);
						$(this).find('.pa_category_status').attr('data-id', data[z]);
						$(this).find('.delete_category').attr('href', "admin.php?page=pa-settings&tab=categories&section="+section+"&action=delete&id="+data[z]);
						$(this).find('.id').val(data[z]);
						z++;
					});
					$('.pc_assemble_loader').fadeOut(100);
				},
				error(){}
			});
		}
	}).disableSelection();

	$(document).on('change', '.pa_section_status', function(){
		$('.pc_assemble_loader').fadeIn(100);
		var d = $(this);
		$.ajax({
			url: pa.home+"/wp-json/pa/changeSectionStatus",
			beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
            },
			method: "post",
			data: {
				id: $(this).attr('data-id'),
				status: $(this).is(':checked')
			},
			success: function(data)
			{
				d.parent().parent().parent().find('.status').val(data);
				$('.pc_assemble_loader').fadeOut(100);
			},
			error(){
				$('.pc_assemble_loader').fadeOut(100);
			}
		});
	});

	$(document).on('change', '.pa_relation_status', function()
	{
		$('.pc_assemble_loader').fadeIn(100);
		var d = $(this);
		$.ajax({
			url: pa.home+"/wp-json/pa/changeRelationStatus",
			beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
            },
			method: "post",
			data: {
				id: $(this).attr('data-id'),
				status: $(this).is(':checked')
			},
			success: function(data)
			{
				$('.pc_assemble_loader').fadeOut(100);
			},
			error(){
				$('.pc_assemble_loader').fadeOut(100);
			}
		});
	});

	$(document).on('change', '.pa_category_status', function()
	{
		$('.pc_assemble_loader').fadeIn(100);
		
		$.ajax({
			url: pa.home+"/wp-json/pa/changeCategoryStatus",
			beforeSend: function(xhr) {
				xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
			},
			method: "post",
			data: {
				id: $(this).attr('data-id'),
				status: $(this).is(':checked')
			},
			success: function(data) {
				$('.pc_assemble_loader').fadeOut(100);
			},
			error(){
				$('.pc_assemble_loader').fadeOut(100);
			}
		});
	});

	$(document).on('click', '.pa_tab_wrapper', function(e) 
	{
		if (e.target !== this)
			return;
		
		$('.pa_tab_wrapper').fadeOut(100);
		$('.pa_tab_wrapper form').trigger("reset");
		$('.pa_from_category, .pa_to_category, .pa_from_attribute, .pa_from_attribute_term, .pa_to_attribute, .pa_to_attribute_term, input[name=pa_add_relation], .pa_with_tag').fadeOut(100);
	});

	$(document).on('click', '.pa_go_categories, .emoji, .pa_return_back_a, .section_delete, .delete_category, .delete_relation', function(e) 
	{
		$('.pc_assemble_loader').fadeIn(100);
	});

	$(document).on('click', '.pa_add_section_btn', function(e) 
	{
		$('.pa_tab_wrapper').fadeIn(100);
		$('.pa_add_section_title').fadeIn(0);
		$('input[name=pa_section_title]').focus();

		$('#pa_section_mandatory').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});
	});

	$(document).on('change', '#pa_relation_type', function()
	{
        var selected = $(this).find(":selected").val();

		if ( selected == 'tag' )
		{
			$('.pa_from_attribute, .pa_from_attribute_term, .pa_to_attribute, .pa_to_attribute_term').fadeOut(100, function(){
				$('.pa_from_category, .pa_to_category, .pa_with_tag, input[name=pa_add_relation]').fadeIn(100);
			});
			$('#pa_from_attribute, #pa_from_attribute_term, #pa_to_attribute, #pa_to_attribute_term, input[name=pa_add_relation]').prop('required',false);
			$('#pa_from_category, #pa_to_category, #pa_with_tag, input[name=pa_add_relation]').prop('required',true);
		}
		else {
			$('.pa_with_tag').fadeOut(100, function(){
				$('.pa_from_category, .pa_to_category, .pa_from_attribute, .pa_from_attribute_term, .pa_to_attribute, .pa_to_attribute_term, input[name=pa_add_relation]').fadeIn(100);
			});

			$('#pa_with_tag, input[name=pa_add_relation]').prop('required',false);
			$('#pa_from_category, #pa_to_category, #pa_from_attribute, #pa_from_attribute_term, #pa_to_attribute, #pa_to_attribute_term, input[name=pa_add_relation]').prop('required',true);
		}

	});

	$(document).on('change', '#pa_from_attribute', function()
	{
		$('.pc_assemble_loader').fadeIn(100);

		$.ajax({
			url: pa.home+"/wp-json/pa/getAttributeTerms",
			beforeSend: function(xhr) {
				xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
			},
			method: "get",
			data: {
				attr: $(this).find(':selected').val()
			},
			success: function(data) 
			{
				$('.pc_assemble_loader').fadeOut(100);

				var option = '<option value=""></option>';
				data.forEach( e => {
					option += '<option value="'+e.term_id+'">'+e.name+'</option>';
				} );

				$('#pa_from_attribute_term').html( option );
				$('#pa_from_attribute_term').select2({
					dropdownParent: $('.pa_tab'),
					placeholder: Select
				});
			},
			error(){
				
			}
		});
	});

	$(document).on('change', '#pa_to_attribute', function()
	{
		$('.pc_assemble_loader').fadeIn(100);

		$.ajax({
			url: pa.home+"/wp-json/pa/getAttributeTerms",
			beforeSend: function(xhr) {
				xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
			},
			method: "get",
			data: {
				attr: $(this).find(':selected').val()
			},
			success: function(data) 
			{
				$('.pc_assemble_loader').fadeOut(100);

				var option = '<option value=""></option>';
				data.forEach( e => {
					option += '<option value="'+e.term_id+'">'+e.name+'</option>';
				} );

				$('#pa_to_attribute_term').html( option );
				$('#pa_to_attribute_term').select2({
					dropdownParent: $('.pa_tab'),
					placeholder: Select
				});
			},
			error(){
				
			}
		});
	});

	$(document).on('click', '.pa_add_relation_btn', function(e) 
	{
		$('.pa_tab_wrapper').fadeIn(100);
		$('.pa_edit_relation_title').fadeOut(0);
		$('.pa_add_relation_title').fadeIn(0);
		$('input[name=pa_relation_id]').val('');

		$('#pa_from_category').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_relation_type').select2({
			dropdownParent: $('.pa_tab'),
			minimumResultsForSearch: -1,
			placeholder: Select
		});

		$('#pa_to_category').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_with_tag').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_from_attribute').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_from_attribute_term').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_to_attribute').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_to_attribute_term').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});
	});

	$(document).on('click', '.pa_close_section_modal', function(e) 
	{
		$('input[name=pa_section_title]').val('');
		$('input[name=pa_section_id]').val('');
		$('.pa_tab_wrapper').fadeOut(100);
	});

	$(document).on('click', '.pa_close_category_modal', function(e) 
	{
		$('input[name=pa_category_title]').val('');
		$('select[name=pa_category_order]').val('');
		$('select[name=pa_category_display]').val('');
		$('select[name=pa_category]').val('');
		$('.pa_tab_wrapper').fadeOut(100);
		$('.pa_edit_category_title').fadeOut(100);
	});

	$(document).on('click', '.pa_close_relation_modal', function()
	{
		$('.pa_tab_wrapper form').trigger("reset");
		$('.pa_from_category, .pa_to_category, .pa_from_attribute, .pa_from_attribute_term, .pa_to_attribute, .pa_to_attribute_term, input[name=pa_add_relation], .pa_with_tag').fadeOut(100);
	})

	$(document).submit('#add_section_form', function(e) 
	{
		$('.pa_tab_wrapper').fadeOut(300);
		$('.pc_assemble_loader').fadeIn(100);
	});

	$(document).submit('#add_category_form', function(e) 
	{
		$('.pa_tab_wrapper').fadeOut(300);
		$('.pc_assemble_loader').fadeIn(100);
	});

	$(document).on('click', '.pa_edit_section_btn', function(e) 
	{	
		$('.pa_add_section_title').fadeOut(0);
		$('input[name=pa_section_title]').val( $(this).parent().find('.name').val() );
		$('input[name=pa_section_id]').val( $(this).parent().find('.id').val() );
		$('.pa_tab_wrapper').fadeIn(100);
		$('.pa_edit_section_title').fadeIn(0);
		$('input[name=pa_section_title]').focus();

		$('select[name=pa_section_mandatory]').val( $(this).parent().find('.mandatory').val() );

		$('#pa_section_mandatory').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});
	});

	$(document).on('click', '.pa_edit_category_btn', function(e) 
	{	
		$('.pa_add_category_title').fadeOut(0);
		$('.pa_edit_category_title').fadeIn(0);
		$('input[name=pa_category_title]').val( $(this).parent().find('.name').val() );

		var order = $(this).parent().find('.pa_order').val();
		order = order == '' ? 0 : order;

		$('select[name=pa_category_order]').val( order );

		var display = $(this).parent().find('.display').val();
		display = display == '' ? 0 : display;

		$('select[name=pa_category_display]').val( display );

		$('select[name=pa_category_select]').val( $(this).parent().find('.pa_select').val() );
		$('select[name=pa_category]').val( $(this).parent().find('.category').val() );
		$('input[name=pa_category_id]').val( $(this).parent().find('.id').val() );
		$('select[name=pa_category_stock_limit]').val( $(this).parent().find('.stock_limit').val() );
		$('select[name=pa_category_mandatory]').val( $(this).parent().find('.mandatory').val() );
		$('.pa_tab_wrapper').fadeIn(100);
		category_select2();
	});

	$(document).on('click', '.pa_add_category_btn', function(e) 
	{
		$('.pa_tab_wrapper').fadeIn(100, function(){
			category_select2();
		});
		$('#pa_category_title').focus();
		$('.pa_edit_category_title').fadeOut(0);
		$('.pa_add_category_title').fadeIn(0);
		$('#pa_category').val('');
		$('#add_category_form').trigger("reset");
		
	});

	function category_select2()
	{
		$('#pa_category').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_category_display').select2({
			dropdownParent: $('.pa_tab'),
			minimumResultsForSearch: -1,
			placeholder: Select
		});

		$('#pa_category_order').select2({
			dropdownParent: $('.pa_tab'),
			minimumResultsForSearch: -1,
			placeholder: Select
		});

		$('#pa_category_select').select2({
			dropdownParent: $('.pa_tab'),
			minimumResultsForSearch: -1,
			placeholder: Select
		});

		$('#pa_category_stock_limit').select2({
			dropdownParent: $('.pa_tab'),
			minimumResultsForSearch: -1,
			placeholder: Select
		});

		$('#pa_category_mandatory').select2({
			dropdownParent: $('.pa_tab'),
			minimumResultsForSearch: -1,
			placeholder: Select
		});
	}

	$(document).on('click', '.pa_go_categories, .pa_go_cat', function()
	{
		const id = $(this).parent().find('.id').val();
		window.location.href = pa.admin + 'admin.php?page=pa-settings&tab=categories&section='+id;
	});

	$(document).on('click', '.pa_edit_relation_btn', function(e) 
	{	
		$('#pc_assemble_loader').fadeIn(100);

		$('.pa_tab_wrapper').fadeIn(100);
		$('.pa_edit_relation_title').fadeIn(0);
		$('.pa_add_relation_title').fadeOut(0);
		$('input[name=pa_relation_id]').val($(this).attr('data-id'));

		if ( $(this).attr('data-type') == 'tag' )
		{
			$('.pa_from_attribute, .pa_from_attribute_term, .pa_to_attribute, .pa_to_attribute_term').fadeOut(100);
			$('.pa_from_category, .pa_to_category, .pa_with_tag, input[name=pa_add_relation]').fadeIn(100);
		}
		else 
		{
			$('.pa_from_category, .pa_to_category, .pa_from_attribute, .pa_from_attribute_term, .pa_to_attribute, .pa_to_attribute_term, input[name=pa_add_relation]').fadeIn(100);
			$('.pa_with_tag').fadeOut(100);

			var i = this;


			$.ajax({
				url: pa.home+"/wp-json/pa/getAttributeTerms",
				beforeSend: function(xhr) {
					xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
				},
				method: "get",
				data: {
					attr: $(this).parent().find('.from_attr').val()
				},
				success: function(data) 
				{
					var options = '<option></option>';
					data.forEach( e => {
						options += '<option value="'+e.term_id+'">'+e.name+'</option>';
					});
					$('#pa_from_attribute_term').html(options);
					$('#pa_from_attribute_term').val( $(i).parent().find('.from_attr_term').val() );
				},
				error(){
					
				}
			});

			$.ajax({
				url: pa.home+"/wp-json/pa/getAttributeTerms",
				beforeSend: function(xhr) {
					xhr.setRequestHeader('X-WP-Nonce', pa.nonce);
				},
				method: "get",
				data: {
					attr: $(this).parent().find('.to_attr').val(),
				},
				success: function(data) 
				{
					var options = '<option></option>';
					data.forEach( e => {
						options += '<option value="'+e.term_id+'">'+e.name+'</option>';
					});
					$('#pa_to_attribute_term').html(options);
					$('#pa_to_attribute_term').val( $(i).parent().find('.to_attr_term').val() );
				},
				error(){
					
				}
			});
		}

		$('select[name=pa_from_category]').val( $(this).parent().find('.from').val() );
		$('select[name=pa_to_category]').val( $(this).parent().find('.to').val() );
		$('select[name=pa_with_tag]').val( $(this).parent().find('.tag').val() );

		$('select[name=pa_relation_type]').val( $(this).parent().find('.type').val() );

		$('select[name=pa_from_attribute]').val( $(this).parent().find('.from_attr').val() );
		$('select[name=pa_to_attribute]').val( $(this).parent().find('.to_attr').val() );

		run_relation_select2();

		$('#pc_assemble_loader').fadeOut();
	});

	function run_relation_select2 ()
	{
		$('#pa_relation_type').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_from_category').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_to_category').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_with_tag').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_from_attribute').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_from_attribute_term').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_to_attribute').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});

		$('#pa_to_attribute_term').select2({
			dropdownParent: $('.pa_tab'),
			placeholder: Select
		});
	}


    $( document ).on('click', '.pa_add_selected_item', function()
	{

		var select_type = $(this).parent().parent().find('.pa_component_select_type').val();

		var current = $(this).parent().parent().find('.pa-selected-item').length;

		if ( select_type == 'single' && current > 1 ) 
		{
			alert(pa.error_one_select_limit);
			return;
		}

		var content = $(this).parent().find('.pa_selected_items_clone').clone();

		$(this).parent().parent().find('.pa_in_component_val').append(content);

		$('.pa_in_component select').select2();

		$('.pa_in_component_val .pa-selected-item>span:nth-child(3)').remove();
	});

	$('select[name=pa_main_product]').select2({
		placeholder: Select
	});

	$('select[name=pa_product_display]').select2({
		minimumResultsForSearch: -1
	});

	$('select[name=pa_product_display_order]').select2({
		minimumResultsForSearch: -1
	});

	$('#pa_excluded_category').select2({
		minimumResultsForSearch: -1
	});

	$('select[name=pa_display_mode]').select2({
		minimumResultsForSearch: -1
	});

	$(document).on('click', '.pa_design_tabs a', function()
	{
		$('.pa_design_tabs a').removeClass('active');
		$(this).addClass('active');
		var href = $(this).attr('href');
		href = href.substring(1);
		$('.pa_design tr').removeClass('active');
		$('.pa_design tr.'+href).addClass('active');
		$('.submit_tr').addClass('active');
	})

	$(document).on('click', '.remove_selected_item_star', function()
	{
		$(this).parent().remove();
	});
});
