<?php
class PC_Assemble_Post_Types extends PC_Assemble_Admin
{
	public function __construct ()
	{
		$this->init();
	}

	public function init ()
	{
		add_action( 'add_meta_boxes', [$this, 'pc_assemble_add_meta_boxes'] );
		add_action( 'save_post_pcassemble', [$this, 'pc_assemble_save_post_pcassemble'] );
		add_filter( 'post_row_actions', [$this, 'pc_assemble_post_row_actions'] , 10, 2 );
	}
	
	public function pc_assemble_post_row_actions ( $actions, $post )
	{
	    if ( $post->post_type == 'pcassemble' )
        {
            unset($actions['inline hide-if-no-js']);
        }
        
        return $actions;
	}

	public function pc_assemble_add_meta_boxes ()
	{
		global $pagenow;
		global $post;

		remove_meta_box('postcustom', 'pcassemble', 'normal');
		
		add_meta_box( 
			'pa-suggested-assembly', 
			__('Pc Assemble plugin', 'assemble'), 
			[$this, 'pc_assemble_metabox'], 
			'pcassemble', 
			'advanced', 
			'high'
		);
	}

	public function pc_assemble_metabox ()
	{
		$sections = $this->pc_assemble_get_sections();

		require dirname(__FILE__) . '/templates/suggested-assemble-metabox.php';
	}

	private function pc_assemble_get_sections()
	{
		$table   = parent::$sections_table;
		$results = parent::$wpdb->get_results("select * from {$table} where status='1' order by id asc");

		foreach( $results as $key=>&$section )
		{
			if( $section->parent == 0 ) 
			{
				$categories = [];

				foreach ( $results as $k => $section2 ) 
				{
					if( $section2->parent == $section->id ) 
					{
						$categories[] = $section2;
					}
				}
				$section->categories = $categories;
			}
		}

		return array_filter($results, function ($element) {
			return $element->parent == 0;
		});
	}

	private function pc_assemble_get_categories ()
	{
		$table = parent::$wpdb->prefix . 'pa_sections';
		$results = parent::$wpdb->get_results("select * from {$table} where status='1' order by id");

		$categories = [];
		$parent = [];

		foreach( $results as $item ) 
		{
				if ( $item->parent != 0 )
					$categories[] = $item->category;
				else
					$parent[] = $item->id;
		}

		return [$categories, $parent];
	}

	public function pc_assemble_save_post_pcassemble( $post_id )
	{
		$get = $this->pc_assemble_get_categories();
		$categories = $get[0];
		$parent = $get[1];

		// sended display items
		$display = isset( $_POST['pa_display'] ) ? $_POST['pa_display'] : [];
		foreach( $categories as $category )
		{
			if( isset( $display[$category] ) )
			{
				update_post_meta($post_id, 'pa_display_'.$category, $display[$category]);
			}
			else
			{
				delete_post_meta($post_id, 'pa_display_'.$category);
			}
				
		}

		// selected items
		$selected = isset( $_POST['pa_selected'] ) ? $_POST['pa_selected'] : [];
		foreach( $categories as $category )
		{
			if( isset( $selected[$category] ) )
			{
				update_post_meta($post_id, 'pa_selected_'.$category, $selected[$category]);
			}
			else
			{
				delete_post_meta($post_id, 'pa_selected_'.$category);
			}
				
		}

		// order items
		foreach( $categories as $category )
		{
			if( isset( $_POST['pa_display_order_'.$category] ) )
			{
				update_post_meta($post_id, 'pa_display_order_'.$category, 1);
			}	
			else
			{
				delete_post_meta($post_id, 'pa_display_order_'.$category);
			}
				
		}

		// Display category
		foreach( $categories as $category )
		{
			if( isset( $_POST['pa_category_status_'.$category] ) )
			{
				update_post_meta($post_id, 'pa_category_status_'.$category, 1);
			}
			else
			{
				update_post_meta($post_id, 'pa_category_status_'.$category, 0);
			}
				
		}

		// Display section
		foreach( $parent as $section )
		{
			if( isset( $_POST['pa_section_status_'.$section] ) )
			{
				update_post_meta($post_id, 'pa_section_status_'.$section, 1);
			}
			else
			{
				update_post_meta($post_id, 'pa_section_status_'.$section, 0);
			}
				
		}

		//Selected products
		foreach ( $categories as $category )
		{
			$meta = [];
			if ( isset( $_POST['pa_selected_proudct'] ) ) :
				foreach ( $_POST['pa_selected_proudct'][$category] as $key=>$product ) 
				{
					if ( $_POST['pa_selected_proudct'][$category][$key] == '' || $_POST['pa_selected_quantity'][$category][$key] == '' ) continue;

					$meta[] = [
						'product_id'	=> $_POST['pa_selected_proudct'][$category][$key],
						'quantity'		=> $_POST['pa_selected_quantity'][$category][$key]
					];
				}
			endif;

			$meta = empty($meta) ? '' : $meta;

			update_post_meta( $post_id, 'pa_selected_products_'.$category, $meta );
		}
	}
}

new PC_Assemble_Post_Types();