<?php
defined('ABSPATH') || die;

class PC_Assemble_Settings extends PC_Assemble_Admin
{
	private $tabs;

	public function __construct()
	{
		$this->includes();
	}

	protected function includes ()
	{
		$this->pc_assemble_template_loader( '/settings/header.php' );

		$tab = isset( $_GET['tab'] ) ? sanitize_text_field( $_GET['tab'] ) : 'general';
		$this->pc_assemble_template_loader( '/settings/class-pa-'.$tab.'.php' );

		$this->pc_assemble_template_loader( '/settings/footer.php' );
	}

	protected function pc_assemble_template_loader ( $path )
	{
		include_once( PA_ADMIN_PARTIALS . $path );
	}

	protected function pc_assemble_save_settings( $args )
	{
		if ( ! isset( $_POST['pa_nonce'] ) || ! wp_verify_nonce( $_POST['pa_nonce'], 'pa-nonce' ) ) 
		{
			return;
		}

        foreach( $args as $value )
        {
			if ( $value == 'pa_excluded_category' ) 
			{
				$val = !isset( $_POST[$value] ) || $_POST[$value] == '' ? [] : $_POST[$value];
				
				update_option( $value, $val );
			}
			else if ( $value == '_pa_design_settings' )
			{
				update_option( $value, $_POST[$value] );
			}
			else 
			{
				$output = isset( $_POST[$value] ) ? wp_kses_post( $_POST[$value] ) : '0';

				update_option( $value, $output );
			}
            
        }
	}
}

new PC_Assemble_Settings();