<?php
defined('ABSPATH') || die;

class PC_Assemble_Settings_Relations extends PC_Assemble_Settings
{
	protected $relations;

	function __construct()
	{
		$this->pc_assemble_controller();
		
		$this->pc_assemble_template_loader( '/settings/templates/relations.php' );
	}

	private function pc_assemble_controller ()
	{
		if ( isset( $_POST['pa_add_relation'] ) ) 
		{
			$this->pc_assemble_add_relation();
		}

		if ( isset( $_GET['action'] ) && $_GET['action'] == 'delete' )
		{ 
			$this->pc_assemble_delete_relation(); 
		}

		$this->relations = $this->pc_assemble_get_relations();
	}

	private function pc_assemble_return_term_name ( $term_id )
	{
		$term = get_term( $term_id );
		return $term->name;
	}

	private function pc_assemble_add_relation ()
	{
		if( $_POST['pa_relation_id'] == '' ) 
		{
			if ( $_POST['pa_relation_type'] == 'tag' ) 
			{
				parent::$wpdb->insert(parent::$relations_table, [
					'pa_type' 	=> 'tag',
					'pa_from' 	=> sanitize_text_field( $_POST['pa_from_category'] ),
					'pa_to' 	=> sanitize_text_field( $_POST['pa_to_category'] ),
					'pa_tag' 	=> sanitize_text_field( $_POST['pa_with_tag'] )
				]);
			}
			else {
				parent::$wpdb->insert(parent::$relations_table, [
					'pa_type' 			=> 'attribute',
					'pa_from' 			=> sanitize_text_field( $_POST['pa_from_category'] ),
					'pa_from_attr' 		=> sanitize_text_field( $_POST['pa_from_attribute'] ),
					'pa_from_attr_value' => sanitize_text_field( $_POST['pa_from_attribute_term'] ),
					'pa_to' 			=> sanitize_text_field( $_POST['pa_to_category'] ),
					'pa_to_attr' 		=> sanitize_text_field( $_POST['pa_to_attribute'] ),
					'pa_to_attr_value' 	=> sanitize_text_field( $_POST['pa_to_attribute_term'] )
				]);
			}
			
		}
		else 
		{
			
			if ( $_POST['pa_relation_type'] == 'tag' ) 
			{
				parent::$wpdb->update(parent::$relations_table, [
					'pa_from' 	=> sanitize_text_field( $_POST['pa_from_category'] ),
					'pa_to' 	=> sanitize_text_field( $_POST['pa_to_category'] ),
					'pa_tag' 	=> sanitize_text_field( $_POST['pa_with_tag'] )
				], [
					'id' => sanitize_text_field( $_POST['pa_relation_id'] )
				]
				);
			}
			else 
			{
				parent::$wpdb->update(parent::$relations_table, [
					'pa_from' 			=> sanitize_text_field( $_POST['pa_from_category'] ),
					'pa_from_attr' 		=> sanitize_text_field( $_POST['pa_from_attribute'] ),
					'pa_from_attr_value' => sanitize_text_field( $_POST['pa_from_attribute_term'] ),
					'pa_to' 			=> sanitize_text_field( $_POST['pa_to_category'] ),
					'pa_to_attr' 		=> sanitize_text_field( $_POST['pa_to_attribute'] ),
					'pa_to_attr_value' 	=> sanitize_text_field( $_POST['pa_to_attribute_term'] )
				], [
					'id' => sanitize_text_field( $_POST['pa_relation_id'] )
				]
				);
			}
			


		}
	}

	private function pc_assemble_get_relations()
	{
		$table = parent::$relations_table;
		$results = parent::$wpdb->get_results("select * from {$table} order by id");
		
		$output = '';
		foreach( $results as $item ) 
		{
			$type = $item->pa_type == 'tag' ? __('Tag', 'assemble') : __('Attribute', 'assemble');

			$fa_name = '---';
			$ta_name = '---';
			$tag = '---';

			if ( $item->pa_type == 'attribute' ) 
			{
				$fa_tax = wc_get_attribute( $item->pa_from_attr );
				$fa = get_term_by('id', $item->pa_from_attr_value, $fa_tax->slug);
				$fa_name = $fa->name;
				$fa_tax_title = $fa_tax->name;

				$fa_name = $fa_tax->name . ' - ' . $fa_name;

				$ta_tax = wc_get_attribute( $item->pa_to_attr );
				$ta = get_term_by('id', $item->pa_to_attr_value, $ta_tax->slug);
				$ta_name = $ta->name;
				$ta_tax_title = $ta_tax->name;

				$ta_name = $ta_tax->name . ' - ' . $ta_name;
			}

			if ( $item->pa_type == 'tag' ) 
			{
				$tag = $this->pc_assemble_return_term_name($item->pa_tag);
			}

			$output .= '<tr>';
				$output .= '<td>'.esc_html($type).'</td>';
				$output .= '<td>'.esc_html($this->pc_assemble_return_term_name($item->pa_from)).'</td>';
				$output .= '<td>'.esc_html($fa_name).'</td>';
				$output .= '<td>'.esc_html($this->pc_assemble_return_term_name($item->pa_to)).'</td>';
				$output .= '<td>'.esc_html($ta_name).'</td>';
				$output .= '<td>'.esc_html($tag).'</td>';
				$output .= '<td class="text-center">';
					$sure = __("Do you sure?", "assemble");
					$output .= '<a class="delete_relation" href="admin.php?page=pa-settings&tab=relations&action=delete&id='.esc_attr($item->id).'"><span class="dashicons dashicons-trash"></span></a> &nbsp; <span data-id="'.esc_attr($item->id).'" data-type="'.esc_attr($item->pa_type).'" class="dashicons dashicons-edit pa_edit_relation_btn"></span>';
					$output .= '<input type="hidden" class="from" value="'.esc_attr($item->pa_from).'" />';
					$output .= '<input type="hidden" class="type" value="'.esc_attr($item->pa_type).'" />';
					$output .= '<input type="hidden" class="from_attr" value="'.esc_attr($item->pa_from_attr).'" />';
					$output .= '<input type="hidden" class="from_attr_term" value="'.esc_attr($item->pa_from_attr_value).'" />';
					$output .= '<input type="hidden" class="to" value="'.esc_attr($item->pa_to).'" />';
					$output .= '<input type="hidden" class="to_attr" value="'.esc_attr($item->pa_to_attr).'" />';
					$output .= '<input type="hidden" class="to_attr_term" value="'.esc_attr($item->pa_to_attr_value).'" />';
					$output .= '<input type="hidden" class="tag" value="'.esc_attr($item->pa_tag).'" />';
					$output .= '<input type="hidden" class="status" value="'.esc_attr($item->status).'" /></td>';
				$output .= '<td class="text-center"><label class="switch">';
				$checked = $item->status == 1 ? 'checked="checked"' : '';
				$output .= '<input class="pa_relation_status" value="1" type="checkbox" data-id="'.esc_attr($item->id).'" '.$checked.' />';
				$output .= '<span class="slider round"></span></label></td>';
			$output .= '</tr>';
		}

		return $output;
	}

	private function pc_assemble_delete_relation()
	{
		parent::$wpdb->delete( parent::$relations_table, [ 'id' => sanitize_text_field( $_GET['id'] ) ] );

		wp_redirect(admin_url() . 'admin.php?page=pa-settings&tab=relations');
		exit;
	}
}

new PC_Assemble_Settings_Relations();
