<?php 
class PC_Assemble_Settings_Sections extends PC_Assemble_Settings
{
	protected $sections;

	function __construct()
	{
		$this->pc_assemble_controller();
		
		$this->pc_assemble_template_loader( '/settings/templates/sections.php' );
	}

	private function pc_assemble_controller()
	{
		if ( isset( $_GET['action'] ) && 'delete' == $_GET['action'] )
		{ 
			$this->pc_assemble_delete_section();
		}

		if ( isset( $_POST['pa_add_section'] ) ) 
		{
			$this->pc_assemble_add_section();
		}

		$this->sections = $this->pc_assemble_get_sections();
	}

	private function pc_assemble_get_sections()
	{
		$table   = parent::$sections_table;
		$results = parent::$wpdb->get_results("select * from {$table} order by id");

		foreach ( $results as $key => &$section )
		{
			if ( 0 == $section->parent ) 
			{
				$categories = '';

				foreach ( $results as $k => $section2 ) 
				{
					if( $section2->parent == $section->id ) 
					{
						$categories .= $section2->name . ', ';
					}
				}
				$section->categories = rtrim($categories, ', ');
			}
		}

		return array_filter($results, function ($element) {
			return $element->parent == 0;
		});
	}

	private function pc_assemble_add_section()
	{
		if( $_POST['pa_section_id'] == '' ) 
		{
			parent::$wpdb->insert( parent::$sections_table, [
				'name' 		=> sanitize_text_field( $_POST['pa_section_title'] ),
				'mandatory' => sanitize_text_field( $_POST['pa_section_mandatory'] )
			]);
		}
		else {
			parent::$wpdb->update( parent::$sections_table, [
				'name' 		=> sanitize_text_field( $_POST['pa_section_title'] ),
				'mandatory' => sanitize_text_field( $_POST['pa_section_mandatory'] )
			], [
				'id' 		=> sanitize_text_field( $_POST['pa_section_id'] )
			]
			);
		}
	}

	private function pc_assemble_delete_section()
	{
		$table = parent::$sections_table;
		parent::$wpdb->delete($table, [ 'id'  => sanitize_text_field( $_GET['id'] ) ]);
		parent::$wpdb->delete($table, [ 'parent' => sanitize_text_field( $_GET['id'] ) ]);

		wp_redirect(admin_url() . 'admin.php?page=pa-settings&tab=sections');
		exit;
	}
}

new PC_Assemble_Settings_Sections();