<?php 
$options = $this->current_options; 
$page = isset($_GET['tab']) ? sanitize_text_field( $_GET['tab'] ) : 'pa_general';
?>

<form method="post" action="" class="<?php echo 'pa_'.esc_attr($page); ?>">

<input type="hidden" name="pa_nonce" value="<?php echo esc_attr( wp_create_nonce('pa-nonce') ); ?>" />

<table class="form-table">
	<tbody>

	<tr class="pa_general">
		<th><?php esc_html_e('Main Product', 'assemble'); ?></th>
		<td>
			<select name="pa_main_product">
				<option value=""></option>
				<?php
				global $wpdb;
				$table = $wpdb->prefix . 'posts';
                $results = $wpdb->get_results( "select * from $table where post_status='publish' and post_name='pc-assemble-pro-main-product'");
                foreach( $results as $post )
				{
					?>
					<option <?php selected($options['pa_main_product'], $post->ID) ?> value="<?php echo esc_attr($post->ID); ?>"><?php echo esc_html($post->post_title); ?></option>
					<?php
				}
				?>
			</select>
			<p><?php esc_html_e("PC Assemble Pro plugin requires a woocommerce product to place assemble orders. This product is made and considered in plugin activation. The price of this product is zero and it is a hidden product. if product not exists, unactivate plugin then activate.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr class="pa_general">
		<th><?php esc_html_e('Display Mode', 'assemble'); ?></th>
		<td>
			<select name="pa_display_mode">
				<option <?php selected($options['pa_display_mode'], 'multi-tab'); ?> value="multi-tab"><?php esc_html_e('Multi Tab', 'assemble'); ?></option>
				<option <?php selected($options['pa_display_mode'], 'one-column'); ?> value="one-column"><?php esc_html_e('One Column', 'assemble'); ?></option>
			</select>
			<p><?php esc_html_e("You specify the display mode for the user. Multi-tab mode means to display a set of specific categories in the specified tab. One column mode means that the selected categories are displayed below. Staged mode means that a set of categories is assigned to each stage.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr class="pa_general">
		<th><?php esc_html_e('Products Display', 'assemble'); ?></th>
		<td>
			<select name="pa_product_display">
				<option <?php selected($options['pa_product_display'], 'all'); ?> value="all"><?php esc_html_e('All Products', 'assemble'); ?></option>
				<option <?php selected($options['pa_product_display'], 'available'); ?> value="available"><?php esc_html_e('Available Products', 'assemble'); ?></option>
			</select>
			<p><?php esc_html_e("You specify which products to display. ", 'assemble'); ?></p>
		</td>
	</tr>

	<tr class="pa_general">
		<th><?php esc_html_e('Products Display Order', 'assemble'); ?></th>
		<td>
			<select name="pa_product_display_order">
				<option <?php selected($options['pa_product_display_order'], 'asc-date'); ?> value="asc-date"><?php esc_html_e('Ascending Date', 'assemble'); ?></option>
				<option <?php selected($options['pa_product_display_order'], 'desc-date'); ?> value="desc-date"><?php esc_html_e('Descending Date', 'assemble'); ?></option>
				<option <?php selected($options['pa_product_display_order'], 'asc-price'); ?> value="asc-price"><?php esc_html_e('Ascending Price', 'assemble'); ?></option>
				<option <?php selected($options['pa_product_display_order'], 'desc-price'); ?> value="desc-price"><?php esc_html_e('Descending Price', 'assemble'); ?></option>
				<option <?php selected($options['pa_product_display_order'], 'top-sale'); ?> value="top-sale"><?php esc_html_e('Top Sale', 'assemble'); ?></option>
			</select>
			<p><?php esc_html_e("Products are displayed to the user accordingly. ", 'assemble'); ?></p>
		</td>
	</tr>

	<tr class="pa_general">
		<th><?php esc_html_e('Excluded Category From Display', 'assemble'); ?></th>
		<td>
			<select name="pa_excluded_category[]" id="pa_excluded_category" multiple="multiple">
				<?php
				$meta = unserialize( $options['pa_excluded_category'] );
				foreach( get_terms( 'product_cat', array( 'hide_empty' => false ) ) as $key=>$term )
				{
					$selected = is_array($meta) && in_array( $term->slug, $meta ) ? 'selected="selected"' : '';
					echo '<option '.esc_attr($selected).' value="'.esc_attr($term->slug).'">'.esc_attr($term->name).'</option>';
				}
				?>
			</select>
			<p><?php esc_html_e("Select the categories that you have considered for the service tab and have a price of zero tomans from this section so that they are not displayed on the store and archive pages.", 'assemble'); ?></p>
		</td>
	</tr>
	
	<tr>
		<th class="swtich-th"><?php esc_html_e('Display Private Products', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_private_products_display" id="pa_private_products_display" type="checkbox" <?php checked( esc_attr($options['pa_private_products_display']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("Display private products in assemble page", 'assemble'); ?></p>
		</td>
	</tr>

	<tr>
		<th class="swtich-th"><?php esc_html_e('Enable Header In Assemble Page', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_display_header" id="pa_display_header" type="checkbox" <?php checked( esc_attr($options['pa_display_header']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("It displays the site header on the computer screen. When you enable the header. The styles and scripts of your template and plugins may affect the page.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr>
		<th class="swtich-th"><?php esc_html_e('Enable Footer In System Page', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_display_footer" id="pa_display_footer" type="checkbox" <?php checked( esc_attr($options['pa_display_footer']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("It displays the site footer on the computer screen. When you enable the footer. The scripts of your template and plugins may affect the page.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr>
		<th class="swtich-th"><?php esc_html_e('Share Button', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_share_button" id="pa_share_button" type="checkbox" <?php checked( esc_attr($options['pa_share_button']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("Display Share button in assemble page", 'assemble'); ?></p>
		</td>
	</tr>

	<!--<tr>
		<th class="swtich-th"><?php //esc_html_e('Email Button', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_email_button" id="pa_email_button" type="checkbox" <?php //checked( esc_attr($options['pa_email_button']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php //esc_html_e("Display Email button in assemble page", 'assemble'); ?></p>
		</td>
	</tr>-->

	<tr>
		<th class="swtich-th"><?php esc_html_e('Print Button', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_print_button" id="pa_print_button" type="checkbox" <?php checked( esc_attr($options['pa_print_button']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("Display Print button in assemble page", 'assemble'); ?></p>
		</td>
	</tr>

	<tr>
		<th class="swtich-th"><?php esc_html_e('Save Assemble On Print', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_save_on_print" id="pa_save_on_print" type="checkbox" <?php checked( esc_attr($options['pa_save_on_print']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("When the print button is pressed, the assembly is saved and its link is placed in the print output.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr>
		<th class="swtich-th"><?php esc_html_e('Save Assemble After Add To Cart', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_save_after_add_to_cart" id="pa_save_after_add_to_cart" type="checkbox" <?php checked( esc_attr($options['pa_save_after_add_to_cart']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("When the assembly is added to the work, it is saved and its link is recorded in the order. On the card page, the customer can use this link to edit his assembly.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr>
		<th class="swtich-th"><?php esc_html_e('Changing The Main Image When The Case Item Is Selected', 'assemble'); ?></th>
		<td>
			<label class="switch">
				<input name="pa_change_main_img_with_case_selected" id="pa_change_main_img_with_case_selected" type="checkbox" <?php checked( esc_attr($options['pa_change_main_img_with_case_selected']), 1); ?> value="1">
				<span class="slider round"></span>
			</label>
			<p><?php esc_html_e("When a case is selected, the image of that case will be replaced with the main image of the assembly.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr class="pa_general">
		<th><?php esc_html_e('Case Category', 'assemble'); ?></th>
		<td>
			<select name="pa_case_category" id="pa_case_category">
				<?php
				foreach( get_terms( 'product_cat', array( 'hide_empty' => false ) ) as $key=>$term )
				{
					$selected = $options['pa_case_category'] == $term->term_id ? 'selected="selected"' : '';
					echo '<option '.esc_attr($selected).' value="'.esc_attr($term->term_id).'">'.esc_attr($term->name).'</option>';
				}
				?>
			</select>
			<p><?php esc_html_e("To change the main image with the selected case image, you need to specify which category of your site is related to the case. This setting is related to the setting above.", 'assemble'); ?></p>
		</td>
	</tr>

	<tr>
		<th><?php submit_button('', 'primary', 'pa_submit'); ?></th>
		<td></td>
	</tr>

	</tbody>
		</table>
	</form>
</div>