<div id="pa_assemble">

	<?php 
	global $pagenow;
	$id = $pagenow == 'post-new.php' ? 0 : get_the_id();
	echo '<ul class="pa_admin_product_tabs">';

	$n = 0;
	foreach($sections as $key=>$section) 
	{
		$active = $n==0 ? 'active' : '';
		echo '<li data-id="'.esc_attr($section->id).'" class="'.esc_attr($active).'">'.esc_html($section->name).'</li>';
		$n++;
	}
	echo '</ul>';

	function pa_final_object($meta, $products)
	{
		$output = [];
		$output_ids = [];

		if( is_array($meta) ) 
		{
			foreach ( $meta as $item ) 
			{
				foreach ( $products as $product ) 
				{
					if ( $product->ID == $item ) 
					{
						$output[] = $product;
						$output_ids[] = $product->ID;
					}
				}
			}
		}


		$end = array_filter( $products, function ($var) use ($output_ids) {
			return ( ! in_array( $var->ID, (array) $output_ids ) );
		});

		return array_merge($output, $end);
	}

	$i = 0;
	foreach($sections as $key=>$section) 
	{
		$active = $i==0 ? 'active' : '';

			echo '<div data-id="'.esc_attr($section->id).'" class="'.esc_attr($active).' section_'.esc_attr($section->id).' pa_section_status_in"> <span>'.esc_html__("Section status", "assemble").'</span>'; 
			
			$status = get_post_meta( $id, 'pa_section_status_'.$section->id, true);
			$status = $status == '' ? 1 : $status;
			
			?>
			
			<label class="switch">					
				<input name="<?php echo 'pa_section_status_'.esc_attr($section->id); ?>" <?php checked( $status , 1); ?> class="pa_section_status" value="1" type="checkbox">
				<span class="slider round"></span>
			</label>

			<?php esc_html_e('Enable', 'assemble');
			
			echo '</div>';

		echo '<div data-id="'.esc_attr($section->id).'" class="pa_admin_product_tab_content '.esc_attr($active).'">';

			foreach( $section->categories as $category )
			{
				echo '<div class="pa_admin_product_component">';
					echo '<h2>' . esc_html($category->name);
						
						$status = get_post_meta( $id, 'pa_category_status_'.$category->category, true);
						$status = $status == '' ? 1 : $status;
						?>

						<label class="switch">					
							<input name="<?php echo 'pa_category_status_'.esc_attr($category->category); ?>" <?php checked( $status , 1); ?> class="pa_section_status" value="1" type="checkbox">
							<span class="slider round"></span>
						</label>

						<?php esc_html_e('Enable', 'assemble'); ?>

						<?php

					echo '</h2>';
					$tax = array(
						array(
							'taxonomy' => 'product_cat',
							'field' => 'id',
							'terms' =>$category->category
						)
					);
					$args = array(
						'post_type' 		=> 'product',
						'posts_per_page'    => -1,
						'tax_query' 		=> $tax
					);

					$products = get_posts($args);
					?>
					<div class="pa_in_component">
						<label class="margin"><?php esc_html_e('Display', 'assemble'); ?></label>
						<div class="pa_in_component_val">
							<select multiple="multiple" name="pa_display[<?php echo esc_attr($category->category); ?>][]">
								<?php
								$meta = get_post_meta($id, 'pa_display_'.$category->category, true);

								$final = pa_final_object($meta, $products);
								
								foreach( $final as $product ):
									$selected = in_array($product->ID, (array) $meta) ? 'selected="selected"' : '';
									echo '<option '.esc_attr($selected).' value="'.esc_attr($product->ID).'">'.esc_html($product->post_title).'</option>';
								endforeach;
								?>
							</select>
							<p><?php esc_html_e("You specify which products to display.", "assemble"); ?></p>
						</div>
					</div>

					<div class="pa_in_component">
						<label><?php esc_html_e('Order', 'assemble'); ?></label>
						<div class="pa_in_component_val">
							<label class="switch">					
								<input name="<?php echo 'pa_display_order_'.esc_attr($category->category); ?>" <?php checked( get_post_meta( $id, 'pa_display_order_'.$category->category, true) , 1); ?> class="pa_section_status" value="1" type="checkbox">
								<span class="slider round"></span>
							</label>
							<?php echo esc_html__("Based on the order of the items selected above", "assemble"); ?>
							<p><?php echo esc_html__("You specify the display order of the above products for the user. If it is active, it will be displayed according to the order selected in the above section, and if it is not, it will be displayed according to the settings set in the computer assembly menu.", "assemble"); ?></p>
						</div>
					</div>

					<div class="pa_in_component">

						<label class="margin"><?php esc_html_e('Select', 'assemble'); ?></label>

						<div class="pa_in_component_val">

							<input type="hidden" value="<?php echo esc_attr($category->pa_select); ?>" class="pa_component_select_type" />
							
							<?php 
							$meta = get_post_meta( $id, 'pa_selected_products_'.$category->category, true );
							
							if ( is_array( $meta ) && ! empty($meta) ) :

								foreach( $meta as $item ):
									$product_id = $item['product_id'];
									$count = $item['quantity'];
									?>
									<div class="pa-selected-item">
										<select name="pa_selected_proudct[<?php echo esc_attr($category->category); ?>][]">
											<option value=""><?php echo esc_html__("Select product", "assemble"); ?></option>
											<?php 
											foreach( $final as $product ):
												$selected = $product->ID == $product_id ? 'selected="selected"' : '';
												echo '<option '.esc_attr($selected).' value="'.esc_attr($product->ID).'">'.esc_html($product->post_title).'</option>';
											endforeach;
											?>
										</select>
										<input name="pa_selected_quantity[<?php echo esc_attr($category->category); ?>][]" type="number" value="<?php echo esc_attr($count); ?>" placeholder="<?php esc_html_e('Count', 'assemble'); ?>" />
										<span class="remove_selected_item_star">*</span>
									</div>
								<?php 
								endforeach; 

							endif;
							?>

						</div>
						
						<div class="pa_add_selected_item_parent">
							<button type="button" class="button-secondary pa_add_selected_item"><?php echo esc_html__("Add", "assemble"); ?></button>

							<p><?php echo esc_html__("You specify which products are selected by default. This setting applies to recommended computers. Note that the selected items must be equal to the display setting above. If the display setting is empty, you can consider any product selected, but if the display setting is not empty, only include the selected ones from the displayed ones.", "assemble"); ?></p>
							<div class="pa-selected-item pa_selected_items_clone" style="display: none">
								<select name="pa_selected_proudct[<?php echo esc_attr($category->category); ?>][]">
									<option value=""><?php echo esc_html__("Select product", "assemble"); ?></option>
									<?php 
									foreach( $final as $product ):
										$selected = $product->ID == $product_id ? 'selected="selected"' : '';
										echo '<option '.esc_attr($selected).' value="'.esc_attr($product->ID).'">'.esc_html($product->post_title).'</option>';
									endforeach;
									?>
								</select>
								<input  name="pa_selected_quantity[<?php echo esc_attr($category->category); ?>][]" type="number" value="" placeholder="<?php esc_html_e('Count', 'assemble'); ?>" />
								<span class="remove_selected_item_star">*</span>
							</div>
						</div>

						

					</div>
					<?php
				echo '</div>';
			}

		echo '</div>';
		$i++;
	}
	?>
	<script>
	jQuery(document).ready(function($){
		$('.pa_in_component select').select2();

		$("select").on('select2:select', function(e){
			var id = e.params.data.id;
			var option = $(e.target).children('[value='+id+']');
			option.detach();
			$(e.target).append(option).change();
		});

		$(document).on('click', '.pa_admin_product_tabs li', function()
		{
			var id = $(this).attr('data-id');
			$('.pa_admin_product_tab_content').removeClass('active');
			$('.pa_admin_product_tabs li').removeClass('active');

			$('.pa_section_status_in').removeClass('active');
			$('.pa_section_status_in[data-id='+id+']').addClass('active');

			$(this).addClass('active');
			$('.pa_admin_product_tab_content[data-id='+id+']').addClass('active');
			$('.pa_admin_product_tab_content>div:first-child select').select2();
			
			setTimeout( function(){
				$('.pa_in_component select').select2();
			}, 100 )
		});
	});
	</script>
</div>