<?php
class PC_Assemble_Activator
{
	public function activate() 
	{
		$this->pc_assemble_activation();
		$this->pc_assemble_tables();
		$this->pc_assemble_options();
		$this->pc_assemble_main_product();
		delete_option('rewrite_rules');
	}

	function pc_assemble_activation ()
	{
		$home = str_replace( "https://", "", home_url() );
		$home = str_replace( "http://", "", $home );
		$home = str_replace( "www.", "", $home );
			
		$post = [ 
			'key'           => 'Ud9N0vT1eNTbmbi0Q5O3gg2DTHq4PF9V008', 
			'domain'        => $home,
			'product_id'    => 6634
		];
		
		$url = 'https://check.li3nce.ir/api/checkDomain';
		
		$req = wp_remote_post( $url, array(
            'body'    => $post
        ) );
        
        $result = json_decode( wp_remote_retrieve_body( $req ), true );
		
		if ( $result == 101 )
		{
			update_option('assemble_li3nce', $this->pc_assemble_encrypt_decrypt('encrypt',  preg_replace('/^www\./', '', sanitize_text_field( $_SERVER['SERVER_NAME'] ) ) ) );
		}
		else 
		{
			wp_die( esc_html__('Your site domain is not valid. Go to the user panel of the site where you got the plugin from. Enter the order and register your domain. Then activate the plugin', 'assemble') . ' <a href="'.esc_attr( admin_url("plugins.php") ).'">'.esc_html__("Return", "assemble").'</a>' );
		}
	}

	function pc_assemble_tables ()
	{
		global $wpdb, $charset_collate;
        $table = $wpdb->prefix . "pa_sections";
		$table2 = $wpdb->prefix . "pa_relations";
		$table3 = $wpdb->prefix . "pa_save";

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		$query1 = "CREATE TABLE IF NOT EXISTS $table (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) DEFAULT NULL,
        `category` bigint(20) NOT NULL DEFAULT 0,
        `parent` bigint(20) NOT NULL DEFAULT 0,
        `display` enum('available','all') DEFAULT NULL,
        `pa_order` enum('asc-date','desc-date','asc-price','desc-price','top-sale') DEFAULT NULL,
        `pa_select` enum('single','multiple') NOT NULL DEFAULT 'single',
        `stock_limit` enum('0','1') NOT NULL DEFAULT '0',
        `mandatory` enum('0','1') DEFAULT '0',
        `status` enum('0','1') NOT NULL DEFAULT '1',
        `mode` varchar(255) DEFAULT 'multi-tab',
		PRIMARY KEY (`id`)
        ) $charset_collate;";

		dbDelta( $query1 );

		$query2 = "CREATE TABLE IF NOT EXISTS $table2 (
        `id` bigint(20) NOT NULL AUTO_INCREMENT,
		`pa_type` enum('tag','attribute') NOT NULL DEFAULT 'tag',
		`pa_from` bigint(20) NOT NULL,
		`pa_from_attr` bigint(20) DEFAULT NULL,
		`pa_from_attr_value` bigint(20) DEFAULT NULL,
		`pa_to` bigint(20) NOT NULL,
		`pa_to_attr` bigint(20) DEFAULT NULL,
		`pa_to_attr_value` bigint(20) DEFAULT NULL,
		`pa_tag` bigint(20) DEFAULT NULL,
		`status` enum('0','1') NOT NULL DEFAULT '1',
		PRIMARY KEY (`id`)
        ) $charset_collate;";
         
        dbDelta( $query2 );

		$query3 = "CREATE TABLE IF NOT EXISTS $table3 (
        `id` bigint(20) NOT NULL AUTO_INCREMENT,
		`assemble_id` bigint(20) NOT NULL,
		`data` longtext NOT NULL,
		PRIMARY KEY (`id`),
		KEY `id` (`id`)
        ) $charset_collate;";
         
        dbDelta( $query3 );
	}

	function pc_assemble_options ()
	{
		$options = array(
			'pa_product_display'     		=> 'avilable',
            'pa_product_display_order'     	=> 'asc-date',
			'pa_display_mode'				=> 'multi-tab',
			'_pa_design_settings'			=> [
				'background_color'	=> '#000',
				'background_image'	=> PA_PUBLIC_URL.'images/pc2.jpg',
				'fix_background_image'	=> 'on',
				'categories_background_color'	=> 'rgba(28, 28, 28, 0.96)',
				'categories_background_image'	=> '',
				'categories_border'	=> '1px solid #252525',
				'categories_item_hover_background'	=> 'rgba(255,255,255,.08)',
				'display_category_image'	=> 'on',
				'tab_background_color'	=> '#000',
				'tab_color'	=> '#fff',
				'tab_border'	=> '1px solid rgba(115,115,115,.5)',
				'tab_font_size'	=> '14px',
				'tab_hover_color'	=> '#F1E5AC',
				'category_title_color'	=> '#fff',
				'category_title_font_size'	=> '14px',
				'category_item_selected_color'	=> '#fff',
				'category_item_selected_font_size'	=> '14px',
				'category_item_price_color'	=> '#F1E5AC',
				'category_item_price_font_size'	=> '14px',
				'categories_box_shadow'	=> '',
				'category_not_selected_color' => 'lawngreen',
				'category_not_selected_font_size' => '14px',
				'thumbnail_width'	=> '230px',
				'product_summary_border'	=> 'rgba(28, 28, 28, 0.96)',
				'product_summary_box_shadow'	=> '',
				'total_price_text_color'	=> '#fff',
				'total_price_text_font_size'	=> '14px',
				'total_price_color'	=> '#F1E5AC',
				'total_price_font_size'	=> '23px',
				'add_to_cart_button_color'	=> '#fff',
				'add_to_cart_button_font_size'	=> '16px',
				'add_to_cart_button_background'	=> 'rgba(255,255,255,.1)',
				'add_to_cart_button_padding'	=> '13px 15px 14px',
				'add_to_cart_button_hover_background'	=> 'rgba(255,255,255,.2)',
				'add_to_cart_button_hover_color'	=> '#F1E5AC',
				'social_icon_color'	=> '#fff',
				'social_icon_background_color'	=> '#000',
				'social_icon_width'	=> '36',
				'social_icon_padding'	=> '7px',
				'social_icon_border'	=> '1px solid #444',
				
			],
			'pa_share_link_expiration'	=> '90',
			'pa_share_button'	=> 1,
			'pa_print_button'	=> 1,
			'pa_save_on_print'	=> 1,
			'pa_save_after_add_to_cart'	=> 1
        );
        
        foreach($options as $key=>$value) 
        {
            if ( get_option($key, 11111) == 11111 ) add_option($key, $value);
        }
	}

	function pc_assemble_encrypt_decrypt($action, $string) 
    {
        $output = false;
        $encrypt_method = "AES-256-CBC";
        $secret_key = 'M`zL<*@vUw>)p5xq$HD/~P341';
        $secret_iv = 'G5>eTY4cV~p(+MWJ}g!Cq,231';
        $key = hash('sha256', $secret_key);
    
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ( $action == 'encrypt' ) 
        {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } 
        else if( $action == 'decrypt' ) 
        {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }

	public function pc_assemble_main_product ()
	{
		//Options Not Exists Or Empty
		$id = get_option('pa_main_product', '');

		$noProduct = 0;

		//Options Exists But Product Not Exists
		if ( $id != '' )
		{
			//Get Product
			$product = wc_get_product( $id );

			//Return If Product Exists
			if ( ! $product || ( $product && $product->get_status() == 'trash' ) )
			{
				$noProduct = 1;
			}
		}

		if ( $id == '' || $noProduct == 1 ) 
		{
			ob_start();
			global $wpdb;
			$table = $wpdb->prefix . 'posts';

			$post = $wpdb->get_row("SELECT * FROM $table WHERE post_name='pc-assemble-pro-main-product'", 'ARRAY_A');

			if( ! $post ) 
			{
				$post_id = wp_insert_post( array (
					'post_title' 	=> __('PC Assemble Pro', 'assemble'),
					'post_name'		=> 'pc-assemble-pro-main-product',
					'post_content'  => '',
					'post_status' 	=> 'publish',
					'post_type' 	=> 'product' )
				);
				update_post_meta( $post_id, '_price', 0 );
				update_post_meta( $post_id, '_regular_price', 0 );
				$child_product = wc_get_product($post_id);
				$child_product->set_catalog_visibility('hidden');
				$child_product->save();
				update_option('pa_main_product', $post_id);
			} 
			else 
			{
				update_option('pa_main_product', $post['ID']);
			}

			return ob_get_clean();
		}
	}
}
$obj = new PC_Assemble_Activator();
$obj->activate();