<?php

defined('ABSPATH') || die;

class PC_Assemble_Woocommerce 
{
	public function __construct ()
	{
		add_action( 'woocommerce_product_query', [$this, 'woocommerce_product_query'] );
		add_filter( 'woocommerce_add_to_cart_redirect', [$this, 'woocommerce_add_to_cart_redirect'] );
		add_filter( 'woocommerce_add_cart_item_data', [$this, 'woocommerce_add_cart_item_data'], 999999, 3 );
		add_filter( 'woocommerce_get_item_data', [$this, 'woocommerce_get_item_data'], 10, 2 );
		add_action( 'woocommerce_checkout_create_order_line_item', [$this, 'woocommerce_checkout_create_order_line_item'], 10, 4 );
		add_action( 'woocommerce_before_calculate_totals',[$this, 'woocommerce_before_calculate_totals'] );
		add_filter( 'woocommerce_add_to_cart_validation', [$this, 'remove_cart_item_before_add_to_cart'], 1, 3);
		add_filter( 'woocommerce_cart_item_permalink', [$this, 'woocommerce_cart_item_permalink'] , 10, 3 );
		add_filter( 'woocommerce_cart_item_thumbnail', [$this, 'woocommerce_cart_item_thumbnail'], 999, 3 );
	}

	function woocommerce_cart_item_permalink( $permalink, $cart_item, $cart_item_key ) 
	{
		if ( get_option('pa_save_after_add_to_cart', 0) != '1' ) return $permalink;

		return isset( $cart_item['pa_save'] ) ? $cart_item['pa_save'] : $permalink;
	}

	public function remove_cart_item_before_add_to_cart($passed, $product_id, $quantity) 
	{
		if( $product_id != get_option('pa_main_product') ) return $passed;

		$already_in_cart = false;
		
		foreach( WC()->cart->get_cart() as $key => $item )
		{
			if( $item['product_id'] == $product_id )
			{
				$already_in_cart = true;
				$existing_product_key = $key;
				break;
			}
		}

		if( $already_in_cart  )
		{
			WC()->cart->remove_cart_item($existing_product_key);
		}
		
		return $passed;
	}

	public function woocommerce_product_query ($query)
	{
		if ( $query->is_main_query() && ! is_admin() && $query->is_post_type_archive( 'product' ) )
		{
			$query->set( 'tax_query', array(
				array(
					'taxonomy' 	=> 'product_cat',
					'field' 	=> 'slug',
					'terms' 	=> get_option('pa_excluded_category',[]),
					'operator' 	=> 'NOT IN'
				)
			));
		}
	}

	public function woocommerce_add_to_cart_redirect ($url)
	{
        if (  isset( $_REQUEST['add-to-cart'] ) && $_REQUEST['add-to-cart'] == get_option('pa_main_product') )
		{
            wc_clear_notices();
            $url = wc_get_cart_url();
        }

        return $url;
	}

	public function woocommerce_add_cart_item_data ( $cart_item_data, $product_id, $variation_id )
	{   
	    if ( $product_id == get_option('pa_main_product') ) 
        {   
			$output2 = [];
			foreach( $_POST as $key=>$value ) 
			{
				if ( strpos( $key, 'pa_selecteds_' ) === 0 ) 
				{
					if ( $_POST[$key] == '' ) continue;

					$key2 = explode("_", $key);
					$cat = end( $key2 );
					
					$values = explode("|", sanitize_text_field( $_POST[$key] ));

					$output = [];
					$output2[] = ['cat' => $cat, 'value' => sanitize_text_field( $_POST[$key] ) ];

					foreach ( $values as $item )
					{
						$product = explode(",", $item);

						$output[] = [
							'product_id'	=> $product[0],
							'quantity'		=> $product[1]
						];
					}

					$cart_item_data['pa_selected_'.$cat] = $output;
				}
			}

			if ( get_option('pa_save_after_add_to_cart', 0) == '1' )
			{
				$cart_item_data['pa_save'] = $this->save_build_callback( sanitize_text_field( $_POST['system_id'] ), $output2);
			}	

			$cart_item_data['pa_id'] = sanitize_text_field( $_POST['system_id'] );
        }

        return $cart_item_data;
	}

	public function save_build_callback ($assemble_id, $data)
	{
		global $wpdb;
		$table = $wpdb->prefix.'pa_save';
		$data2 = isset($data) && $data != '' ? $data : [];
		$data2 = serialize($data2);

		$get = $wpdb->get_row("select * from $table where data='$data2'");
		if ( $get != null ) return get_the_permalink($get->assemble_id) . '?pa=' .$get->id;

		$wpdb->insert( $table, [
			'assemble_id'	=> $assemble_id,
			'data'			=> $data2
		]);

		return get_the_permalink($assemble_id) . '?pa=' .$wpdb->insert_id;
	}

	public function woocommerce_get_item_data ( $item_data, $cart_item_data ) 
	{
		if ( get_option('pa_save_after_add_to_cart', 0) == '1' && isset( $cart_item_data['pa_save'] ) )
		{
			$value = $cart_item_data['pa_save'];
			$item_data[] = array( 
				'name' => __('Build Link', 'assemble'), 
				'value' => '<a href="'.$value.'">'.$value.'</a>',
				'display' => '',
			);
		}

		foreach( $cart_item_data as $key=>$value ) 
		{
			if ( strpos( $key, 'pa_selected_' ) === 0 ) 
			{
				$title = '';

				$arr = explode("_",$key);
				$cat = end( $arr );
				$cat = get_term($cat);

				foreach ( $cart_item_data[$key] as $key2=>$item )
				{
					if ( $key2 != 0 ) $title .= ', ';
					$q = $item['quantity'];
					$title .= get_the_title( $item['product_id'] ) . ' ('.$q.'عدد)';
				}

				$item_data[] = array (
					'key'   => $cat->name,
					'value' => $title,
				);
			}

			
		}
				
		return $item_data;
	}

	public function woocommerce_checkout_create_order_line_item ( $item, $cart_item_key, $values, $order ) 
	{
		if ( get_option('pa_save_after_add_to_cart', 0) == '1' && isset( $values['pa_save'] ) )
		{
			$item->add_meta_data( 'Build Link', $values['pa_save'], true );
		}

		foreach ( $values as $key=>$value )
		{
			if ( strpos( $key, 'pa_selected_' ) === 0 ) 
			{
				$arr = explode("_",$key);
				$cat = end( $arr );
				$cat = get_term($cat);

				$title = '';

				foreach ( $value as $key2=>$item2 )
				{
					if ( $key2 != 0 ) $title .= ', ';
					$q = $item2['quantity'];
					$title .= get_the_title( $item2['product_id'] ) . ' ('.$q.'عدد)';
				}

				$item->add_meta_data( $cat->name, $title, true );
			}
		}
	}

	function woocommerce_cart_item_thumbnail( $product_image, $cart_item, $cart_item_key ) 
	{
		if ( $cart_item['product_id'] == get_option('pa_main_product') )
		{
			return '<img src="'.get_the_post_thumbnail_url( $cart_item['pa_id'] ).'" />';
		}
		
		return $product_image;
	}

	public function woocommerce_before_calculate_totals ($cart)
	{
		$total = 0;
		foreach( $cart->get_cart() as $key=>$cart_item ) 
		{
			if ( get_option('pa_main_product') == $cart_item['product_id'] ) 
			{
				foreach ( $cart_item as $key2=>$value )
				{
					if ( strpos( $key2, 'pa_selected_' ) === 0 ) 
					{
						$price = 0;

						foreach ( $value as $product )
						{
							$product_id = $product['product_id'];
							$_product 	= wc_get_product( $product_id );
							$quantity   = $product['quantity'];

							$price += $_product->get_price() * $quantity;
						}

						$total += $price;
					}
				}

				$cart_item['data']->set_price( $total );
				
				$product = $cart_item['data'];
				$product->set_name( get_the_title( $cart_item['pa_id'] ) );
			}
		}
	}
}

new PC_Assemble_Woocommerce();