<?php
defined('ABSPATH') or die;

class Pa_Assemble {

	public static $wpdb;
	protected static $sections_table;
	protected static $options_table;
	protected static $relations_table;

	public function __construct() 
	{
		$this->define_variables();
		$this->define_constants();
		$this->includes();

		add_action( 'init', [$this, 'pa_init'] );
	}

	public function pa_init ()
	{
		$labels = array(
			'name'                  => __( 'Assembles', 'assemble' ),
			'singular_name'         => __( 'Assemble', 'assemble' ),
			'menu_name'             => __( 'Assembles', 'assemble' ),
			'name_admin_bar'        => __( 'Assembles', 'assemble' ),
			'archives'              => __( 'Item Archives', 'assemble' ),
			'attributes'            => __( 'Item Attributes', 'assemble' ),
			'parent_item_colon'     => __( 'Parent Item:', 'assemble' ),
			'all_items'             => __( 'All Assembles', 'assemble' ),
			'add_new_item'          => __( 'Add New', 'assemble' ),
			'add_new'               => __( 'Add New', 'assemble' ),
			'new_item'              => __( 'New Item', 'assemble' ),
			'edit_item'             => __( 'Edit Item', 'assemble' ),
			'update_item'           => __( 'Update Item', 'assemble' ),
			'view_item'             => __( 'View Item', 'assemble' ),
			'view_items'            => __( 'View Items', 'assemble' ),
			'search_items'          => __( 'Search Item', 'assemble' ),
			'not_found'             => __( 'Not found', 'assemble' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'assemble' ),
			'featured_image'        => __( 'Featured Image', 'assemble' ),
			'set_featured_image'    => __( 'Set featured image', 'assemble' ),
			'remove_featured_image' => __( 'Remove featured image', 'assemble' ),
			'use_featured_image'    => __( 'Use as featured image', 'assemble' ),
			'insert_into_item'      => __( 'Insert into item', 'assemble' ),
			'uploaded_to_this_item' => __( 'Uploaded to this item', 'assemble' ),
			'items_list'            => __( 'Items list', 'assemble' ),
			'items_list_navigation' => __( 'Items list navigation', 'assemble' ),
			'filter_items_list'     => __( 'Filter items list', 'assemble' ),
		);
		$args = array(
			'label'                 => __( 'Assemble', 'assemble' ),
			'description'           => __( 'Assemble Description', 'assemble' ),
			'labels'                => $labels,
			'supports'              => array('title', 'thumbnail'),
			'taxonomies'            => array(),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 5,
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => true,
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
			'menu_icon'				=> 'dashicons-desktop',
			'rewrite' => [ 'slug' => 'pcassemble' ]
		);
		register_post_type( 'pcassemble', $args );
	}

	protected function define_variables()
	{
		global $wpdb;

		self::$wpdb = $wpdb;
		self::$sections_table  = $wpdb->prefix . 'pa_sections';
		self::$options_table   = $wpdb->prefix . "options";
		self::$relations_table = $wpdb->prefix . 'pa_relations';
	}

	protected function define_constants() 
	{
		$data = get_file_data( PA_PLUGIN, array(
			'Version' => 'Version', 
			'Title' => 'Plugin Name'
		), false);

		$this->define( 'PA_VERSION', $data['Version'] );
		$this->define( 'PA_TITLE', $data['Title']);
		$this->define( 'PA_NAME', 'pa' );
    	$this->define( 'PA_BASE', dirname( PA_PLUGIN ) );
    	$this->define( 'PA_BASE_URL', plugin_dir_url( PA_PLUGIN ) );

		$this->define( 'PA_PUBLIC', PA_BASE . '/public' );
		$this->define( 'PA_PUBLIC_URL', PA_BASE_URL . 'public/' );
	}

	protected function includes()
	{
		if ( ! is_admin() )
		{
			require_once PA_BASE . '/public/class-pa-public.php';
			require_once PA_BASE . '/public/class-pa-public-rest.php';
			require_once PA_BASE . '/includes/class-pa-woocommerce.php';
		}

		if ( is_admin() ) 
		{
			require_once PA_BASE . '/admin/class-pa-admin.php';
		}

		require_once PA_BASE . '/admin/class-pa-admin-rest.php';
	}

	protected function define( $name, $value ) 
	{
		if ( ! defined( $name ) ) 
		{
			define( $name, $value );
		}	
	}

	protected function get_options( $args )
	{
		$options = sprintf(
			'option_name IN (%s)',
			$this->prepare_in( $args )
		);

		$table = self::$options_table;

		$results = self::$wpdb->get_results( "SELECT option_name,option_value FROM {$table} WHERE $options;" );
		
		$output = [];
		
		foreach($results as $item)
			$output[$item->option_name] = $item->option_value;
			
		foreach( $args as $item ) 
			if ( !isset( $output[$item] ) ) $output[$item] = '';

		return $output;
	}

	protected function prepare_in ( $args ) 
	{
		return implode( 
			',', 
			array_map( 
				function ( $value ) 
				{
					return self::$wpdb->prepare( '%s', $value );
				}, 
				$args
			) 
		);
	}
}

new Pa_Assemble();
