<?php

function pc_assemble_admin_tabs()
{
	$current = isset( $_GET['tab'] ) ? sanitize_text_field( $_GET['tab'] ) : 'general';

	$tabs = [
		'general'  	=> __('General', 'assemble'),
		'sections'  => __('Sections', 'assemble'),
		'relations'	=> __('Relations', 'assemble'),
		'design'	=> __('Design', 'assemble')
	];

	if ( home_url() == 'https://biawp.com' || home_url() == 'https://biawp.ir/pcassemblepro' )
		$tabs['roadmap'] = __('Roadmap', 'assemble');

	$output = '';

	$output .= '<h2 class="nav-tab-wrapper">';

	foreach( $tabs as $tab => $name )
	{
		$class = ( $tab == $current ) || ( isset( $_GET['tab'] ) && 'categories' == $_GET['tab'] && 'sections' == $tab ) ? ' nav-tab-active' : '';

		$url = admin_url("admin.php?page=pa-settings&tab={$tab}");
		
		$output .= "<a class='nav-tab {$class}' href='".$url."'>{$name}</a>";
	}

	$output .= '</h2>';

	return $output;
}

function pc_assemble_return_default ( $main_option, $option, $default )
{
	return isset($main_option[$option]) && $main_option[$option] != '' ? $main_option[$option] : $default;
}