<?php
defined('ABSPATH') || die;

class PC_Assemble_Public_Rest
{
	protected static $sections_table;
	protected static $relations_table;
	protected static $wpdb;
	protected static $save_table;

	function __construct ()
	{
		global $wpdb;
		self::$wpdb = $wpdb;

		self::$sections_table = self::$wpdb->prefix . 'pa_sections';
		self::$relations_table = $wpdb->prefix . 'pa_relations';
		self::$save_table = $wpdb->prefix . 'pa_save';

		add_filter( 'rest_api_init', [$this, 'rest_api_init'] );
	}

	function rest_api_init()
	{
		register_rest_route( 'pa', '/readProducts', array(
            'methods' 		=> 'POST',
            'callback' 		=> [$this, 'pa_read_products'],
            'permission_callback' => '__return_true'
        ));

		register_rest_route( 'pa', '/getComponentPrice', array(
			'methods' => 'POST',
			'callback' => [$this, 'get_component_price_callback'],
			'permission_callback' => '__return_true'
		));

		register_rest_route( 'pa', '/getTotalPrice', array(
			'methods' => 'POST',
			'callback' => [$this, 'get_total_price_callback'],
			'permission_callback' => '__return_true'
		));

		register_rest_route( 'pa', '/saveBuild', array(
			'methods' => 'POST',
			'callback' => [$this, 'save_build_callback'],
			'permission_callback' => '__return_true'
		));

		register_rest_route( 'pa', '/getComponentRealData', array(
			'methods' => 'POST',
			'callback' => [$this, 'get_component_real_data_callback'],
			'permission_callback' => '__return_true'
		));
	}

	public function get_component_real_data_callback ($data)
	{
		// Break Bots
		$headers = $data->get_headers();
		if ( ! isset( $headers['p_nonce'] ) )
		{
			return '';
		}

		$output = [];

		$qu = 0;
		$total = 0;

		foreach( $data['data'] as $item ) 
		{
			$cat = sanitize_text_field( $item['cat'] );
			$values = sanitize_text_field( $item['value'] );

			$term = get_term($cat);
			$values_exp1 = explode("|", $values);

			foreach ( $values_exp1 as $item2 )
			{
				$product 	= explode(",", $item2);
				$product_id = $product[0];
				$quantity 	= $product[1];
				$_product = wc_get_product($product_id);

				$output[] = [
					'cat'	=> $term->name,
					'title'	=> get_the_title($product_id),
					'image'	=> get_the_post_thumbnail_url($product_id),
					'quantity' => $quantity,
					'price'	=> $_product->get_price_html(),
					'total'	=> wc_price( $_product->get_price() * $quantity )
				];

				$qu += $quantity;
				$total += $_product->get_price() * $quantity;

			}
		}

		$rows = '';

		foreach( $output as $item )
		{
			$rows .= '<tr><td><img width="40" src="'.$item["image"].'">'.$item["title"].'</td><td>'.$item["cat"].'</td><td>'.$item["quantity"].'</td><td>'.$item["price"].'</td><td class="text-right">'.$item["total"].'</td></tr>';
		}
		
		

		$final = [
			'rows' => $rows,
			'quantity' => $qu,
			'total'	=> wc_price($total),
			'page_title'	=> get_the_title($data['assemble_id'])
		];

		if ( get_option('pa_save_on_print', 0) == '1' ) 
		{
			$final['build_url']	= $this->save_build_callback($data);
		}

		return $final;
	}

	public function save_build_callback ($data)
	{
		// Break Bots
		$headers = $data->get_headers();
		if ( ! isset( $headers['p_nonce'] ) )
		{
			return '';
		}

		global $wpdb;
		$table = self::$save_table;
		$data2 = isset($data['data']) ? $data['data'] : [];
		$data2 = serialize($data2);

		$get = $wpdb->get_results( "select * from $table where data='$data2'" );
		if ( isset( $get[0] ) ) 
		{
			return get_the_permalink($get[0]->assemble_id) . '?pa=' .$get[0]->id;
		}

		$wpdb->insert( $table, [
			'assemble_id'	=> $data['assemble_id'],
			'data'			=> $data2
		]);

		return get_the_permalink($data['assemble_id']) . '?pa=' .$wpdb->insert_id;
	}


	function get_component_price_callback($data)
	{
		// Break Bots
		$headers = $data->get_headers();
		if ( ! isset( $headers['p_nonce'] ) )
		{
			return '';
		}

		$excluded = $this->pa_filter_selected_products($data);

		$filters = isset( $excluded[0] ) ? $this->pa_filter_relations( $data, $excluded ) : [];

		$changeImage = '';

		$case_cat = get_option('pa_case_category', 0);
		if ( 
			get_option('pa_change_main_img_with_case_selected', 0) == 1 &&
			$data['cat'] == $case_cat
			)
		{
			foreach( $data['total'] as $item )
			{
				if ( $item['cat'] == $case_cat )
				{
					$changeImage = get_the_post_thumbnail_url($item['value']);
				}
			}
		}

		return [ 
			'price' => number_format( $this->pa_get_component_price($data, $excluded) ), 
			'total' => $this->pa_get_total_price($data, $excluded),
			'filter'=> $filters,
			'changeImage' => $changeImage
		];
	}

	private function pa_filter_relations ( $data, $excluded )
	{
		$output = [];

		foreach ( $data['to'] as $to )
		{
			$values = explode("|", sanitize_text_field( $to['value'] ));

			$title 		= '';
			$selected 	= '';
			$x 	= 0;
			$total = 0;
			foreach ( $values as $value )
			{
				$exp 		= explode(",", $value);
				$product_id = $exp[0];
				$quantity 	= $exp[1];

				foreach ( $excluded as $exclude ) 
				{
					$exclude_id = $exclude[0];

					if ( $product_id && $product_id != $exclude_id )
					{
						$product = wc_get_product( $product_id );
						$x = 1;
						$title .= get_the_title($product_id) . ' (X' .$quantity. ')';
						$selected .= $product_id . ',' . $quantity . '|';
						$total += $product->get_price() * $quantity;
					}
				}
			}

			if ( $x == 1 ) 
			{
				$output[] = [
					'cat' 		=> $to['id'],
					'title' 	=> $title,
					'selected'	=> rtrim($selected, '|'),
					'total'		=> number_format($total)
				];
			}
			else 
			{
				$output[] = [
					'cat' 		=> $to['id'],
					'title' 	=> $title,
					'selected'	=> $selected,
					'total'		=> 0
				];
			}
		}


		return $output;
	}

	private function pa_filter_selected_products ( $data )
	{
		//Break When No Related Exists
		if ( ! isset( $data['to'] ) ) return [];
		
		//Current Category
		$cat = $data['cat'];

		//Products Exists In Relate_To But Dont have exist
		$excluded = [];

		$x = 0;

		$relate_exists = [];

		//Loop In Relations
		foreach( $data['to'] as $to )
		{
			if ( $to['value'] == '' ) continue;

			$tag = $this->get_relation_tag_between( $cat, $to['id'] );

			foreach ( $data['total'] as $category )
			{
				//Detect Current Category
				if ( $cat == $category['cat'] )
				{
					//Products With Current Category
					$values = explode("|", $category['value']);

					foreach ( $values as $value ) 
					{
						$item = explode(",", $value);
						$product_id = $item[0];

						if ( $tag->pa_type == 'attribute' )
						{
							$tax = wc_get_attribute( $tag->pa_from_attr );

							if ( has_term( $tag->pa_from_attr_value, $tax->slug, $product_id ) && $product_id )
							{
								$relate_exists[] = $to['id'];
							}
						}
						else 
						{
							if ( has_term( $tag->pa_tag, 'product_tag', $product_id ) && $product_id )
							{
								$relate_exists[] = $to['id'];
							}
						}

						
					}
				}
			}
		}

		foreach ( $data['to'] as $to ) 
		{
			if ( in_array( $to['id'], $relate_exists ) )
			{
				$tag = $this->get_relation_tag_between( $cat, $to['id'] );

				$values = explode("|", $to['value'] );

				foreach ( $values as $value ) 
				{
					$item = explode(",", $value);
					$product_id = $item[0];

					if ( $tag->pa_type == 'attribute' )
					{
						$tax = wc_get_attribute( $tag->pa_to_attr );

						if ( ! has_term( $tag->pa_to_attr_value, $tax->slug, $product_id ) && $product_id )
						{
							$excluded[] = [$product_id, $to['id']];
						}
					}
					else 
					{
						if ( ! has_term( $tag->pa_tag, 'product_tag', $product_id ) && $product_id ) 
						{
							$excluded[] = [$product_id, $to['id']];
						}
					}
					
				}
			}
		}

		return $excluded;
	}

	private function get_relation_tag_between ( $from, $to )
	{
		global $wpdb;
		$table = $wpdb->prefix . 'pa_relations';

		$row = $wpdb->get_row( "select * from $table where pa_from='$from' and pa_to='$to' and status=1" );

		return $row==null ? false : $row;
	}

	function get_total_price_callback($data)
	{
		// Break Bots
		$headers = $data->get_headers();
		if ( ! isset( $headers['p_nonce'] ) )
		{
			return '';
		}

		return $this->pa_get_total_price($data);
	}

	function pa_get_component_price($data, $excluded = [])
	{
		$data = sanitize_text_field( $data['data'] );
		$products = explode("|", $data);
		$products = array_filter($products);

		if(!isset( $products[0] ) ) return 0;

		$price = 0;
		foreach( $products as $key => $product )
		{
			$pro = explode(",", $product);
			$product_id = $pro[0];

			$x = 0;

			if ( ! empty( $excluded ) ) 
			{
				foreach ( $excluded as $not ) 
				{
					if ( $product_id == $not[0] ) $x = 1;
				}
			}

			if ( $x != 1 ) 
			{
				$quantity = $pro[1];

				$pros = wc_get_product( $product_id );

				$current_price = $pros->get_price() == "" ? 0 : $pros->get_price();

				$price += $current_price * $quantity;
			}
		}

		return $price;
	}

	function pa_get_total_price ($data, $excluded = []) 
	{
		$total = 0;

		foreach( $data['total'] as $key => $item )
		{
			if( $item['value'] != '' ) 
			{
				$total += $this->pa_get_component_price(['data' => sanitize_text_field( $item['value'] ) ], $excluded);
			}
				
		}

		return number_format($total);
	}

	function pa_get_category_display( $term_id )
	{
		$table 	= self::$sections_table;
		$rows 	= self::$wpdb->get_results( self::$wpdb->prepare( "select * from $table where category='%d'", $term_id ));
		return isset($rows[0]) && $rows[0]->display!='' ? $rows[0]->display : get_option('pa_product_display', 'available');
	}

	function pa_query_params_by_display($args, $term_id)
	{
		$order = $this->pa_get_category_display( $term_id );

		switch($order)
		{
			case 'available':
				$args['meta_query'] 	= array(
					array(
						'key' => '_stock_status',
						'value' => 'instock'
					)
				);
			break;
		}

		return $args;
	}

	function pa_get_category_order($term_id)
	{
		$table = self::$sections_table;
		$rows = self::$wpdb->get_row( self::$wpdb->prepare( "select * from $table where category='%d'", $term_id ) );
		return $rows && $rows->pa_order!='' ? $rows->pa_order : get_option('pa_product_display_order', 'asc-date');
	}

	function pa_query_params_by_order($args, $term_id, $system_id, $default=false)
	{
		$meta = get_post_meta($system_id, 'pa_display_order_'.$term_id, true);
		if ( $default==false && $meta == 1 ) return false;

		$order = $default ? $default : $this->pa_get_category_order( $term_id );

		switch($order)
		{
			case 'asc-date':
				$args['orderby'] 	= 'date';
				$args['order'] 		= 'ASC';
			break;

			case 'desc-date':
				$args['orderby'] 	= 'date';
				$args['order'] 		= 'DESC';
			break;

			case 'asc-price':
				$args['orderby'] 	= 'meta_value_num';
				$args['meta_key'] 	= '_price';
				$args['order'] 		= 'ASC';
			break;

			case 'desc-price':
				$args['orderby'] 	= 'meta_value_num';
				$args['meta_key'] 	= '_price';
				$args['order'] 		= 'DESC';
			break;

			case 'top-sale':
				$args['orderby'] 	= 'meta_value_num';
				$args['meta_key'] 	= 'total_sales';
				$args['order'] 		= 'DESC';
			break;
		}

		return $args;
	}

	function pa_check_selected($data, $id)
	{
		$data = sanitize_text_field( $data['selected'] );
		$products = explode("|", $data);
		$products = array_filter($products);

		if(!isset( $products[0] ) ) return false;

		$price = 0;
		foreach( $products as $product )
		{
			$pro = explode(",", $product);
			$product_id = $pro[0];
			$quantity = $pro[1];

			if( $product_id == $id ) {
				return $pro[1];
			}
		}

		return false;
	}

	private function get_relation_tag ( $relate_to )
	{
		$relate_to = explode( "|", $relate_to );
		$in = join("','",$relate_to);

		global $wpdb;
		$table = $wpdb->prefix . 'pa_relations';

		$row = $wpdb->get_results( "select * from $table where pa_to in ('$in')" );

		if ( ! $row ) return [];
		
		$output = [];

		foreach( $row as $item ) 
		{
			$output[] = $item->pa_tag;
		}

		return $output;
	}

	function pa_check_meta($system_id, $term_id, $args)
	{
		$check = get_post_meta($system_id, 'pa_display_'.$term_id, true);

		if( $check == false || $check == '' || !isset($check[0]) ) return $args;

		$args['post__in'] = $check;

		return $args;
	}

	private function return_tag ( $from, $to )
	{
		global $wpdb;
		$table = $wpdb->prefix . 'pa_relations';

		$row = $wpdb->get_results( "select * from $table where pa_from=$from and pa_to=$to" );

		return $row ? $row : false;
	}

	function pa_get_category ($category)
	{
		global $wpdb;
		$table = $wpdb->prefix . 'pa_sections';

		$row = $wpdb->get_row( "select * from $table where category=$category" );

		return $row;
	}

	function pa_read_products($data)
	{
		// Break Bots
		$headers = $data->get_headers();
		if ( ! isset( $headers['p_nonce'] ) )
		{
			return '';
		}

		$tax = array (
			array (
				'taxonomy' => 'product_cat',
				'field' 	=> 'id',
				'terms' 	=> sanitize_text_field( $data['term_id'] )
			),
			'relation' => 'AND'
		);

		if ( isset( $data['relations'][0] ) )
		{
			foreach ( $data['relations'] as $product )
			{
				if ( $product['value'] == '' ) continue;

				$cat_id = $product['name'];

				$tags = $this->return_tag($cat_id, $data['term_id']);

				$values = explode("|", $product['value']);
				
				foreach ( $values as $value )
				{
					$exp = explode(",", $value);

					$product_id = $exp[0];

                    foreach( $tags as $tag )
					{
					    if ( $tag->pa_type == 'attribute' )
					    {
					        $fa_tax = wc_get_attribute( $tag->pa_from_attr );
						    $ta_tax = wc_get_attribute( $tag->pa_to_attr );
						
    						if ( has_term ( $tag->pa_from_attr_value, $fa_tax->slug, $product_id ) ) 
    						{
    							$tax[] = array (
    								'taxonomy' 	=> $ta_tax->slug,
    								'field' 	=> 'id',
    								'terms' 	=> [$tag->pa_to_attr_value]
    							);
    						}
					    }
					    else {
					        if ( has_term ( $tag->pa_tag, 'product_tag', $product_id ) ) 
    						{
    							$tax[] = array (
    								'taxonomy' 	=> 'product_tag',
    								'field' 	=> 'id',
    								'terms' 	=> [$tag->pa_tag]
    							);
    						}
					    }
					    
					}
				}
				
			}
		}
		
		$post_status = array('publish');
		
		if ( get_option('pa_private_products_display', false) )
		$post_status[] = 'private';

	    $args = [
	        'post_type' 		=> 'product',
	        'posts_per_page'    => -1,
	        'tax_query' 		=> $tax,
	        'post_status'       => $post_status,
	    ];

		if(isset($data['key'])) $args['s'] = $data['key'];

		$order = $this->pa_query_params_by_order($args, $data['term_id'], $data['system_id'], $data['order']);
		if( $order ) {
			$args = $order;
		}
		else {
			$args['orderby'] = 'post__in';
		}

		$args = $this->pa_query_params_by_display($args, $data['term_id']);

		$args = $this->pa_check_meta( $data['system_id'], $data['term_id'], $args );
	    
	    $output = '';

	    $selecteds = '';

	    foreach( get_posts($args) as $key=>$product )
	    {
	        $_product = wc_get_product( $product->ID );
			
			$q = $this->pa_check_selected($data, $product->ID);
			$quantity = $q ? $q : 0;
			$selected = $q ? 'selected' : '';

			$category = $this->pa_get_category( $data['term_id'] );

			$limit = $category->stock_limit == 1 ? get_post_meta( $product->ID, '_stock', true ) : '';
			$limit = $category->stock_limit == 1 && get_post_meta( $product->ID, '_stock_status', true ) == 'outofstock' ? 0 : $limit;
	        
	        $item = '
	        <article data-id="'.$product->ID.'">
                <div class="over '.$selected.'">
                    <img src="'.get_the_post_thumbnail_url($product->ID).'" />
                    
                    <p>'.get_the_title($product->ID).'</p>
                    
                    <div>
                        <span class="pa_product_price">'.$_product->get_price_html().'</span>
                    </div>

					
                </div>
				
				<div id="pa_count">

					<a href="'.get_the_permalink($product->ID).'" target="_blank">
    				    <svg style="position: relative;top: 3px;margin-left: 9px;" width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21 9L21 3M21 3H15M21 3L13 11M10 5H7.8C6.11984 5 5.27976 5 4.63803 5.32698C4.07354 5.6146 3.6146 6.07354 3.32698 6.63803C3 7.27976 3 8.11984 3 9.8V16.2C3 17.8802 3 18.7202 3.32698 19.362C3.6146 19.9265 4.07354 20.3854 4.63803 20.673C5.27976 21 6.11984 21 7.8 21H14.2C15.8802 21 16.7202 21 17.362 20.673C17.9265 20.3854 18.3854 19.9265 18.673 19.362C19 18.7202 19 17.8802 19 16.2V14" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>

					<span class="pa_minus_count">-</span>
					<span class="pa_count_value">'.$quantity.'</span>
					<span data-max="'.$limit.'" class="pa_plus_count">+</span>
				</div>
                
            </article>';

			if($q)
			{
				$selecteds .= $item;
			}
			else {
				$output .= $item;
			}
	        
	    }
	    
	    return $selecteds.$output;
	}
}

new PC_Assemble_Public_Rest();