<?php

class PC_Assemble_Public extends Pa_Assemble
{
	public $mode;

	public function __construct() 
	{
		$this->mode = get_option('pa_display_mode', 'multi-tab');
		add_filter( 'template_include', [$this, 'template_include'], 999999 );
	}

	public function template_include ( $template )
	{
		if( is_singular('pcassemble') )
		{
	        $product = wc_get_product( get_the_id() );
	        $template = dirname(__FILE__) . '/partials/public.php';
	        return $template;
	    }
    
        return $template;
	}

	public function pa_get_categories($sections, $section_id)
	{
		$categories = [];
		
		foreach( $sections as $section ) 
		{
			if( $section->parent == $section_id ) {
				$categories[] = $section;
			}
		}
		return $categories;
	}

	public function pa_get_sections()
	{
		$table = parent::$sections_table;

		$results = parent::$wpdb->get_results("select * from {$table} where status='1' order by id asc");
		$unsets = [];

		foreach( $results as $key=>$section )
		{
			$categories = $this->pa_get_categories($results, $section->id);
			if($section->parent == 0) 
			{
				$results[$key]->categories = $categories;
			}
			else {
				$unsets[] = $key;
			}
		}

		foreach($unsets as $key)
		{
			unset($results[$key]);
		}

		return array_values($results);
	}
	
	public function pa_tabs()
	{
		$output = '<ul id="pa_right_box_tabs">';

			$key = 0;
        
            foreach( $this->pa_get_sections() as $tab )
            {
                $active = $key==0 ? 'active' : '';

				$status = get_post_meta( get_the_id(), 'pa_section_status_'.$tab->id, true);

				if ( $status == '0' ) continue;
                
                $output .= '<li data-tab="'.esc_attr($tab->id).'" class="pa_tab_list '.esc_attr($active).'">'.esc_html($tab->name).'</li>';

				$key ++;
            }
            
        $output .= '</ul>';

		return $output;
	}
	
	public function pa_contents()
	{
		$key = 0;

        foreach($this->pa_get_sections() as $tab )
        {
            $active = $key==0 ? 'active' : '';

			$status = get_post_meta( get_the_id(), 'pa_section_status_'.$tab->id, true);

			if ( $status == '0' || $status == '' ) continue;
            
            echo '<div id="'.esc_attr($tab->id).'" class="pa_tab_content '.esc_attr($active).'"><ul id="pa_tab_content">';
            
            	$this->pa_category($tab->categories, $tab);
                
            echo '</ul></div>';

			$key++;
        }
	}

	private function pa_category_relate_to($category)
	{
		global $wpdb;
		$table = $wpdb->prefix . 'pa_relations';

		$row = $wpdb->get_results( $wpdb->prepare("select * from $table where pa_from='%d' and status='1'", $category) );
		
		if ( ! $row ) return '';

		$output = '';
		foreach( $row as $key=>$category ) 
		{
			if ( $key != 0 ) $output .= '|';
			$output .= $category->pa_to;
		}

		return $output;
	}

	private function pa_category_relate_from ($category)
	{
		global $wpdb;
		$table = $wpdb->prefix . 'pa_relations';

		$row = $wpdb->get_results( $wpdb->prepare("select * from $table where pa_to='%d' and status='1'", $category) );
		
		if ( ! $row ) return '';

		$output = '';
		foreach( $row as $key=>$category ) 
		{
			if ( $key != 0 ) $output .= '|';
			$output .= $category->pa_from;
		}

		return $output;
	}

	public function total_price ()
	{
		$total = 0;

		foreach( $this->pa_get_sections() as $key=>$tab )
        {
			foreach( $tab->categories as $cat )
        	{
				$cat = get_term($cat->category);

				if ( get_post_meta( get_the_id(), 'pa_category_status_'.$cat->term_id, true ) == '0' ) continue;
				$price = 0;

				if ( ! isset( $_GET['pa'] ) )
				{
					$selecteds = get_post_meta( get_the_id(), 'pa_selected_products_'.$cat->term_id, true );

					if( is_array($selecteds) ) 
					{
						foreach( $selecteds as $key=>$item )
						{
							$_product = wc_get_product( $item["product_id"] );
							$price += $_product->get_price() * $item["quantity"];
						}

						$total += $price;
					}
				}
				else 
				{
					global $wpdb;
					$save_table = $wpdb->prefix . 'pa_save';
					$id = sanitize_text_field( $_GET['pa'] );
					$res = $wpdb->get_row("select * from $save_table where id='$id'");
					$data = isset($res->data) ? unserialize($res->data) : [];

					
					
					foreach( $data as $item )
					{
						if ( $item['cat'] == $cat->term_id ) 
						{
							$exp = explode('|', $item['value']);

							foreach($exp as $exp_item)
							{
								$exp2 = explode(',', $exp_item);
								$_product = wc_get_product($exp2[0]);

								$total += $_product->get_price() * $exp2[1];
							}
						}
							
					}
				}
			}
		}
		return $total;
	}
	
	private function pa_category($categories, $section)
	{
		$total = 0;

	    foreach( $categories as $item )
        {
            $cat = get_term($item->category);

			$status = get_post_meta( get_the_id(), 'pa_category_status_'.$cat->term_id, true );

			if ( $status != '1' && $status != '' ) continue;
            
            $thumbnail_id 	= get_term_meta( $cat->term_id, 'thumbnail_id', true );
            $thumbnail 		= wp_get_attachment_url( $thumbnail_id );

			$relate_to = $this->pa_category_relate_to( $cat->term_id );

			$relate_from = $this->pa_category_relate_from( $cat->term_id );

            echo '<li data-choice="'.esc_attr($item->pa_select).'" data-relate-to="'.esc_attr($relate_to).'" data-relate-from="'.esc_attr($relate_from).'" class="pa_tab" data-title="'.esc_attr($cat->name).'" data-id="'.esc_attr($cat->term_id).'">';

                echo '<div>';
					$design = (array) get_option('_pa_design_settings');
                    echo isset($design['display_category_image']) && $design['display_category_image'] == 'on' && $thumbnail ? '<img src="'.esc_attr($thumbnail).'" width="20" />' : '';
					echo $section->mandatory == 1 || $item->mandatory == 1 ? '<span class="span_mandatory">* </span>' : '';
                    echo esc_html($item->name);
                echo '</div>';
				
				$selected = '';
				$title = '';
				$price = 0;

				if ( ! isset($_GET['pa']) )
				{
					$selecteds = get_post_meta( get_the_id(), 'pa_selected_products_'.$cat->term_id, true );
					
					if( is_array($selecteds) ) 
					{
						foreach( $selecteds as $key=>$item2 )
						{
							$_product = wc_get_product( $item2["product_id"] );
							$price += $_product->get_price() * $item2["quantity"];

							if ( $key != 0 ) { 
								$selected .= '|';
								$title .= '، ';
							}
							$selected .= $item2["product_id"].','.$item2["quantity"];

							$title .= get_the_title($item2["product_id"]) . ' ('.$item2["quantity"] .' '. __("X", "assemble").')';
						}
					}

				}

				else 
				{
					global $wpdb;
					$save_table = $wpdb->prefix . 'pa_save';
					$id = sanitize_text_field( $_GET['pa'] );
					$res = $wpdb->get_row("select * from $save_table where id='$id'");
					$data = isset($res->data) ? unserialize($res->data) : [];
					
					foreach( $data as $item3 )
					{
						if ( $item3['cat'] == $cat->term_id ) 
						{
							$selected = $item3['value'];
							$exp = explode('|', $item3['value']);

							foreach($exp as $exp_item)
							{
								$exp2 = explode(',', $exp_item);

								$title .= get_the_title($exp2[0]) . ' (X'.$exp2[1].')';
								$_product = wc_get_product( $exp2[0] );
								$price += $_product->get_price() * $exp2[1];
							}
						}
							
					}
				}
				
				$total += $price;

				$price = $price == 0 ? $price : number_format($price);

				$mandatory = 0;
				if ( $section->mandatory == 1 || $item->mandatory == 1 ) $mandatory = 1;

				echo '<input name="pa_selecteds_'.esc_attr($cat->term_id).'" value="'.esc_attr($selected).'" type="hidden" class="pa_selected_components" data-cat="'.esc_attr($cat->term_id).'" data-catTitle="'.esc_attr($cat->name).'" data-mandatory="'.esc_attr($mandatory).'" />';

				echo '<input type="hidden" data-cat="'.esc_attr($cat->term_id).'" class="pa_relation" />';

                echo '<div data-cat="'.esc_attr($cat->term_id).'" class="second_show_article">';
                
				$hidden = $price == 0 ? '' : 'display: none;';
                echo '<strong data-cat="'.esc_attr($cat->term_id).'" class="pa_selected_empty" style="color: lawngreen; '.esc_attr($hidden).'">'.esc_html__("Not Selected", "assemble").'</strong>';
				echo '<strong data-cat="'.esc_attr($cat->term_id).'" class="pa_selected_components_title">'.esc_html($title).'</strong>';
                echo '<span data-cat="'.esc_attr($cat->term_id).'" class="pa_single_component_price"> '.esc_html($price).' ' . esc_html(get_woocommerce_currency_symbol()) . '</span>';
                echo '</div>';
            echo '</li>';
        }
	}

	public function mode_styles ()
	{
		$design = (array) get_option('_pa_design_settings');

		if ( $this->mode == 'one-column' ):

		$category_item_border_bottom  = isset($design['category_item_border_bottom']) ? $design['category_item_border_bottom'] : '1px dashed #333';
		?>
		<style>
		.pa_tab_content {
			padding-top: 0;
		}
		.pa_tab_content {
			display: block;
		}
		#pa_tab_content {
			border-bottom: <?php echo esc_attr($category_item_border_bottom); ?>;
		}
		</style>
		<?php
		endif;

		$bg_image = isset($design['background_image']) ? $design['background_image'] : '';
		$bg_color = isset($design['background_color']) ? $design['background_color'] : '';
		$bg_fixed = isset($design['fix_background_image']) ? $design['fix_background_image'] : false;

		$categories_box_shadow = isset($design['categories_box_shadow']) ? $design['categories_box_shadow'] : '';

		$category_bg_image = isset($design['categories_background_image']) ? $design['categories_background_image'] : false;
		$category_bg_color = isset($design['categories_background_color']) ? $design['categories_background_color'] : '';
		$category_border = isset($design['categories_border']) ? $design['categories_border'] : '';
		$categories_item_hover_background = isset($design['categories_item_hover_background']) ? $design['categories_item_hover_background'] : '';
		$category_title_color = isset($design['category_title_color']) ? $design['category_title_color'] : '';
		$category_title_font_size = isset($design['category_title_font_size']) ? $design['category_title_font_size'] : '';
		$category_item_selected_color = isset($design['category_item_selected_color']) ? $design['category_item_selected_color'] : '';
		$category_item_selected_font_size = isset($design['category_item_selected_font_size']) ? $design['category_item_selected_font_size'] : '';
		$category_item_price_color = isset($design['category_item_price_color']) ? $design['category_item_price_color'] : '';
		$category_item_price_font_size = isset($design['category_item_price_font_size']) ? $design['category_item_price_font_size'] : '';
		$category_item_border_bottom  = isset($design['category_item_border_bottom']) ? $design['category_item_border_bottom'] : '';

		$tab_background_color = isset($design['tab_background_color']) ? $design['tab_background_color'] : '';
		$tab_color = isset($design['tab_color']) ? $design['tab_color'] : '';
		$tab_border = isset($design['tab_border']) ? $design['tab_border'] : '';
		$tab_hover_color = isset($design['tab_hover_color']) ? $design['tab_hover_color'] : '';
		$tab_font_size = isset($design['tab_font_size']) ? $design['tab_font_size'] : '';

		$category_not_selected_color = isset($design['category_not_selected_color']) ? $design['category_not_selected_color'] : '';
		$category_not_selected_font_size = isset($design['category_not_selected_font_size']) ? $design['category_not_selected_font_size'] : '';

		$thumbnail_width = isset($design['thumbnail_width']) ? $design['thumbnail_width'] : '';
		$product_summary_background_color = isset($design['product_summary_background_color']) ? $design['product_summary_background_color'] : '';
		$product_summary_border = isset($design['product_summary_border']) ? $design['product_summary_border'] : '';
		$product_title_color = isset($design['product_title_color']) ? $design['product_title_color'] : '';
		$product_title_font_size = isset($design['product_title_font_size']) ? $design['product_title_font_size'] : '';
		$product_summary_box_shadow = isset($design['product_summary_box_shadow']) ? $design['product_summary_box_shadow'] : '';

		$total_price_text_color = isset($design['total_price_text_color']) ? $design['total_price_text_color'] : '';
		$total_price_text_font_size = isset($design['total_price_text_font_size']) ? $design['total_price_text_font_size'] : '';
		$total_price_color = isset($design['total_price_color']) ? $design['total_price_color'] : '';
		$total_price_font_size = isset($design['total_price_font_size']) ? $design['total_price_font_size'] : '';

		$add_to_cart_button_color = isset($design['add_to_cart_button_color']) ? $design['add_to_cart_button_color'] : '';
		$add_to_cart_button_font_size = isset($design['add_to_cart_button_font_size']) ? $design['add_to_cart_button_font_size'] : '';
		$add_to_cart_button_background = isset($design['add_to_cart_button_background']) ? $design['add_to_cart_button_background'] : '';
		$add_to_cart_button_padding = isset($design['add_to_cart_button_padding']) ? $design['add_to_cart_button_padding'] : '';
		$add_to_cart_button_hover_background = isset($design['add_to_cart_button_hover_background']) ? $design['add_to_cart_button_hover_background'] : '';
		$add_to_cart_button_hover_color = isset($design['add_to_cart_button_hover_color']) ? $design['add_to_cart_button_hover_color'] : '';

		$social_icon_color = isset($design['social_icon_color']) ? $design['social_icon_color'] : '';
		$social_icon_background_color = isset($design['social_icon_background_color']) ? $design['social_icon_background_color'] : '';
		$social_icon_width = isset($design['social_icon_width']) ? $design['social_icon_width'] : '';
		$social_icon_padding = isset($design['social_icon_padding']) ? $design['social_icon_padding'] : '';
		$social_icon_border = isset($design['social_icon_border']) ? $design['social_icon_border'] : '';

		$required_category_error_color = isset($design['required_category_error_color']) ? $design['required_category_error_color'] : '';
		$required_category_error_font_size = isset($design['required_category_error_font_size']) ? $design['required_category_error_font_size'] : '';
		$required_category_error_border = isset($design['required_category_error_border']) ? $design['required_category_error_border'] : '';
		$required_category_error_background = isset($design['required_category_error_background']) ? $design['required_category_error_background'] : '';
		$required_category_error_items_color = isset($design['required_category_error_items_color']) ? $design['required_category_error_items_color'] : '';

		?>

		<style>

		.not_selected_categories div {
			<?php if($required_category_error_font_size): ?>font-size: <?php echo esc_html($required_category_error_font_size) . ';'; endif; ?>
			<?php if($required_category_error_border): ?>border: <?php echo esc_html($required_category_error_border) . ';'; endif; ?>
		}

		.not_selected_categories div span.title {
			<?php if($required_category_error_color): ?>color: <?php echo esc_html($required_category_error_color) . ';'; endif; ?>
		}

		.not_selected_categories div span.items {
			<?php if($required_category_error_items_color): ?>color: <?php echo esc_html($required_category_error_items_color) . ';'; endif; ?>
		}

		.pc_assemble_export svg {
			<?php if($social_icon_background_color): ?>background: <?php echo esc_html($social_icon_background_color) . ';'; endif; ?>
			<?php if($social_icon_border): ?>border: <?php echo esc_html($social_icon_border) . ';'; endif; ?>
			<?php if($social_icon_width): ?>width: <?php echo esc_html($social_icon_width) . '; height: '.esc_html($social_icon_width) .';'; endif; ?>
			<?php if($social_icon_padding): ?>padding: <?php echo esc_html($social_icon_padding) . ';'; endif; ?>
		}

		#pa_left_add_to_cart:hover {
			<?php if($add_to_cart_button_hover_background): ?>background: <?php echo esc_html($add_to_cart_button_hover_background) . ';'; endif; ?>
			<?php if($add_to_cart_button_hover_color): ?>color: <?php echo esc_html($add_to_cart_button_hover_color) . ';'; endif; ?>
		}
		#pa_left_add_to_cart {
			<?php if($add_to_cart_button_color): ?>color: <?php echo esc_html($add_to_cart_button_color) . ';'; endif; ?>
			<?php if($add_to_cart_button_font_size): ?>font-size: <?php echo esc_html($add_to_cart_button_font_size) . ';'; endif; ?>
			<?php if($add_to_cart_button_background): ?>background: <?php echo esc_html($add_to_cart_button_background) . ';'; endif; ?>
			<?php if($add_to_cart_button_padding): ?>padding: <?php echo esc_html($add_to_cart_button_padding) . ';'; endif; ?>
		}
		#pa_left_price_title {
			<?php if($total_price_text_color): ?>color: <?php echo esc_html($total_price_text_color) . ';'; endif; ?>
			<?php if($total_price_text_font_size): ?>font-size: <?php echo esc_html($total_price_text_font_size) . ';'; endif; ?>
		}
		#pa_left_price {
			<?php if($total_price_color): ?>color: <?php echo esc_html($total_price_color) . ';'; endif; ?>
			<?php if($total_price_font_size): ?>font-size: <?php echo esc_html($total_price_font_size) . ';'; endif; ?>
		}
		body {
			background: url(<?php echo esc_html($bg_image); ?>), <?php echo esc_html($bg_color); ?>;
			background-attachment: <?php echo $bg_fixed == 'on' ? esc_html('fixed') : ''; ?>;
		}
		#pa_content_wrapper
		{
			<?php if($category_bg_image!=''): ?>background: url(<?php echo esc_html($category_bg_image); ?>), <?php echo esc_html($category_bg_color) . ';'; endif; ?>
			<?php if($category_bg_color!=''): ?>background-color: <?php echo esc_html($category_bg_color) . ';'; endif; ?>
			<?php if($category_border): ?>border: <?php echo esc_html($category_border) . ';'; endif; ?>
			<?php if($categories_box_shadow): ?>box-shadow: <?php echo esc_html($categories_box_shadow) . ';'; endif; ?>
		}

		#pa_right_box_tabs {
			<?php if($tab_background_color): ?>background: <?php echo esc_html($tab_background_color) . ';'; endif; ?>
			<?php if($tab_border): ?>border: <?php echo esc_html($tab_border) . ';'; endif; ?>
		}

		#pa_right_box_tabs>li {
			<?php if($tab_color): ?>color: <?php echo esc_html($tab_color) . ';'; endif; ?>
			<?php if($tab_font_size): ?>font-size: <?php echo esc_html($tab_font_size) . ';'; endif; ?>
		}

		#pa_tab_content li {
			<?php if($category_item_border_bottom): ?>border-bottom: <?php echo esc_html($category_item_border_bottom) . ';'; endif; ?>
		}

		#pa_right_box_tabs>li.active {
			<?php if($tab_hover_color): ?>
			color: <?php echo esc_html($tab_hover_color); ?>;
    		border: 1px solid <?php echo esc_html($tab_hover_color); ?>;
			<?php endif; ?>
		}

		#pa_right_box_tabs>li:hover {
			<?php if($tab_hover_color): ?>
			color: <?php echo esc_html($tab_hover_color); ?>;
			<?php endif; ?>
		}

		#pa_tab_content li:hover {
			<?php if($categories_item_hover_background): ?>background: <?php echo esc_html($categories_item_hover_background) . ';'; endif; ?>
		}

		#pa_tab_content li>div {
			<?php if($category_title_color): ?>color: <?php echo esc_html($category_title_color) . ';'; endif; ?>
			<?php if($category_title_font_size): ?>font-size: <?php echo esc_html($category_title_font_size) . ';'; endif; ?>
		}

		.pa_selected_components_title {
			<?php if($category_item_selected_color): ?>color: <?php echo esc_html($category_item_selected_color) . ';'; endif; ?>
			<?php if($category_item_selected_font_size): ?>font-size: <?php echo esc_html($category_item_selected_font_size) . ';'; endif; ?>
		}

		.pa_single_component_price {
			<?php if($category_item_price_color): ?>color: <?php echo esc_html($category_item_price_color) . ' !important;'; endif; ?>
			<?php if($category_item_price_font_size): ?>font-size: <?php echo esc_html($category_item_price_font_size) . ';'; endif; ?>
		}

		.pa_selected_empty {
			<?php if($category_not_selected_color): ?>color: <?php echo esc_html($category_not_selected_color) . ' !important;'; endif; ?>
			<?php if($category_not_selected_font_size): ?>font-size: <?php echo esc_html($category_not_selected_font_size) . ';'; endif; ?>
		}

		#left_img {
			<?php if($thumbnail_width): ?>width: <?php echo esc_html($thumbnail_width) . ';'; endif; ?>
		}

		#pa_left_box {
			<?php if($product_summary_background_color): ?>background-color: <?php echo esc_html($product_summary_background_color) . ';'; endif; ?>
			<?php if($product_summary_border): ?>border: <?php echo esc_html($product_summary_border) . ';'; endif; ?>
			<?php if($product_summary_box_shadow): ?>box-shadow: <?php echo esc_html($product_summary_box_shadow) . ';'; endif; ?>
		}

		#pa_left_sticky h2 {
			<?php if($product_title_color): ?>color: <?php echo esc_html($product_title_color) . ';'; endif; ?>
			<?php if($product_title_font_size): ?>font-size: <?php echo esc_html($product_title_font_size) . ';'; endif; ?>
		}

		</style>

		<?php
	}

}

new PC_Assemble_Public();
