jQuery(document).ready(function($)
{
	var currency_symbol = $("#currency_symbol").val();
	var x = $('#x').val();

    $(document).on('click', '#pa_popup_close, .pa_popup_confirm', function()
    {
        $('.pa_products_popup').fadeOut();
    });
    
    $(document).on('click', '#pa_products article .over', function()
    {
		var max = $(this).parent().find('.pa_plus_count').attr('data-max');
		if ( max == '0' )
		{
			alert( $('#outofstock_translate').val() );
			return;
		}

        var cat = $('.pa_products_popup').attr('data-cat');
        
        if( $('.pa_products_popup').attr('data-choice') == 'single' )
        {
            $('#pa_products article .over').not(this).removeClass('selected');
            $('#pa_products article .over').parent().find('.pa_count_value').text(0);
            
            $(this).toggleClass('selected');

            var val = $(this).hasClass('selected') ? 1 : 0;
            $(this).parent().find('.pa_count_value').text(val);
            
            var end = $(this).parent().find('.pa_count_value').html() == 1 ? $(this).parent().attr('data-id') + ',' + $(this).parent().find('.pa_count_value').html() : '';
        }
        else {
            $(this).toggleClass('selected');
            var val = $(this).hasClass('selected') ? 1 : 0;
            $(this).parent().find('.pa_count_value').text(val);
            
            
            var end = '';
            $('.over.selected').each( function(i) 
            {
                    if(i!=0) end += '|';
                    end +=  $(this).parent().attr('data-id') + ',' +  $(this).parent().find('.pa_count_value').html();
            });
        }
        
        var cat = $('.pa_products_popup').attr('data-cat');
        $('.pa_products_popup .pa_component_price').val( end );

		var total = pa_collect_selected_total();
		total.push( { cat: cat, value: end } );

		// $('.pa_component_price').val( end );
		var baseUrl = $('#home_url').val();
		$.ajax({
        	type: "POST",
        	url: baseUrl + "/wp-json/pa/getComponentPrice", 
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			},     
        	data: { 
        		data: end,
				total: total
        	},
        	success: function(data) { 
				$('.pa_popup_component_total_price span').text(data.price + ' ' + currency_symbol);
				$('.pa_popup_system_total_price span, .pa_left_price').text(data.total + ' ' + currency_symbol);
			},
        	dataType: "json"               
        });
        
        // pa_selected(end);
    });
    
    function pa_selected(end,cat)
    {
        if( end == '' )
        {
            $('.pa_selected').html('');
        }
        else 
        {
            var select = end.split("|");
            var selected = '';
            select.forEach((e,i) => {
                var selection = e.split(",");
                if(i!=0) selected += ', ';
                selected += returnTitle(selection[0]) + ' (' + selection[1]+x+')';
            });
            $('.pa_tab[data-id='+cat+'] .pa_selected_components_title').html(selected);
        }
    }
    
    $(document).on('click', '.pa_minus_count', function()
    {
        var newVal = Number( $(this).parent().find('.pa_count_value').text() ) - 1;
        if( newVal>= 0 ){
            $(this).parent().find('.pa_count_value').text( Number( $(this).parent().find('.pa_count_value').text() ) - 1 );
        }
        if( newVal == 0 )
        {
            $(this).parent().parent().find('.over').removeClass('selected');
        }
        
        var cat = $('.pa_products_popup').attr('data-cat');
		var end = '';
        if( $('.pa_products_popup').attr('data-choice') == 'single' )
        {
			var count = $(this).parent().find('.pa_count_value').html();
			if(count!=0)
            	end =  $(this).parent().parent().attr('data-id') + ',' + $(this).parent().find('.pa_count_value').html();
        }
        else 
        {
            var end = '';
            $('.over.selected').each( function(i) 
            {
                if(i!=0) end += '|';
                end +=  $(this).parent().attr('data-id') + ',' +  $(this).parent().find('.pa_count_value').html();
            });
        }
        
        $('.pa_products_popup .pa_component_price').val( end );

		var total = pa_collect_selected_total();
		total.push( { cat: cat, value: end } );

		// $('.pa_component_price').val( end );
		var baseUrl = $('#home_url').val();
		$.ajax({
        	type: "POST",
        	url: baseUrl + "/wp-json/pa/getComponentPrice",  
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			},    
        	data: { 
        		data: end,
				total: total
        	},
        	success: function(data) { 
				$('.pa_popup_component_total_price span').text(data.price + ' ' + currency_symbol);
				$('.pa_popup_system_total_price span').text(data.total + ' ' + currency_symbol);
			},
        	dataType: "json"               
        });
    });
    
    $(document).on('click', '.pa_plus_count', function()
    {
		var max = $(this).attr('data-max');

		if ( max == '0' )
		{
			alert( $('#outofstock_translate').val() );
			return;
		}

		var newVal = Number( $(this).parent().find('.pa_count_value').text() ) + 1;
		if( max!='' && max < newVal ) return;

        if( $('.pa_products_popup').attr('data-choice') == 'single' )
        {
            $('.pa_plus_count').not(this).parent().find('.pa_count_value').text( 0 );
            $('.pa_plus_count').not(this).parent().parent().find('.over').removeClass('selected');
        }

        $(this).parent().find('.pa_count_value').text( newVal );
        if(newVal==1) 
        {
            $(this).parent().parent().find('.over').addClass('selected');
        }
        
        var cat = $('.pa_products_popup').attr('data-cat');
		var end = '';
        if( $('.pa_products_popup').attr('data-choice') == 'single' )
        {
			var count = $(this).parent().find('.pa_count_value').html();
			if(count!=0)
            	end =  $(this).parent().parent().attr('data-id') + ',' + $(this).parent().find('.pa_count_value').html();
        }
        else 
        {
            var end = '';
            $('.over.selected').each( function(i) 
            {
                if(i!=0) end += '|';
				var count = $(this).parent().find('.pa_count_value').html();
				if(count!=0)
                	end +=  $(this).parent().attr('data-id') + ',' +  $(this).parent().find('.pa_count_value').html();
            });
        }
        
        $('.pa_products_popup .pa_component_price').val( end );

		var total = pa_collect_selected_total();
		total.push( { cat: cat, value: end } );

		// $('.pa_component_price').val( end );
		var baseUrl = $('#home_url').val();
		$.ajax({
        	type: "POST",
        	url: baseUrl + "/wp-json/pa/getComponentPrice",
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			},  
        	data: { 
        		data: end,
				total: total
        	},
        	success: function(data) { 
				$('.pa_popup_component_total_price span').text(data.price + ' ' + currency_symbol);
				$('.pa_popup_system_total_price span').text(data.total + ' ' + currency_symbol);
			},
        	dataType: "json"               
        });
    });

	$(document).on('change', '.pa_popup_search_by_order', function()
	{
		var plugins_url = $('#plugin_url').val();
		$('#pa_products').html('<img class="pa_popup_loader" width="70" src="'+plugins_url+'public/images/loader3.webp" />');

		var baseUrl = $('#home_url').val();
		
		const term_id = $('.pa_products_popup').attr('data-cat');

		var selected = $(this).find(":selected").val();

        $.ajax({
        	type: "POST",
        	url: baseUrl + "/wp-json/pa/readProducts",
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			},     
        	data: { 
        		term_id: term_id,
				selected: $('.pa_products_popup').find('.pa_component_price').val(),
				order: selected,
				system_id: $('#system_id').val()
        	},
        	success: function(data) { $('#pa_products').html(data) },
        	dataType: "json"               
        });
	});

	function pa_collect_selected_total(nocat=true)
	{
		var total = [];
		$('.pa_tab input.pa_selected_components').each( function()
		{
			var cat = $(this).attr('data-cat');
			var value = $(this).val();
			var popup_cat = $('.pa_products_popup').attr('data-cat');

			if( value!='' ) 
			{
				if(nocat) {
					if(cat != popup_cat)
						total.push( { cat: cat, value: value } );
				}
				else {
					total.push( { cat: cat, value: value } );
				}
					
			}
		});

		return total;
	}

	$(document).on('click', '.pa_popup_apply_btn', function()
	{
		// Hide pupop
		$('.pa_products_popup').fadeOut(150);

		// Insert popup selected products in tab
		const cat = $('.pa_products_popup').attr('data-cat');
		$('.pa_tab[data-id='+cat+'] .pa_selected_components').val( $('.pa_component_price').val() );

		if ( $('.pa_tab[data-id='+cat+'] .pa_selected_components').val() != '' )
		{
			$('.pa_tab[data-id='+cat+']').removeClass('mandatory');
		}


		var end = $('.pa_component_price').val();
		// Display product in tab and hide nothing
		if( end !='' ) {
			pa_selected(end,cat);
			$('.pa_tab[data-id='+cat+'] .pa_selected_empty').fadeOut(1);
		}

		// Display nothing and hide products in tab if not select
		else {
			$('.pa_tab[data-id='+cat+'] .pa_selected_empty').fadeIn(1);
			$('.pa_tab[data-id='+cat+'] .pa_selected_components_title').text('');
		}

		// display loader to calculate tab and total prices
		$('#pa_left_price').text( '...' );
		$('.pa_tab[data-id='+cat+'] .pa_single_component_price').text( '...' );

		// total selected products
		var total = pa_collect_selected_total(false);

		// check relate to
		var relate_to = $('.pa_tab[data-id='+cat+']').attr('data-relate-to');
		var sp = relate_to.split("|");

		var sp = sp.filter(function (el) {
			return el != "";
		});

		var to = [];
		sp.forEach( e => 
		{
			to.push({
				'id'	: e,
				'value'	: $('.pa_selected_components[data-cat='+e+']').val()
			});
		});

		var baseUrl = $('#home_url').val();
		$.ajax({
			type: "POST",
			url: baseUrl + "/wp-json/pa/getComponentPrice",   
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			},   
			data: { 
				data: end,
				total: total,
				to: to,
				cat: cat
			},
			success: function(data) 
			{ 
				$('.pa_tab[data-id='+cat+'] .pa_single_component_price').text( data.price + ' ' + currency_symbol );
				$('#pa_left_price, .pa_left_price2').text( data.total + ' ' + currency_symbol );

				if ( data.filter.length > 0 )
				{
					data.filter.forEach( e => 
					{
						$('.pa_selected_components_title[data-cat='+e.cat+']').text(e.title);
						$('.pa_single_component_price[data-cat='+e.cat+']').text(e.total +' '+ currency_symbol);
						$('.pa_selected_components[data-cat='+e.cat+']').val(e.selected);

						if ( e.selected == '' )
							$('.pa_selected_empty[data-cat='+e.cat+']').fadeIn();
					});
				}

				if ( data.changeImage != '' )
				{
					$('#left_img').attr('src', data.changeImage);
				}
				
			},
			dataType: "json"               
		});
		
	});
    
    function returnTitle(id){
        return $('#pa_products article[data-id="'+id+'"]').find('p').text();
    }
    
    $(document).on('click', '.pa_tab', function()
    {
        $('.pa_products_popup').fadeIn(200);
		$('.pa_popup_search_by_order').css('color', 'slategrey');
        $('.pa_popup_title').text( $(this).data('title') );
        
        $('.pa_products_popup').attr('data-choice', $(this).data('choice'));
        $('.pa_products_popup').attr('data-cat', $(this).data('id'));
        
        const term_id = $(this).data('id');
		const plugins_url = $('#plugin_url').val();
		
		$('.pa_component_price').val( $('.pa_selected_components[data-cat='+term_id+']').val() );
        
        $('#pa_products').html('<img class="pa_popup_loader" width="70" src="'+plugins_url+'public/images/loader3.webp" />');

		$('.pa_popup_component_total_price span').text( $(this).find('.pa_single_component_price').text() );
		$('.pa_popup_system_total_price span').text( $('#pa_left_price').text() );

		var fromThis = $('.pa_tab[data-id='+term_id+']').attr('data-relate-from');

		var data = [];

		if ( fromThis != '' ) 
		{
			fromThis = fromThis.split("|");

			fromThis.forEach( e => 
			{
				data.push({ name : e, value: $('.pa_selected_components[data-cat='+e+']').val() } );
			});
		}

		var baseUrl = $('#home_url').val();
        $.ajax({
        	type: "POST",
        	url: baseUrl + "/wp-json/pa/readProducts",
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#wp_rest').val() );
			}, 
        	data: { 
        		term_id: term_id,
				selected: $(this).find('.pa_selected_components').val(),
				system_id: $('#system_id').val(),
				relations: data
        	},
        	success: function(data) { $('#pa_products').html(data) },
        	dataType: "json"               
        });
    });

	$(document).on('input', '#pa_popup_search', function()
	{
		const key 		= $(this).val();
		var baseUrl 	= $('#home_url').val();
		const term_id 	= $('.pa_products_popup').attr('data-cat');
		const plugins_url = $('#plugin_url').val();

		$('#pa_products').html('<img class="pa_popup_loader" width="70" src="'+plugins_url+'public/images/loader3.webp" />');

		var fromThis = $('.pa_tab[data-id='+term_id+']').attr('data-relate-from');

		var data = [];

		if ( fromThis != '' ) 
		{
			fromThis = fromThis.split("|");

			fromThis.forEach( e => 
			{
				data.push({ name : e, value: $('.pa_selected_components[data-cat='+e+']').val() } );
			});
		}
        
        $.ajax({
        	type: "POST",
        	url: baseUrl + "/wp-json/pa/readProducts",
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			},   
        	data: { 
        		term_id: term_id,
				key: key,
				system_id: $('#system_id').val(),
				relations: data
        	},
        	success: function(data) { $('#pa_products').html(data) },
        	dataType: "json"               
        });
	})

	$(document).on('click', '.pa_tab_list', function()
	{
		$('.pa_tab_list').removeClass('active');
		$(this).addClass('active');

		$('.pa_tab_content').removeClass('active');
		const id = $(this).attr('data-tab');
		$('.pa_tab_content[id='+id+']').addClass('active');
	})

	$(document).on('click', '.pa_products_popup_box' , function() {
		// if (e.target !== this) return

		// $('.pa_products_popup').fadeOut()
	});

	$(document).on('click', '.pa_share .close', function(){
		$('.pa_share').fadeOut();
	});

	$(document).on('click', '.pc_assemble_export_share', function()
	{
		var save = [];

		$('.pa_selected_components').each(function()
		{
			if ( $(this).val() != '' )
				save.push({ 'cat': $(this).attr('data-cat'), 'value': $(this).val() });
		});

		if ( save.length == 0 )
		{
			$('.pa_share').fadeIn(100);
			var save_translate = $('#save_share_translate').val();
			$('.pa_share_box').html('<input type="text" readonly value="'+window.location.href+'" /> <div class="expiration">'+save_translate+'</div>');
			return;
		}

		$('.pa_share').fadeIn(100);

		const plugins_url = $('#plugin_url').val();
		$('.pa_share_box').html('<img style="margin: 0 auto" class="pa_popup_loader" width="70" src="'+plugins_url+'public/images/loader3.webp" />');
		
		$.ajax({
        	type: "POST",
        	url: $('#home_url').val() + "/wp-json/pa/saveBuild", 
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			},     
        	data: { 
        		assemble_id: $('#system_id').val(),
				data: save
        	},
        	success: function(data) 
			{ 
			    var save_translate = $('#save_share_translate').val();
				$('.pa_share_box').html('<input type="text" readonly value="'+data+'" /> <div class="expiration">'+save_translate+'</div>');
			},
        	dataType: "json"               
        });
	});

	function copyToClipboard(element) {
		$(element).select();
	}

	$(document).on('focus', ".pa_share_box input", function()
	{
		var copyText = $(".pa_share_box input[type='text']");
        copyToClipboard(copyText);
	});

	$(document).on('click', '.pc_assemble_export_print', function()
	{
		var save = [];

		$('.pa_selected_components').each(function()
		{
			if ( $(this).val() != '' )
				save.push({ 'cat': $(this).attr('data-cat'), 'value': $(this).val() });
		});

		if ( save.length == 0 ) 
		{
			alert('No Components Selected');
			return;
		}

		$('.pa_parent').fadeIn();

		$.ajax({
        	type: "POST",
        	url: $('#home_url').val() + "/wp-json/pa/getComponentRealData",
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'P-NONCE', $('#pa_nonce').val() );
			}, 
        	data: {
        		data: save,
				assemble_id: $('#system_id').val()
        	},
        	success: function(data) 
			{
				$('.pa_parent').fadeOut();
				
				
				var align = $('#is_rtl').val();
				
				var mywindow = window.open('', 'PRINT');

				mywindow.document.write('<html><head><title>' + data.page_title  + '</title>');
				
				var website = $('#pa_website').val();
				var build_url = $('#pa_build_url').val();
				
				var product = $('#pa_product').val();
				var category = $('#pa_category').val();
				var quantity = $('#pa_quantity').val();
				var price = $('#pa_price').val();
				var subtotal = $('#pa_subtotal').val();
				var total = $('#pa_total').val();
				
				if ( align == '1' ) 
				{
				    mywindow.document.write('<style>body{direction: rtl; text-align: right;} td,th{ text-align: right !important; padding: 15px 15px !important; } img {margin-right: 0 !important; margin-left: 10px !important;}');
				}
				
				mywindow.document.write('<style>table tr:first-child {font-weight: bold} table {border-collapse: collapse; width: 100%} td {width: 15%; border: 1px solid #ccc; text-align: center; padding: 10px 0; color: #000; font-size: 13px} tr td:first-child { width: 40%; text-align: left; padding-left: 10px }.text-right {text-align: right; padding-right: 20px} p {font-size: 12px} img {vertical-align: middle; margin-right: 15px} .text-center { text-align: center !important }</style></head><body>');
				mywindow.document.write('<p>'+website+': '+$("#home_url").val()+'</p>');
				
				if ( data.build_url != undefined )
				{
					mywindow.document.write('<p>'+build_url+': <a href="'+data.build_url+'">'+data.build_url+'</a></p>');
				}
				
				mywindow.document.write('<h4>' + data.page_title  + '</h4>');

				mywindow.document.write('<table><tbody><tr><td>'+product+'</td><td>'+category+'</td><td>'+quantity+'</td><td>'+price+'</td><td class="text-right">'+subtotal+'</td></tr>');
				mywindow.document.write(data.rows);
				mywindow.document.write('<tr><td colspan="2" class="text-center"><strong>'+total+'</strong></td><td><strong>'+data.quantity+'</strong></td><td colspan="2" class="text-right"><strong>'+data.total+'</strong></td></tr>');
				mywindow.document.write('</tbody></table></body></html>');

				mywindow.document.close();
				mywindow.focus();

				setTimeout(function() {
					mywindow.print();
					mywindow.close();
				}, 1000);
			},
        	dataType: "json"
        });
	});


	$('.pa_form').submit(function()
	{
	    var required_category = $('#pa_required_category').val();
		var x = 0;
		var error = '<div> <span class="title">'+required_category+':</span> <span class="items">';

		$('.pa_selected_components').each(function()
		{
			if ( $(this).attr('data-mandatory') == '1' && $(this).val() == '' )
			{
				var cat = $(this).attr('data-cat');
				$('.pa_tab[data-id="'+cat+'"]').addClass('mandatory');
				
				if ( x != 0 )
				error += ', ';

				x++;

				error += $(this).attr('data-catTitle');
			}
				
		});

		error += '</span></div>';

		if ( x != 0 ) 
		{
			$('.not_selected_categories').html( error );
			return false;
		}

		$('.pa_parent').fadeIn();
	});


});