<?php $public = new PC_Assemble_Public(null, null); ?>
<!-- PC assemble plugin -->
<!DOCTYPE html>
<html>
  <head>
	<link rel="stylesheet" href="<?php echo esc_url( PA_PUBLIC_URL .'/css/style.css'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="UTF-8">
	<title><?php echo esc_html(get_the_title()) . ' - ' . esc_html(get_bloginfo('title')); ?></title>

	<?php echo $public->mode_styles(); ?>

	<?php 
	if ( ! is_rtl() ) {
		?>
		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400&display=swap" rel="stylesheet">	

		<style>
			body, input, button {
				font-family: Roboto;
			}
		</style>
		<?php
	}
	else {
		?>
		<link rel="stylesheet" href="<?php echo esc_url( PA_PUBLIC_URL . '/css/style_rtl.css' ); ?>" />
		<style>
			body, input, button {
				font-family: iranyekanweblightfanum;
				font-weight: bold;
			}
		</style>
		<?php
	}
	?>
  </head>
  <?php if( get_option('pa_display_header') == 1 ): get_header(); endif; ?>
  <body class="noselect">

	<!--Translates -->
	<input type="hidden" id="outofstock_translate" value="<?php esc_html_e('This product is out of stock and cannot be selected.', 'assemble'); ?>" />
	<input type="hidden" id="save_share_translate" value="<?php esc_html_e('Save your build link and share with others!', 'assemble'); ?>" />
	<input type="hidden" id="is_rtl" value="<?php echo esc_attr(is_rtl()); ?>" />
	<input type="hidden" id="pa_website" value="<?php esc_html_e('Website', 'assemble'); ?>" />
	<input type="hidden" id="pa_build_url" value="<?php esc_html_e('Assemble Link', 'assemble'); ?>" />
	
	<input type="hidden" id="pa_product" value="<?php esc_html_e('Product', 'assemble'); ?>" />
	<input type="hidden" id="pa_category" value="<?php esc_html_e('Category', 'assemble'); ?>" />
	<input type="hidden" id="pa_quantity" value="<?php esc_html_e('Quantity', 'assemble'); ?>" />
	<input type="hidden" id="pa_price" value="<?php esc_html_e('Price', 'assemble'); ?>" />
	<input type="hidden" id="pa_subtotal" value="<?php esc_html_e('Subtotal', 'assemble'); ?>" />
	<input type="hidden" id="pa_total" value="<?php esc_html_e('Total', 'assemble'); ?>" />
	<input type="hidden" id="x" value="<?php esc_html_e('X', 'assemble'); ?>" />
	
	<input type="hidden" id="pa_required_category" value="<?php esc_html_e('This Categories Is Required', 'assemble'); ?>" />
  
	<div class="pa_parent">
		<img width="70" src="<?php echo esc_url( PA_PUBLIC_URL . 'images/loader3.webp'); ?>" />
	</div>
  

  <div class="pa_share">
	<div>
		<span class="close">✖</span>
		<h3><?php esc_html_e("Your Builed Saved", 'assemble'); ?></h3>

		<div class="pa_share_box">
		</div>
	</div>

	
  </div>

    <form class="cart pa_form" action="<?php the_permalink(); ?>" method="post" enctype="multipart/form-data">

		<input type="hidden" value="<?php echo esc_attr(get_the_id()); ?>" id="system_id" name="system_id" />
		<input type="hidden" value="<?php echo esc_url(home_url()); ?>" id="home_url" name="home_url" />
		<input type="hidden" value="<?php echo esc_url(plugins_url('/pc-assemble-pro/')); ?>" id="plugin_url" name="plugin_url" />
		<input type="hidden" value="<?php echo esc_attr(get_woocommerce_currency_symbol()); ?>" id="currency_symbol" name="currency_symbol" />
		<input type="hidden" value="<?php echo esc_attr( wp_create_nonce('wp_rest') ); ?>" id="wp_rest" />
		<input type="hidden" name="pa_nonce" value="<?php echo esc_attr( wp_create_nonce('pa_nonce') ); ?>" />

		<div id="pa_wrapper">
			<div id="pa_container">
					
					<div id="pa_left">
						<div id="pa_content_wrapper">
							<?php if ( $public->mode == 'multi-tab' ) echo $public->pa_tabs(); ?>
							<?php $public->pa_contents(); ?>
						</div>
					</div>

					<div id="pa_right">
						<div id="pa_left_sticky">
							<img id="left_img" src="<?php echo esc_url( get_the_post_thumbnail_url() ); ?>" width="263" />
							<section id="pa_left_box">
								<h2><?php echo esc_html(get_the_title()); ?></h2>
								
								<p id="pa_left_price_title"><?php esc_html_e('Total Price', 'assemble'); ?></p>

								<p id="pa_left_price" class="pa_left_price">
									<?php echo esc_html( number_format( $public->total_price() ) ) . ' ' . esc_html( get_woocommerce_currency_symbol() ) ; ?>
								</p>
								
								<?php do_action('pcassemble_before_add_to_cart'); ?>
						
								<button id="pa_left_add_to_cart" type="submit" name="add-to-cart" value="<?php echo esc_attr(get_option('pa_main_product')); ?>" class="single_add_to_cart_button button alt"><?php esc_html_e("Add To Cart", "assemble"); ?></button>

								<div class="not_selected_categories">
								</div>

								<div class="pc_assemble_export">
								<?php 
								$design = (array) get_option('_pa_design_settings');
								if ( get_option('pa_share_button', 0) == '1' ):
								?>
									<svg class="pc_assemble_export_share" width="23px" height="23px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M13.803 5.33333C13.803 3.49238 15.3022 2 17.1515 2C19.0008 2 20.5 3.49238 20.5 5.33333C20.5 7.17428 19.0008 8.66667 17.1515 8.66667C16.2177 8.66667 15.3738 8.28596 14.7671 7.67347L10.1317 10.8295C10.1745 11.0425 10.197 11.2625 10.197 11.4872C10.197 11.9322 10.109 12.3576 9.94959 12.7464L15.0323 16.0858C15.6092 15.6161 16.3473 15.3333 17.1515 15.3333C19.0008 15.3333 20.5 16.8257 20.5 18.6667C20.5 20.5076 19.0008 22 17.1515 22C15.3022 22 13.803 20.5076 13.803 18.6667C13.803 18.1845 13.9062 17.7255 14.0917 17.3111L9.05007 13.9987C8.46196 14.5098 7.6916 14.8205 6.84848 14.8205C4.99917 14.8205 3.5 13.3281 3.5 11.4872C3.5 9.64623 4.99917 8.15385 6.84848 8.15385C7.9119 8.15385 8.85853 8.64725 9.47145 9.41518L13.9639 6.35642C13.8594 6.03359 13.803 5.6896 13.803 5.33333Z" fill="<?php echo esc_attr( $design['social_icon_color'] ); ?>"/>
</svg>
								<?php endif; 
								
								//if ( get_option('pa_email_button', 0) == '1' ):
								?>

								<!--<svg class="pc_assemble_export_email" width="23px" height="23px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="21" height="21" fill="transparent"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.96802 4H18.032C18.4706 3.99999 18.8491 3.99998 19.1624 4.02135C19.4922 4.04386 19.8221 4.09336 20.1481 4.22836C20.8831 4.53284 21.4672 5.11687 21.7716 5.85195C21.9066 6.17788 21.9561 6.50779 21.9787 6.83762C22 7.15088 22 7.52936 22 7.96801V16.032C22 16.4706 22 16.8491 21.9787 17.1624C21.9561 17.4922 21.9066 17.8221 21.7716 18.1481C21.4672 18.8831 20.8831 19.4672 20.1481 19.7716C19.8221 19.9066 19.4922 19.9561 19.1624 19.9787C18.8491 20 18.4706 20 18.032 20H5.96801C5.52936 20 5.15088 20 4.83762 19.9787C4.50779 19.9561 4.17788 19.9066 3.85195 19.7716C3.11687 19.4672 2.53284 18.8831 2.22836 18.1481C2.09336 17.8221 2.04386 17.4922 2.02135 17.1624C1.99998 16.8491 1.99999 16.4706 2 16.032V7.96802C1.99999 7.52937 1.99998 7.15088 2.02135 6.83762C2.04386 6.50779 2.09336 6.17788 2.22836 5.85195C2.53284 5.11687 3.11687 4.53284 3.85195 4.22836C4.17788 4.09336 4.50779 4.04386 4.83762 4.02135C5.15088 3.99998 5.52937 3.99999 5.96802 4ZM4.31745 6.27777C4.68114 5.86214 5.3129 5.82002 5.72854 6.1837L11.3415 11.095C11.7185 11.4249 12.2815 11.4249 12.6585 11.095L18.2715 6.1837C18.6871 5.82002 19.3189 5.86214 19.6825 6.27777C20.0462 6.69341 20.0041 7.32517 19.5885 7.68885L13.9755 12.6002C12.8444 13.5899 11.1556 13.5899 10.0245 12.6002L4.41153 7.68885C3.99589 7.32517 3.95377 6.69341 4.31745 6.27777Z" fill="<?php echo esc_attr( $design['social_icon_color'] ); ?>"/>
</svg>-->
								<?php //endif; 
								if ( get_option('pa_print_button', 0) == '1' ):
								?>
								<svg class="pc_assemble_export_print" version="1.1" id="Uploaded to svgrepo.com" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
	 width="14px" height="14px" viewBox="0 0 32 32" xml:space="preserve">
<style type="text/css">
	.puchipuchi_een{fill:<?php echo esc_html( $design['social_icon_color'] ); ?>;}
</style>
<path class="puchipuchi_een" d="M26,9H6V3c0-1.1,0.9-2,2-2h16c1.1,0,2,0.9,2,2V9z M6,19h20v10c0,1.1-0.9,2-2,2H8c-1.1,0-2-0.9-2-2
	V19z M10,23c0,0.552,0.447,1,1,1h10c0.553,0,1-0.448,1-1s-0.447-1-1-1H11C10.447,22,10,22.448,10,23z M10,27c0,0.552,0.447,1,1,1h10
	c0.553,0,1-0.448,1-1s-0.447-1-1-1H11C10.447,26,10,26.448,10,27z M31,12v7c0,1.1-0.9,2-2,2h-2v-3H5v3H3c-1.1,0-2-0.9-2-2v-7
	c0-1.1,0.9-2,2-2h26C30.1,10,31,10.9,31,12z M5,13c0-0.552-0.448-1-1-1s-1,0.448-1,1c0,0.552,0.448,1,1,1S5,13.552,5,13z M8,13
	c0-0.552-0.448-1-1-1s-1,0.448-1,1c0,0.552,0.448,1,1,1S8,13.552,8,13z"/>
</svg>
								<?php endif; ?>

								</div>
							
								<div id="fixed_price">
									<span>
										<?php echo esc_html( get_the_title() ); ?> <br>
										<span class="pa_left_price2"><?php echo esc_html( number_format( $public->total_price() ) ) .' '. esc_html( get_woocommerce_currency_symbol() ); ?></span>
									</span>
									<button id="pa_left_add_to_cart" type="submit" name="add-to-cart" value="<?php echo esc_attr(get_option('pa_main_product')); ?>" class="single_add_to_cart_button button alt"><?php esc_html_e("Add To Cart", "assemble"); ?></button>
								</div>
								
							</section>
						</div>
					</div>
					
					<?php require 'popup.php' ; ?>
				
			</div>
		</div>
    </form>

    <script src="<?php echo esc_url( PA_PUBLIC_URL .'/js/jquery.js' ); ?>"></script>
    <script src="<?php echo esc_url( PA_PUBLIC_URL .'/js/pa_public.js' ); ?>"></script>

	<?php if( get_option('pa_display_footer') == 1 ): get_footer(); endif; ?>
    <script type="text/javascript">
!function(){
    var i="qnSY2V", a=window, d=document;
    function g(){
        var g=d.createElement("script"),
            s="https://www.goftino.com/widget/"+i,
            l=localStorage.getItem("goftino_"+i);
        g.async=true;
        g.src = l ? s + "?o=" + l : s;
        d.getElementsByTagName("head")[0].appendChild(g);
    }
    "complete"===d.readyState ? g() : a.attachEvent ? a.attachEvent("onload",g) : a.addEventListener("load",g,false);
}();
</script>
  </body>
</html>
