<?php 

add_action('wp_enqueue_scripts', function () {
    if (!is_checkout()) return;

    wp_enqueue_style(
        'checkout-coupons-css',
        'https://jahanbazar.com/wp-content/plugins/some-customize-features/assets/css/checkout-coupons.css',
        [],
        '1.0.0'
    );
});
add_action('wp_enqueue_scripts', function () {
    if (!is_checkout()) return;

    wp_enqueue_script(
        'checkout-coupons-js',
        'https://jahanbazar.com/wp-content/plugins/some-customize-features/assets/js/checkout-coupons.js',
        [],
        '1.0.0',
        true
    );
});


add_action('woocommerce_after_order_notes', function () {
    if (!is_checkout()) return;

    $args = [
        'post_type'   => 'shop_coupon',
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'meta_query'  => [
            [
                'key'     => 'date_expires',
                'value'   => 0,
                'compare' => '>',
                'type'    => 'NUMERIC',
            ]
        ]
    ];

    $coupons = get_posts($args);

    if (!$coupons) return;

    echo '<div class="custom-coupons-box">';
    echo '<h3>🎁 کدهای تخفیف زمان‌دار</h3>';
    echo '<ul>';

    foreach ($coupons as $coupon) {
        $code = $coupon->post_title;
        $description = get_the_excerpt($coupon);
        $expiry_timestamp = get_post_meta($coupon->ID, 'date_expires', true);
        $expiry = $expiry_timestamp ? date_i18n('Y/m/d', $expiry_timestamp) : 'نامشخص';

        echo '<li class="coupon-item">';
        echo '<div class="coupon-header">';
        echo '<span class="coupon-code">' . esc_html($code) . '</span>';
        echo '<button type="button" class="copy-btn" data-code="' . esc_attr($code) . '">کپی</button>';
        echo '</div>';
        echo '<div class="coupon-expiry">تاریخ انقضا: ' . esc_html($expiry) . '</div>';
        if ($description) {
            echo '<div class="coupon-description">' . esc_html($description) . '</div>';
        }
        echo '</li>';
    }

    echo '</ul>';
    echo '</div>';
});
