<?php

add_action('template_redirect', 'redirect_checkout_if_not_logged_in');
function redirect_checkout_if_not_logged_in() {

    $checkout_page_id = get_option('woocommerce_checkout_page_id');

    if (!is_user_logged_in() && is_page($checkout_page_id)) {

        $checkout_url = get_permalink($checkout_page_id);

        $redirect_url = add_query_arg(
            'redirect_to',
            urlencode($checkout_url),
            site_url('/my-account/')
        );

        wp_redirect($redirect_url);
        exit;
    }

    if (is_user_logged_in() && is_page(get_option('woocommerce_myaccount_page_id'))) {

        if (!empty($_GET['redirect_to'])) {

            $redirect_to = esc_url_raw($_GET['redirect_to']);

            wp_redirect($redirect_to);
            exit;
        }
    }
}
