<?php
add_action('woocommerce_single_product_summary', function () {
    if (!current_user_can('manage_woocommerce')) return;

    global $product;
    $product_id = $product->get_id();
    $product_title = $product->get_name(); 
    $price = $product->get_price();
    $sale_price = $product->get_sale_price();
    $stock = $product->get_stock_quantity();
    $sale_start = $product->get_date_on_sale_from() ? $product->get_date_on_sale_from()->date('Y-m-d') : '';
    $sale_end = $product->get_date_on_sale_to() ? $product->get_date_on_sale_to()->date('Y-m-d') : '';
    $dina_meta = get_post_meta($product_id, 'dina_public_meta_value_one', true);
    $snappbox_allowed = get_post_meta($product_id, '_snappbox_allowed', true);
    $nonce = wp_create_nonce('admin_edit_fields');
    $ajax_url = admin_url('admin-ajax.php');
    ?>
    <div id="admin_quick_edit" style="margin-top:40px; padding:20px; border:2px solid #ccc;">
        <h3>🔧 ویرایش سریع محصول (فقط ادمین)</h3>
        <label>عنوان محصول: <input type="text" id="admin_product_title" value="<?php echo esc_attr($product_title); ?>"></label><br><br> 
        <label>قیمت عادی: <input type="number" step="0.01" id="admin_price" value="<?php echo esc_attr($price); ?>"></label><br><br>
        <label>قیمت فروش ویژه: <input type="number" step="0.01" id="admin_sale_price" value="<?php echo esc_attr($sale_price); ?>"></label><br><br>
        <label>تاریخ شروع فروش ویژه: <input type="date" id="admin_sale_start" value="<?php echo esc_attr($sale_start); ?>"></label><br><br>
        <label>تاریخ پایان فروش ویژه: <input type="date" id="admin_sale_end" value="<?php echo esc_attr($sale_end); ?>"></label><br><br>
        <label>موجودی: <input type="number" id="admin_stock" value="<?php echo esc_attr($stock); ?>"></label><br><br>
        <label>گارانتی : <input type="text" id="admin_dina_meta" value="<?php echo esc_attr($dina_meta); ?>"></label><br><br>
        <label>
            <input type="checkbox" id="admin_snappbox_allowed" <?php checked($snappbox_allowed, 'yes'); ?>>
            ارسال با اسنپ باکس
        </label><br><br>
            <label>
        <input type="checkbox" id="admin_has_supplier" <?php checked(get_post_meta($product_id, '_has_supplier', true), 'yes'); ?>>
        این کالا تامین کننده دارد
    </label><br><br>

        <button id="save_admin_edit" data-product="<?php echo $product_id; ?>">💾 ذخیره تغییرات</button>
        <p id="admin_update_result" style="margin-top:10px; color:green;"></p>
    </div>
    <?php
    wp_localize_script('bpu-admin-product-edit-js', 'adminQuickEditConfig', [
        'ajaxUrl' => $ajax_url,
        'nonce'   => $nonce
    ]);
});

add_action('wp_enqueue_scripts', function () {
    if (!current_user_can('manage_woocommerce')) return;

    wp_enqueue_script(
        'bpu-admin-product-edit-js',
        'https://jahanbazar.com/wp-content/plugins/some-customize-features/assets/js/admin-product-edit.js',
        ['jquery'],
        '1.0.0',
        true
    );
});

add_action('wp_ajax_admin_update_product_fields', function () {
    if (!current_user_can('manage_woocommerce')) wp_send_json_error();
    if (!wp_verify_nonce($_POST['_wpnonce'], 'admin_edit_fields')) wp_send_json_error();

    $product_id = intval($_POST['product_id']);
    $product_title = sanitize_text_field($_POST['product_title']); 
    $price = floatval($_POST['price']);
    $sale_price = isset($_POST['sale_price']) && $_POST['sale_price'] !== '' ? floatval($_POST['sale_price']) : '';
    $sale_start = !empty($_POST['sale_start']) ? sanitize_text_field($_POST['sale_start']) : '';
    $sale_end = !empty($_POST['sale_end']) ? sanitize_text_field($_POST['sale_end']) : '';
    $stock = intval($_POST['stock']);
    $dina_meta = isset($_POST['dina_meta']) ? sanitize_text_field($_POST['dina_meta']) : '';
    $snappbox_allowed = isset($_POST['snappbox_allowed']) && $_POST['snappbox_allowed'] === 'yes' ? 'yes' : 'no';

    $product = wc_get_product($product_id);
    if (!$product) wp_send_json_error();

    $product->set_name($product_title); 
    $product->set_regular_price($price);
    $product->set_sale_price($sale_price !== '' ? $sale_price : '');
    $product->set_date_on_sale_from($sale_start ? strtotime($sale_start) : '');
    $product->set_date_on_sale_to($sale_end ? strtotime($sale_end) : '');
    $product->set_stock_quantity($stock);
    $product->save();

    update_post_meta($product_id, 'dina_public_meta_value_one', $dina_meta);
    update_post_meta($product_id, '_snappbox_allowed', $snappbox_allowed);
    $has_supplier = isset($_POST['has_supplier']) && $_POST['has_supplier'] === 'yes' ? 'yes' : 'no';
    update_post_meta($product_id, '_has_supplier', $has_supplier);


    wp_send_json_success();
});

add_filter('woocommerce_package_rates', function($rates, $package) {

    $snappbox_instance_id = 158;

    $allow_snappbox = false;
    foreach (WC()->cart->get_cart() as $cart_item) {
        $product_id = $cart_item['product_id'];
        if (get_post_meta($product_id, '_snappbox_allowed', true) === 'yes') {
            $allow_snappbox = true;
            break;
        }
    }

    $customer_state_id = WC()->customer->get_shipping_state(); // 509
    $customer_city_id  = WC()->customer->get_shipping_city();  // 18269

    if (!$allow_snappbox || $customer_state_id != '509' || $customer_city_id != '18269') {
        foreach ($rates as $rate_key => $rate) {
            $rate_instance_id = isset($rate->instance_id) ? $rate->instance_id : null;
            if ($rate_instance_id == $snappbox_instance_id) {
                unset($rates[$rate_key]);
            }
        }
    }

    return $rates;

}, 20, 2);


add_filter('woocommerce_cart_item_name', function($product_name, $cart_item, $cart_item_key) {
    $product_id = $cart_item['product_id'];

    if (get_post_meta($product_id, '_snappbox_allowed', true) === 'yes') {
        $product_name .= ' <span class="snappbox-badge">امکان ارسال فوری با اسنپ برای تهران</span>';
    }

    if (get_post_meta($product_id, '_has_supplier', true) === 'yes') {
        $product_name .= ' <span class="supplier-badge">موجودی توسط تامین کننده است</span>';
    }

    return $product_name;
}, 10, 3);


add_filter('woocommerce_order_item_name', function($item_name, $item, $is_visible) {
    $product_id = $item->get_product_id();

    if (get_post_meta($product_id, '_snappbox_allowed', true) === 'yes') {
        $item_name .= ' <span class="snappbox-badge">امکان ارسال فوری با اسنپ برای تهران</span>';
    }

    if (get_post_meta($product_id, '_has_supplier', true) === 'yes') {
        $item_name .= ' <span class="supplier-badge">موجودی توسط تامین کننده است</span>';
    }

    return $item_name;
}, 10, 3);

add_filter('woocommerce_my_account_my_orders_columns', function($columns) {
    $columns['badges'] = 'وضعیت ارسال';
    return $columns;
});










// اضافه کردن استایل برای بج
add_action('wp_head', function() {
    ?>
<style>
.snappbox-badge {
    color: #fff !important;
    background-color: #e74c3c !important;
    padding: 2px 6px !important;
    font-size: 12px !important;
    border-radius: 3px !important;
    margin-left: 5px !important;
    display: inline-block !important;
    white-space: nowrap !important;
    line-height: 1.4 !important;
}

.supplier-badge {
    color: #fff !important;
    background: linear-gradient(135deg, #f5d76e, #f39c12) !important;
    padding: 2px 6px !important;
    font-size: 12px !important;
    border-radius: 3px !important;
    margin-left: 5px !important;
    display: inline-block !important;
    white-space: nowrap !important;
    line-height: 1.4 !important;
}


/* ریسپانسیو موبایل */
@media (max-width: 768px) {
    .snappbox-badge, .supplier-badge {
        font-size: 10px !important;
        padding: 1px 4px !important;
    }
}
</style>




    <?php
});

add_action('admin_head', function() {
    ?>
    <style>
    .snappbox-badge {
        color: #fff !important;
        background-color: #e74c3c !important;
        padding: 2px 6px !important;
        font-size: 12px !important;
        border-radius: 3px !important;
        margin-left: 5px !important;
        display: inline-block !important;
        white-space: nowrap !important;
        line-height: 1.4 !important;
    }

    .supplier-badge {
        color: #fff !important;
        background: linear-gradient(135deg, #f5d76e, #f39c12) !important;
        padding: 2px 6px !important;
        font-size: 12px !important;
        border-radius: 3px !important;
        margin-left: 5px !important;
        display: inline-block !important;
        white-space: nowrap !important;
        line-height: 1.4 !important;
    }
    </style>
    <?php
});










