<?php


if ( ! defined( 'ABSPATH' ) ) exit;

class Woo_Shipping_Popup_Description {

    public function __construct() {
        add_action( 'admin_menu', [ $this, 'add_admin_menu' ] );
        add_action( 'admin_init', [ $this, 'register_settings' ] );
        add_action( 'woocommerce_review_order_after_shipping', [ $this, 'render_popup_html' ] );
        add_action( 'wp_footer', [ $this, 'render_popup_assets' ] );
    }

    public function add_admin_menu() {
        add_menu_page(
            'توضیحات روش‌های حمل‌ونقل',
            'روش‌های حمل‌ونقل',
            'manage_options',
            'shipping-popup-desc',
            [ $this, 'admin_page' ],
            'dashicons-location-alt'
        );
    }

    public function register_settings() {
        register_setting( 'shipping_popup_group', 'shipping_popup_descriptions' );
    }


    private function get_all_shipping_instances() {
        $methods = [];

        // All zones
        $zones = WC_Shipping_Zones::get_zones();

        foreach ( $zones as $zone ) {
            foreach ( $zone['shipping_methods'] as $method ) {
                $methods[ $method->instance_id ] = [
                    'title' => $method->get_title(),
                    'rate_id' => $method->id . ':' . $method->instance_id,
                ];
            }
        }

        $default_zone = new WC_Shipping_Zone(0);
        foreach ( $default_zone->get_shipping_methods() as $method ) {
            $methods[ $method->instance_id ] = [
                'title' => $method->get_title(),
                'rate_id' => $method->id . ':' . $method->instance_id,
            ];
        }

        return $methods;
    }

    public function admin_page() {
        $methods = $this->get_all_shipping_instances();
        $saved   = get_option( 'shipping_popup_descriptions', [] );
        ?>
        <div class="wrap">
            <h1>توضیحات روش‌های حمل‌ونقل (تمام زون‌ها)</h1>
            <form method="post" action="options.php">
                <?php settings_fields( 'shipping_popup_group' ); ?>
                <table class="widefat striped">
                    <thead>
                        <tr>
                            <th>روش حمل‌ونقل</th>
                            <th>توضیحات پاپ‌آپ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ( $methods as $instance_id => $method ) : ?>
                            <tr>
                                <td><?php echo esc_html( $method['title'] ); ?></td>
                                <td>
                                    <textarea name="shipping_popup_descriptions[<?php echo esc_attr( $method['rate_id'] ); ?>]" style="width:100%;min-height:80px;"><?php echo esc_textarea( $saved[ $method['rate_id'] ] ?? '' ); ?></textarea>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }

    public function render_popup_html() {
        echo '<div id="shipping-popup-overlay" style="display:none">
                <div id="shipping-popup">
                    <span class="close">×</span>
                    <div class="content"></div>
                </div>
              </div>';
    }

    public function render_popup_assets() {
        if ( ! is_checkout() ) return;

        $descriptions = get_option( 'shipping_popup_descriptions', [] );
        ?>
        <style>
            #shipping-popup-overlay{
                position:fixed;top:0;left:0;width:100%;height:100%;
                background:rgba(0,0,0,.6);z-index:9999;
                display:flex;align-items:center;justify-content:center;
            }
            #shipping-popup{
                background:#fff;max-width:520px;width:90%;
                border-radius:14px;padding:20px;position:relative;
                animation:fadeIn .25s ease;
            }
            #shipping-popup .close{
                position:absolute;top:10px;left:15px;cursor:pointer;font-size:22px;
            }
            @keyframes fadeIn{from{transform:scale(.95);opacity:0}to{transform:scale(1);opacity:1}}
        </style>
        <script>
            jQuery(function($){
                var descriptions = <?php echo wp_json_encode( $descriptions ); ?>;

                $('form.checkout').on('change','input[name^="shipping_method"]',function(){
                    var val = $(this).val();
                    if(descriptions[val]){
                        $('#shipping-popup .content').html(descriptions[val]);
                        $('#shipping-popup-overlay').fadeIn();
                    }
                });

                $('#shipping-popup-overlay, #shipping-popup .close').on('click',function(e){
                    if(e.target !== this) return;
                    $('#shipping-popup-overlay').fadeOut();
                });
            });
        </script>
        <?php
    }
}

new Woo_Shipping_Popup_Description();