<?php 

defined( 'ABSPATH' ) || exit;

class WACM_Admin_IFSO extends Woocommerce_Attributes_Content{
	 
	function __construct() {
		
		add_action( 'wp_ajax_wacm_ifso_run_trigger', array( $this, 'ajax_run_trigger' ) );
		
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts_' ), 9 );

		add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		
		add_action( 'admin_footer', array( $this, 'admin_footer' ) );
    }
	
	function init() {
		
		global $pagenow;		 
	}
 
	public function admin_enqueue_scripts_() {
		 
		if( $this->has_wacm_page() ){			
			 
			wp_enqueue_script(
				'wacm-admin-ifso',
				plugins_url( '/assets/js/wacm-admin-isfo.js' , WACM_PLUGIN_FILE ),
				array('selectWoo'),
				WACM_VERSION,
				true
			);
		
			wp_enqueue_style(
				'wacm-admin-ifso',
				plugins_url( '/assets/css/wacm-admin-ifso.css' , WACM_PLUGIN_FILE ),
				null,
				WACM_VERSION
			);
		
			$this->set_screen_id();
		}
	}
	 
	public function admin_menu() {
		 
		if ( current_user_can( 'edit_products' ) ) {
				 
			add_submenu_page(
				'edit.php?post_type=product',
				__( 'Attribute If-So', 'wacm' ),
				__( 'Attribute If-So', 'wacm' ),
				 'edit_products',
				'wacm_ifso',
				array( $this , 'attribute_ifso_page_' )
			);
		}
	}
	 
	function ajax_run_trigger() {
		
		global $wpdb;
		 
		$trigger_id = (isset($_POST['trigger_id']) && $_POST['trigger_id']!=-1) ? $_POST['trigger_id'] : '';
		 
		$html = '
			<table class="widefat wp-list-table fixed striped table-view-list">
				<thead>
					<th width="10%" class="manage-column">شناسه</th>
					<th width="40%" class="manage-column">عنوان محصول</th>
					<th width="60%" class="manage-column">تغییرات</th>
				</thead>
				</tbody>
		';
		
		$query = "SELECT * FROM {$wpdb->prefix}options WHERE `option_name` LIKE 'wacm_ifso_{$trigger_id}%'";
		$attrs_ifso_list = $wpdb->get_results($query);
		 
		if(empty($attrs_ifso_list))
			wp_send_json_success([ 'message' => 'no trigger' ]);
		
		foreach($attrs_ifso_list as $row){
			
			$option_name 	= $row->option_name;
			$option_value 	= $row->option_value;

			$data_row		= unserialize($option_value);
			 
			$label_row = '';
			
			$edit_id = $data_row['edit_id'] ?? '';
			if(empty($edit_id)) continue;
			
			$category_if_ids 		= $data_row['category_if_ids'] 		?? [];
			$attribute_if_ids 		= $data_row['attribute_if_ids'] 	?? [];
			$attribute_so_list 		= $data_row['attribute_so_list'] 	?? [];
			
			$tax_query_category 	= [];
			$tax_query_attribute 	= [];
			 
			if(is_array($category_if_ids) && !empty($category_if_ids)){
				
				$tax_query_category = array_map(function($vv){
					 
					return [
					
						'taxonomy' 	=> 'product_cat',
						'field' 	=> 'term_id',
						'terms' 	=>  $vv,
					];
					
				}, $category_if_ids); 
			}
			
			if(is_array($attribute_if_ids) && !empty($attribute_if_ids)){
				
				$tax_query_attribute = array_map(function($vv){
					
					global $wpdb;
					
					[$term_taxonomy_id,$tem_id] = explode('|',$vv);
					
					$query = "SELECT tax.taxonomy as label FROM `{$wpdb->prefix}woocommerce_attribute_taxonomies` as atx
								Inner join `{$wpdb->term_taxonomy}` as tax on tax.taxonomy = CONCAT('pa_',atx.attribute_name)
								Inner join `{$wpdb->terms}` as tm on tm.term_id = tax.term_id
							WHERE tax.term_id = {$tem_id} and tax.term_taxonomy_id = {$term_taxonomy_id}";
					$taxonomy = $wpdb->get_var($query);
				  
					return [
							'taxonomy' 	=> $taxonomy,
							'field' 	=> 'term_id',
							'terms' 	=> $tem_id, 
						];
					
				}, $attribute_if_ids);
			}
			
			$tax_query = array_merge($tax_query_attribute,$tax_query_category);
			
			$product_ids = get_posts( array(
			
				'post_type' 	=> 'product',
				'numberposts' 	=> -1,
				'post_status' 	=> 'publish',
				'fields' 		=> 'ids,post_titles',
				'tax_query' 	=> [$tax_query],
			));
			
			if(!empty($product_ids)){
				
				foreach ( $product_ids as $vp ) {
					
					$product_id 	= $vp->ID;
					$product_title 	= $vp->post_title;
					 
					$update_product_attrib = get_post_meta($product_id,'_product_attributes',true);
					if( empty($update_product_attrib) ) $update_product_attrib = [];
					 
					if(!empty($attribute_so_list)){
						
						$html_attribute = '';
					
						foreach( $attribute_so_list as $vv ){
						 
							$term_taxonomy = $vv['slug'];
									 	  
							$log_insert_values = [];
							$log_update_values = [];
							
							if($vv['is_taxonomy']){
								
								$tax = wacm_get_attribute_by_slug( $term_taxonomy );
								$attribute_label = $tax->attribute_label ?? '';
										
								if(!empty($vv['values'])){
									
									foreach( $vv['values'] as $term_id ){
										
										$count = $wpdb->get_var("SELECT count(*) FROM `" . $wpdb->terms . "`
											inner join `" . $wpdb->term_taxonomy . "` on " . $wpdb->term_taxonomy . ".term_id = " . $wpdb->terms . ".term_id
											 inner join `" . $wpdb->term_relationships . "` on " . $wpdb->term_relationships . ".term_taxonomy_id = `" . $wpdb->term_taxonomy . "`.term_taxonomy_id
										   inner join `" . $wpdb->posts . "` on " . $wpdb->posts . ".ID = " . $wpdb->term_relationships . ".object_id
										 WHERE " . $wpdb->terms . ".`term_id` = '{$term_id}'
												   and " . $wpdb->term_taxonomy . ".`taxonomy` = '{$term_taxonomy}'
												and " . $wpdb->term_relationships . ".`object_id` = '{$product_id}'
										LIMIT 0,1");
												  
										if(!$count){
											
											$log_insert_values[] = get_term_by('id', $term_id, $term_taxonomy)->name;
											
											wp_set_object_terms(intval($product_id), intval($term_id), $term_taxonomy,true);
										}										
									} 
								}
					
								$update_product_attrib[ sanitize_title($vv['slug']) ] = [
								
									'name'         => $vv['slug'],
									'value'        => '',
									'position'     => count($update_product_attrib),
									'is_visible'   => $vv['is_visible']		?? 0,
									'is_variation' => $vv['is_variable'] 	?? 0,
									'is_taxonomy'  => $vv['is_taxonomy'] 	?? 0,
								];
								
							}else{
								
								$attribute_label 	= $vv['name'] 	?? '';
								$log_insert_values 	= $vv['values']	?? [];
								
								$old_values  = explode('|',$update_product_attrib[ sanitize_title($vv['name']) ]['value'] ?? '');
								
								$new_values  = array_merge($old_values,$vv['values']);
								$new_values  = array_unique($new_values);
								
								$update_product_attrib[ sanitize_title($vv['name']) ] = [
								
									'name'         => $vv['name'],
									'value'        => implode('|', $new_values),
									'position'     => count($update_product_attrib),
									'is_visible'   => $vv['is_visible']		?? 1,
									'is_variation' => $vv['is_variable'] 	?? 0,
									'is_taxonomy'  => $vv['is_taxonomy'] 	?? 1, 
								];   
							}
							
							if(!empty($log_insert_values)){
								
								if(isset($update_product_attrib[ sanitize_title($vv['slug']) ])){
									
									$values_txt = count($log_insert_values)>1 ? 'مقادیر' : 'مقدار';
									
									$html_attribute .= "<li>{$values_txt} <b>". implode(',',$log_insert_values) ."</b> به ویژگی <b>{$attribute_label}</b> اضافه شد </li>";
								}else{
									
									$html_attribute .= "<li> ویژگی <b>{$attribute_label}</b> با {$values_txt} <b>". implode(',',$log_insert_values) ."</b> به جدول مشخصات محصول اضافه شد</li>";
								}
							}
						}
						
						$html_attribute = !empty($html_attribute) ? '<ul>' . $html_attribute . '</ul>' : 'تمامی ویژگی ها از قبل در جدول مشخصات این محصول موجود بود';
						
						$html .= '<tr>'; 
						$html .= '<td><a href="' . esc_url( get_edit_post_link($product_id) ) . '" target="_blank">' . $product_id .'</a></td>';
						$html .= '<td><a href="' . esc_url( get_permalink($product_id) ) . '" target="_blank">' . $product_title .'</a></td>';
						$html .= '<td>'.$html_attribute.'</td>';
						$html .= '</tr>';
						 
						update_post_meta( intval($product_id), '_product_attributes', $update_product_attrib );
					}
				}
			}
		}
		
		$html .= '</tbody>';
		$html .= '</table>';
		
		wp_send_json_success(
			array(
				'title'		=> 'log update product',
				'html'		=> $html,
				'inner'		=> '',
			)
		); 
	}
	
	
	public function attribute_ifso_page_() {
		
		global $current_screen,$wpdb;
		   
		$edit_attributes = [];
		  
		if ( isset($_GET['delete_id']) ) {
			
			$delete_id 			= $_GET['delete_id'];
			$edit_option_name 	= 'wacm_ifso_' . $delete_id;
			
			delete_option($edit_option_name);
			
			wp_redirect( admin_url( '/edit.php?post_type=product&page=wacm_ifso' ) );
		}
		
		if( (isset($_POST['category_if_ids']) || isset($_POST['attribute_if_ids'])) ) {

			$category_if_ids 	= $_POST['category_if_ids']  ?? [];
			$attribute_if_ids 	= $_POST['attribute_if_ids'] ?? [];
			$attribute_names 	= $_POST['attribute_names']  ?? [];
 
			$update_attrs = [];
			
			if(!empty($attribute_names)){
				 
				foreach($attribute_names as $index => $name){
	  
					$name = sanitize_text_field( $name );
					
					$position 		= isset($_POST['attribute_position'][$index]) 	? absint($_POST['attribute_position'][$index]) : 0;
					$is_visible 	= isset($_POST['attribute_visibility'][$index]) ? 1 : 0;
					$is_variable 	= isset($_POST['attribute_variation'][$index]) 	? 1 : 0;
					$is_taxonomy 	= 1;
					 
					$values			= isset($_POST['attribute_values'][$index]) ? $_POST['attribute_values'][$index] : [];

					if(!is_array($values) && !empty($values)){
						
						$values = !is_array($values) ? explode('|', $values) : array();
						foreach($values as $i => $value){
							$values[$i] = esc_textarea($value);
						}
						
						$is_taxonomy = 0;
					}
					
					$update_attrs[] = [
					
						'values' 		=> $values,
						'slug'			=> $name,
						'name' 			=> wc_attribute_label($name),
						'is_visible' 	=> $is_visible,
						'is_variable' 	=> $is_variable,
						'is_taxonomy' 	=> $is_taxonomy,				 		
					];
				}
			}
	
			if ( !isset($_GET['edit_id']) ) {
				  
				$option_name = $wpdb->get_var( "SELECT option_name FROM {$wpdb->prefix}options
													WHERE `option_name` LIKE 'wacm_ifso_%'
										ORDER BY option_id DESC" );
				if(!empty($option_name))
					$edit_id = str_replace('wacm_ifso_','',$option_name)+1;
				else
					$edit_id = 1;
				
				$edit_option_name = 'wacm_ifso_' . $edit_id;
			}else{
				
				$edit_id = $_GET['edit_id'];			
			}
			  
			$update_option['edit_id'] 			= $edit_id;
			$update_option['category_if_ids'] 	= $category_if_ids 	?? [];
			$update_option['attribute_if_ids'] 	= $attribute_if_ids ?? [];
			$update_option['attribute_so_list']	= $update_attrs 	?? [];
			  
			$edit_option_name = 'wacm_ifso_' . $edit_id;
			
			update_option($edit_option_name, $update_option); 
		}
		  
		  
		   
		if ( isset($_GET['edit_id']) ) {
			
			$edit_id = $_GET['edit_id'];
			
			$edit_option_name = 'wacm_ifso_' . $edit_id;
			
			$edit_row = get_option($edit_option_name);
			 
			$edit_category_if_ids 	= $edit_row['category_if_ids']  	?? [];
			$edit_attribute_if_ids	= $edit_row['attribute_if_ids'] 	?? [];
			$edit_attributes		= $edit_row['attribute_so_list'] 	?? [];			
		}
		
		  
		$attribute_taxonomies = wc_get_attribute_taxonomies();
		
		$data['edit_category_if_ids'] 	= $edit_category_if_ids 	?? [];
		$data['edit_attribute_if_ids'] 	= $edit_attribute_if_ids 	?? [];
		$data['edit_attribute_so_list']	= $edit_attribute_so_list	?? [];
		
		$data['edit_attributes']		= $edit_attributes;
		$data['attribute_taxonomies'] 	= $attribute_taxonomies;
		  
		  
		$this->views('attribute-ifso', $data);
	 
	}
	
	function set_screen_id(){
		global $current_screen;
		$screen = get_current_screen();
	 
		if( ($screen->id === 'product_page_wacm_ifso') )
		{
			$current_screen->id = 'product';
  
			add_action( 'admin_enqueue_scripts', array( $this, 'reset_screen_id' ), 11 );
			 
		}	
	}
 
	function reset_screen_id(){
		global $current_screen;
		$current_screen->id = 'product_page_wacm_ifso';
	}
	
	public function admin_footer(){
		 
		if( $this->has_wacm_page() ){			
			 
			include( WACM_ABSPATH . "/views/html-ifso-modal.php" );
		}
	}
	
	function has_wacm_page(){
		
		return (isset($_GET['page']) && 'wacm_ifso'==$_GET['page']) ?? 0;
	}
}

new WACM_Admin_IFSO();
 