<?php

defined( 'ABSPATH' ) || exit;

class WACM_Dokan extends Woocommerce_Attributes_Content{
		    
	function __construct() {
		 
		add_action( 'dokan_enqueue_scripts', array( $this, 'dokan_enqueue_scripts_' ) );
		add_action( 'dokan_product_edit_after_inventory_variants', array( $this, 'product_variation_dokan') );
	 
		add_action( 'wp_footer', array( $this, 'wp_footer' ) );
			
		add_action( 'wp_ajax_wacm_get_load_attribute_content', array( $this, 'get_load_attribute_content' ) );
		add_action( 'wp_ajax_wacm_dokan_pre_attribute', array( $this, 'add_attribute' ) );
	}
	 
	public function get_load_attribute_content(){
	 
		$ID  = absint( $_POST["attributes_content_id"] );

		$post = get_post((int)$ID);
 
		$post_title 	=  $post->post_title;
		$post_name 		=  $post->post_name;
		$post_content	=  unserialize($post->post_content);
 
		$html  = '';
		if( is_array( $post_content ) ){

  			$html .= '<input type="checkbox" id="wacm_check_all" checked="checked"> <label for="wacm_check_all"> <b>' .__( 'Check All', 'wacm' ) . '</b> </label><hr style="margin:10px 0px">';
	 
				foreach ( $post_content as $key => $value ) {
				 
					if( !isset ( $value["name"] ) ) continue;
 					  
					$name		= (string)	$value["name"];
   					$visible 	= (int) 	$value["is_visible"] ?? 1;
					  
					$html .= '<span><input type="checkbox" id="lc_' . $name . '" class="checkbox" checked="checked" name="wacm_load_attribute_names[]" value="' . $name . '">  <lable for="lc_' . $name . '">' . wc_attribute_label( $name ) . '</label></span><br><br>';
				}
			 
 			
		}else{
			
			$html = __( "No result attribute" , "wacm" );
		}
		 
 
		$html_inner = '<div style="display: inline-block;float: right;">
							<span id="load_status"></spna>
						</div>						
						<button id="wacm_btn_load_attributes" class="button button-primary button-large">' . __( 'Add', 'wacm' ) .'</button>';
		wp_send_json_success(
			array(
				'title'		=> $post_title,
				'html'		=> $html,
				'inner'		=> $html_inner,
			)
		);
	}
	
	function add_attribute() {
		
		global $wc_product_attributes;

		ob_start();
		check_ajax_referer( 'add-attribute', 'security' );

		if ( ! isset( $_POST['taxonomy'], $_POST['i'] ) ) {
			wp_die( -1 );
		}
		 
        $thepostid     	= 0;
        $taxonomy      	= sanitize_text_field( $_POST['taxonomy'] );
        $i             	= absint( $_POST['i'] );
		$ai				= absint( $_POST['ai'] );
        $attribute     	= array(
            'name'         => $taxonomy,
            'value'        => '',
            'is_visible'   => apply_filters( 'dokan_attribute_default_visibility', 1 ),
            'is_variation' => apply_filters( 'dokan_attribute_default_is_variation', 0 ),
            'is_taxonomy'  => (substr($taxonomy,0,3)=='pa_') ? 1 : 0
        );

        if ( $taxonomy ) {
            $attribute_taxonomy = $wc_product_attributes[ $taxonomy ];
            $metabox_class[]    = 'taxonomy';
            $metabox_class[]    = $taxonomy;
            $attribute_label    = wc_attribute_label( $taxonomy );
        } else {
            $attribute_label = '';
            $attribute_taxonomy = array();
            $metabox_class[]    = '';
        }
        ob_start();
        dokan_get_template_part( 'products/edit/html-product-attribute', '', array(
            'pro'                => true,
            'i'                  => $i,
            'thepostid'          => $thepostid,
            'taxonomy'           => $taxonomy,
            'attribute_taxonomy' => $attribute_taxonomy,
            'attribute_label'    => $attribute_label,
            'attribute'          => $attribute,
            'metabox_class'      => $metabox_class,
            'position'           => 0
        ) );
		
        $content = ob_get_clean();
        wp_send_json_success( $content );
	}
	
	public function product_variation_dokan(){
	 
		$attributes_content_list = $this->get_attributes_content(); 
		 
		$this->views('product-variation-dokan',array('attributes_content_list'=>$attributes_content_list));
	}
	
	public function get_attributes_content($type=-1){
		global $wpdb;
		
		$defaults_ = $wpdb->get_results("SELECT {$wpdb->posts}.ID,{$wpdb->posts}.post_title,{$wpdb->posts}.post_content,{$wpdb->posts}.post_excerpt
						 FROM {$wpdb->posts} WHERE post_type = 'wacm_default' and post_excerpt LIKE '%\"is_dokan\";i:1%'");	       
						 
		$new_ = array();
		foreach($defaults_ as $value){
			
			$new_[$value->ID]["title"] = $value->post_title;
		}
		
		return $new_;
	}
	 
	
	public function wp_footer() {
		
		if ( $this->is_dokan_edit_product() ){	
		
			$this->views('modal-dokan');
		}
	}
	
	public function dokan_enqueue_scripts_() {
	
		if ( $this->is_dokan_edit_product() ){
					
				wp_enqueue_style(
					'wacm-dokan',
					plugins_url( '/assets/css/wacm-dokan.css' , WACM_PLUGIN_FILE ),
					null,
					WACM_VERSION
				);
				 
				wp_enqueue_script(
					'wacm-dokan',
					plugins_url( '/assets/js/wacm-dokan.js' , WACM_PLUGIN_FILE ),
					array(),
					WACM_VERSION,
					true
				);
				
				wp_localize_script( 'wacm-dokan', 'wacm_dokan',
					array(
						'ajaxurl' 		=> admin_url('admin-ajax.php') ,
						'plugins_url' 	=> plugins_url('', WACM_PLUGIN_FILE ),
						'add_attribute_nonce' => wp_create_nonce( 'add-attribute' ),
						'_nonce' 		=> wp_create_nonce( 'wacm-admin-ajax' ),
					)
				);
		}
	}
	
	public function is_dokan_edit_product(){
			
		global $wp_query;		
		$post_type = get_post_type();
		
		if ( ($post_type =='product' && ( get_query_var( 'edit' ) && is_singular( 'product' ) )) ||
			( isset($_GET['product_id']) && ('edit' == $_GET['action'] ) ) ){
				
			return true;
		}
		return false;
	}
	
}

return new WACM_Dokan();
