<?php

defined( 'ABSPATH' ) || exit;

class Woocommerce_Attributes_Content{
 
    public $version = '3.0812';
 
    private $container = array();
 
	private static $_instance;
	
	public static function instance() {

		if ( is_null( self::$_instance ) ) :
			self::$_instance = new self();
		endif;

		return self::$_instance;
	}
 
    public function __construct() {
		 
        $this->define_constants();

        register_activation_hook( WACM_PLUGIN_FILE, array( $this, 'activate' ) );
        register_deactivation_hook( WACM_PLUGIN_FILE, array( $this, 'deactivate' ) );

        add_action( 'woocommerce_loaded', array( $this, 'init_' ) );
		add_action( 'admin_notices', array( $this, 'admin_notices_' ) );		
		add_action( 'admin_init' ,  array( $this, 'my_plugin_redirect' ));
    }
 
    public function init_() {
		 
        $this->includes();
        $this->init_hooks();
    }
   
    public function __get( $prop ) {
        if ( array_key_exists( $prop, $this->container ) ) {
            return $this->container[ $prop ];
        }

        return $this->{$prop};
    }
 
    public function __isset( $prop ) {
        return isset( $this->{$prop} ) || isset( $this->container[ $prop ] );
    }
  
    public function define_constants() {
		
        define( 'WACM_VERSION', $this->version );       
        define( 'WACM_ABSPATH', dirname( WACM_PLUGIN_FILE ) . '/' );
        define( 'WACM_INCLUDES', WACM_ABSPATH . 'includes' );
		define( 'WACM_POST_TYPE_DEFAULT', 'wacm_default' );
    }
 
    public function activate() {
 
        $installed = get_option( 'WACM_installed' );

        if ( ! $installed ) {
            update_option( 'WACM_installed', time() );
        }
		 
		add_option('wacm_activation_redirect', true);
 
        update_option( 'WACM_VERSION', WACM_VERSION );
    }
 
    public function deactivate() {

    }
 
    public function includes() {

        if ( $this->is_request( 'admin' ) ) {
				 
            require_once WACM_INCLUDES . '/admin/class-wacm-admin.php';
            require_once WACM_INCLUDES . '/admin/class-wacm-admin-df-product.php';
            require_once WACM_INCLUDES . '/admin/class-wacm-admin-ifso.php';
        }
		
		require_once WACM_INCLUDES . '/class-wacm-dokan.php';
		
        require_once WACM_INCLUDES . '/admin/class-wacm-admin-ajax.php';
    }
 
    public function init_hooks() {
		 
		add_action( 'init', array( $this, 'localization_' ) );
    }
	
	function plugins_loaded_() {
    }
	
	function localization_(){
		 
		load_plugin_textdomain( 'wacm', false , plugin_basename( dirname( WACM_PLUGIN_FILE ) )  . '/languages/' );
	}
	
    private function is_request( $type ) {
		
        switch ( $type ) {
            case 'admin' :
                return is_admin();

            case 'ajax' :
                return defined( 'DOING_AJAX' );

            case 'rest' :
                return defined( 'REST_REQUEST' );

            case 'cron' :
                return defined( 'DOING_CRON' );

            case 'frontend' :
                return ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' );
        }
    }
	
	function my_plugin_redirect() {
		 
		if (get_option('wacm_activation_redirect', false)) {
			delete_option('wacm_activation_redirect');
			if(!isset($_GET['activate-multi']))
			{
 				wp_redirect( 'edit.php?post_type=product&page=wacm' );
			}
		}
	}
	
	public function admin_notices_() {
        
        if ( !$this->has_woocommerce() ) {
             
			$plugin_url = self_admin_url( 'plugin-install.php?s=woocommerce&tab=search&type=term' );
			$message    = sprintf( esc_html__( 'WooCommerce Load Group Attributes Product is enabled but not effective. It requires %s  in order to work.', 'wacm' ), '<a href="' . $plugin_url . '">WooCommerce</a>' );

			echo wp_kses_post( sprintf( '<div class="error"><p><strong>%1$s</strong></p></div>', $message ) );
        }

    }

	public function has_woocommerce() {
        return class_exists( 'WooCommerce' );
    }

	public function has_dokan() {
        return class_exists( 'WooCommerce' );
		
			// if( !is_admin() && (function_exists('dokan') || class_exists('WeDevs_Dokan')) && class_exists('Dokan_Pro') ) {
			// }
    }
	
	
	public function views($name,$data=array()){
		
		extract($data);
		
		$path_file = WACM_ABSPATH . 'views/' . $name . '.php';
		
		if( is_file($path_file) ){
			
			require_once( $path_file );	
		}else{
				
			echo '404';	
		}    
	} 
}