<?php
/**
 * Class: Helper for the mirroring operations.
 *
 * Helper class used for extraction / loading classes.
 *
 * @package wsal
 */

declare(strict_types=1);

namespace WSAL\Helpers;

use GuzzleHttp\Promise\Is;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( '\WSAL\Helpers\Mirroring_Helper' ) ) {
	/**
	 * Responsible for the proper class loading
	 */
	class Mirroring_Helper {

		/**
		 * Checks given string for valid tags and returns string (comma separated) with all valid tags
		 *
		 * @param string $tags - String which contains possible tags.
		 *
		 * @return string
		 *
		 * @since 4.4.2.1
		 */
		public static function clean_and_prepare_tags( string $tags ): string {

			$tags = PHP_Helper::string_to_array( $tags );

			if ( ! is_array( $tags ) || empty( $tags ) ) {
				return '';
			}

			foreach ( $tags as $key => &$tag ) {
				if ( ! Validator::validate_mirror_tag( $tag ) ) {
					unset( $tags[ $key ] );
				}
			}
			unset( $tag );

			if ( ! empty( $tags ) ) {
				return \implode( ',', $tags );
			}

			return '';
		}
	}
}
